#define _VER_ "1.14"                         /*!*/

/*-------------------------------------------------------------- INCLUDES */
#include <stdio.h>
#include <io.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>

#include "compatib.h"
#include "err.h"
#include "names.h"
#include "options.h"
/*--------------------------------------------------------------- GLOBALS */
char _ERRname[]="REORDER";
char *_ERRlist[]={
                 "Wrong option: ",
                 "Can't rename file: ",
                 "Can't read file: ",
                 "Can't write file: "
                 };

#define E_OPTION 0
#define E_RENAME 1
#define E_READIN 2
#define E_WRITIN 3

char stitle[]="REORDER.EXE by Speis, Versione "_VER_", mar 92\n\n";
char *susage="USAGE: REORDER [-iijjkk] <filename> {<filename>}\n";
int tabs[]={CMD_TAB,ARG_TAB,COMM_TAB};
int ntab;
int ni=0, no=0;
char *si;                         /* string in & string out */
char so[S_LEN];
FILE *infile, *outfile;
char infname[FNAME_LEN],outfname[FNAME_LEN];


/*------------------------------------------------------------------------*/
/*    char* mygets(FILE *f);                                             */
/*                                                                        */
/*              This routine reads an entire line of the source file f    */
/*              and returns it to the caller (or NULL at EOF)             */
/*              Series of tabs and blanks are returned as a single blank  */
/*              All lines are terminated by '\n'                          */
/*                                                                        */
/*------------------------------------------------------------------------*/
char* mygets(FILE *f)
{
static char v[S_LEN], EOF_got;
int m, c, k=0;

  if (EOF_got) return(NULL);
  m=0;
  do
    {
    c=getc(f);
    if (c=='\t') c=' ';                    /* no tabs for me */
    if (!k)
      v[m++]=(char)c, k=(c==' ');
    else if (c==' ') ;                     /* another blank: skip it */
    else k=0, v[m++]=(char)c;
    }
  while (c!='\n' && c!=';' && c!=EOF);
  if (c==';')                              /* keep comments */
    {
    do v[m++]=(char)(c=getc(f));
    while (c!='\n' && c!=EOF);
    }
  if (c==EOF) v[m-1]='\n',EOF_got=1;
  if (EOF_got && (m==1))
    return(NULL);
  v[m]=(char)0;
  return (v);
}

/*------------------------------------------------------------------------*/
int main(int argc, char **argv)
{
  int i,k;
  int c=0, flag;

  printf(stitle);

  if (argc<2)
    {
    printf(susage);
    exit(0);
    }

  if (argv[1][0]=='-')                       /* allow user choose tabs */
    {
    if (strlen(argv[1])!=7)
      Err(E_OPTION,argv[1]+1);
    if (argc<3)
      {printf(susage); exit(0);}
    argv[1]++;
    for (i=0; i<3; i++)
      tabs[i]= 10*(argv[1][2*i]-'0') + (argv[1][2*i+1]-'0');
    argc--;argv++;
    }

  for (k=1;k<argc;k++)
    {
    strcpy(infname,argv[k]);
    strcpy(outfname,argv[k]);
    RplExt(infname,BAK_EXT);
    OptExt(outfname,ASM_EXT);
    unlink(infname);
    if (rename(outfname,infname)) Err(E_RENAME,outfname);

    infile=fopen (infname,RT);
    outfile=fopen (outfname,WT);

                            /* skip first line to gain VERS compatibility */

    if (!fgets(so,S_LEN,infile)) Err(E_READIN,infname);
    if (fputs(so,outfile)==EOF) Err (E_WRITIN,outfname);

/*------------------------------------------------------------------------*/
/*       OPERATIVE DEFINITIONS                                            */
/*------------------------------------------------------------------------*/
#define OUT(n) fprintf(outfile,"%s",si+n)
#define PUT fprintf(outfile,"%s",so)

#define BLNK(c) ((c==' ')+2*(c=='\n')+3*(c==';'))
#define SPC 1
#define RET 2
#define COM 3

/*                            Let's use a FSA and define its states  */
#define NEWSTRING 1 /*            read a new string and parse it     */
#define PUTOLDNEW 2 /*            put the old string and the new one */
#define JMPNXTTAB 3 /*            jmp to next tab position           */
#define PUTOUTPUT 4 /*            print the outstring if it's worth  */
#define COPYLABEL 5 /*            print stringout or COPYARGOM       */
#define JMPCOMTAB 6 /*            jmp to comment tab stop            */
#define COPYARGOM 7 /*            copy one word to stringout         */

    flag=NEWSTRING;
    while (flag)
      switch(flag)
        {
        case NEWSTRING:
            ni=ntab=0;
            if (!(si=mygets(infile)))
	      {
	      if (no)
		{so[no]=0;PUT;}
	      flag=0;
	      break;
	      }
            switch (BLNK(si[ni]))
              {
              case COM:
              case RET:
                flag=PUTOLDNEW;
                break;
              case SPC:
                flag=JMPNXTTAB;
                break;
              default:
                flag=COPYLABEL;
              }
            break;

        case PUTOLDNEW:
	    if (no) {so[no]=0;PUT;}          /* put evryth already parsed */
            OUT(0);                          /* and add the old string */
            no=0;
            flag=NEWSTRING;
            break;

        case JMPNXTTAB:
            do so[no++]=' ';
              while (no<tabs[ntab]);
            ntab+=(!ntab);                   /* if (ntab==0) ntab=1; */
            while (BLNK(si[ni])==SPC) ni++;
            switch(BLNK(si[ni]))
              {
              case COM: flag=JMPCOMTAB; break;
              case RET: flag=PUTOUTPUT; break;
              default:  flag=COPYARGOM;
              }
            break;

        case COPYLABEL:
            if (no)
              {
              so[no++]='\n';
              so[no]=0;
              PUT;                           /* print all you parsed */
              no=0;
              }                              /* and go on (no break) */

        case COPYARGOM:
            while (!BLNK(si[ni]))
              so[no++]=si[ni++];             /* copy word */
            switch (BLNK(si[ni]))
              {
              case RET: flag=PUTOUTPUT; break;
              case COM: flag=JMPCOMTAB; break;
              case SPC: flag=JMPNXTTAB; break;
              }
            break;


        case JMPCOMTAB:
            do so[no++]=' ';
              while (no<tabs[2]);
            while (si[ni]!='\n')
              so[no++]=si[ni++];
            flag=PUTOUTPUT;
            break;

        case PUTOUTPUT:
            if (no>CMD_TAB || so[no-1]!=':')  /* this is msdos specific */
              {
              so[no++]='\n';
              so[no]=0;
              PUT;
              no=0;
              }
            flag=NEWSTRING;
            break;
        }
    fclose(infile);
    fclose(outfile);
    }
  return(0);
}
