Path: tut!enea!mcvax!uunet!husc6!think!ames!sdcsvax!ucsdhub!jack!crash!paul
From: paul@crash.cts.com (Paul Palacios)
Newsgroups: comp.sys.ibm.pc
Subject: Re: Help with delay funct for MSC
Keywords: sleep function, tic, DELAY routine for MS-C
Message-ID: <2056@crash.cts.com>
Date: 29 Nov 87 08:19:09 GMT
References: <9394@shemp.UCLA.EDU>
Reply-To: crash!crash.CTS.COM!paul (Paul Palacios)
Organization: Crash TS, El Cajon, CA
Lines: 157

In article <9394@shemp.UCLA.EDU> claus@CS.UCLA.EDU () writes:
>I am writing an application in MSC 4.0, and I wish to incorporate time
>delays that are independed of the speed of the machine on which the
>application is run. I couldn't find any appropriate routine in the
>MSC documentation (yes I do have the manual). 
>Something like DELAY(x), where x is 1/18 seconds, would be ideal.
>
>I'm sure something like this exists, can anyone help?

I believe that MS-C supports sleep() which is passed an unsigned int of the 
number of seconds to sleep (wait / delay).  If this is not sufficient or
in fact is not supported by MS-C then you could possibly do the following.

The simplest way I can think of providing this functionality is as follows:

It will be necessary, of course, to create this function, assuming that there
is no apparent equivalent function provided in the libraries of the MSC 4.0
release.

The following function will provide your functionality, but will only sleep
approximately the number of tics passed.  After assembling it, you will have
to link it in to any code which uses the function.

Note:  the following depicts the interface to MSC ver 3.xx.  I believe that it
       would be the same or very similar for MSC v. 4.0.

8088 assembly code to interface to MS-C follows:

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;     Author: Paul Palacios
;    Address:
;	    UUCP: {cbosgd, hplabs!hp-sdd, sdcsvax, nosc}!crash!portnoy!paul
;	    INET: paul@portnoy.cts.com
;	    ARPA: crash!portnoy!paul@nosc.mil
;
; This code is copyright (c) 1987 by Paul Palacios to enforce that:
;
; This code, or any part herein, is to be considered public domain and is to
; be used in any way by any one who cares to make use of it, with the sole
; restriction that it, in all forms, must not be product, or part of a product,
; for sale.  Any use of this code, or part herein, for other than free
; distribution, or in part to any product, or package, must have the expressed
; written consent of the original author (Paul Palacios) to do so.  This code,
; if redistributed or modified and subsequently redistributed, must preserve
; this header.  Any who distribute the binaries of this code, or modified
; versions, must make it clear to the receiving party that the source code is
; available to anyone, at any time, free of charge and must be provided to
; that receiving party upon demand.  All receiving parties must abide by and to
; this copyright notice.
; 
;
;	    ***** Please do not remove this header, thank you. *******
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Functions:
;
;	(void)
;	tsleep(tics) -      number of tics to sleep (18.2tics=approx. 1 sec)
;	unsigned int tics;
;
;	bugs:
;		sleeps only approximately the specified number of tics
;		max sleep for approx. one hour; for more than a second, sleep()
;		should be used.
;
;
;	(void)
;	sleep(seconds) -      number of seconds to sleep 
;	unsigned int second;
;
;	bugs:
;		sleeps only approximately the specified number of seconds
;

_TEXT	SEGMENT  BYTE PUBLIC 'CODE'
_TEXT	ENDS
CONST	SEGMENT  WORD PUBLIC 'CONST'
CONST	ENDS
_BSS	SEGMENT  WORD PUBLIC 'BSS'
_BSS	ENDS
_DATA	SEGMENT  WORD PUBLIC 'DATA'
_DATA	ENDS
DGROUP	GROUP	CONST,	_BSS,	_DATA
	ASSUME  CS: _TEXT, DS: DGROUP, SS: DGROUP, ES: DGROUP
PUBLIC  _tsleep, _sleep
_TEXT      SEGMENT
	PUBLIC	_tsleep
	PUBLIC	_sleep

; tsleep(tics)
; unsigned int tics;
;
_tsleep	proc	near
	push	bp
	mov	bp,sp			; save stack pointer
	sub	sp,2			; space for automatic variable
	push	ax
	push	bx
	push	cx			; save affected registers
	push	dx
	xor	ax,ax			; want function 0 of int 1Ah
	int	1Ah			; (the time of day function)
	mov	[bp-2],dx		; store original time
_ts1:
	xor	ax,ax
	int	1Ah
	mov	bx,[bp-2]
	cmp	bx,dx
	jbe	_ts2
	mov	ax,0ffffh
	sub	ax,bx
	add	dx,ax
	jmp	short _ts3
_ts2:
	sub	dx,bx
_ts3:	
	cmp	dx,[bp+4]		; compare to what was passed to us
	jb	_ts1

	pop	dx
	pop	cx
	pop	bx
	pop	ax
	mov	sp,bp
	pop	bp
	ret
_tsleep	endp

; sleep(seconds)
; unsigned int seconds;
;
_sleep	proc	near
	push	bp
	mov	bp,sp
	push	cx
	mov	cx,18			; or replace with code that calculates
	push	cx			; to 18.2 tic / sec requested
	mov	cx,[bp+4]
_sl1:
	call	_tsleep
	loop	_sl1
	add	sp,2
	pop	cx
	pop	bp
	ret
_sleep	endp

_TEXT	ENDS
END
_TEXT	ENDS
END


If there should be a need for further assistance, please feel free to send
me mail.  My address is contained in the copyright notice above.
