title Turbo Pascal - NetWare Interface Module

;+++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+						       +
;+ For the following Turbo Pascal interface see        +
;+ the Borland Turbo Tutor manual and the	       +
;+ Reference Manual				       +
;+						       +
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++
; Modified by Joe R. Doupnik, 13 July 1988 for use with small or large
; memory model of Borland Turbo Pascal Version 4.0
; Assemble by command:  MASM pasneta;
; produces file pasneta.obj
; Use in program: {$L Pasneta}
;
;

lprog	equ	1		; 0 for small memory, 1 for large memory model
				; Modify lprog to match the memory model

	if	lprog
x	equ	6		; prologue overhead for large memory model
	else
x	equ	4		; ditto, small memory model
	endif

begin	macro	name		; begin a function, near or far
	public  name
	if	lprog
name	proc	far
	else
name	proc	near
	endif
	endm
				; define Borland Pascal V4 segments
				; use neither Group nor Class
data	segment word public
data	ends

cseg	segment byte public
	assume	cs:cseg, ds:data, es:nothing


;--------------------------------
; Extended Open a File func(61) (3DH)
;
; var
;	Mode, Handle, RetCode : Integer;
;	Filename	      : String[n];
;
; RetCode := xtndopn(Mode, Handle, Filename);
;

begin	xtndopn
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+x+8]  	; put the mode in ax
	mov	ax,[si]
	mov	ah,03Dh     	; put the function in ah
	lds	dx,[bp+x]   	; ptr to ASCIIZ string
	inc	dx	    	; add 1 to get to the beginning of the string
	int	21h
	jc	xtndopx		; carry set means failure
	lds	di,[bp+x+4]   	; put the handle into the variable
	mov	[di],ax      	; if there is no error and
	xor	ax,ax	     	; return a 0
xtndopx:pop	ds
	pop	bp
	ret	14
xtndopn endp


;--------------------------------
; Get or Set File Attributes(handle) func(67) (43H)
;
; var
;	Func, Attribute, ErrCode : Integer;
;	Filename		 : String[n];
;
;ErrCode := setattr(Func, Attribute, Filename);
;

begin	setattr
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+x+8]  	; put the subfunction in ax
	mov	ax,[si]
	mov	ah,043h     	; put the function in ah
	lds	dx,[bp+x]   	; ptr to var desc block for ASCIIZ string
	inc	dx	    	; add 1 to get the address of the string
	lds	si,[bp+x+4] 	; put the attribute to set in cx
	mov	cx,[si]
	int	21h
	jc	setattx		; carry set means failure
	lds	di,[bp+x+4]   	; put the returned attributes in the
	mov	[di],cx     	; variable if there is no error
	xor	ax,ax	    	; and return zero
setattx:mov	ah,0
	pop	ds
	pop	bp
	ret	14
setattr endp

;--------------------------------
; End of Job Flag Status func(187) (BBH)
;
; var
;	Flag : Integer;
;
;ErrCode := eojstat(Flag);
;

begin	eojstat
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+x]   	; put the flag in ax
	mov	ax,[si]
	mov	ah,0BBh     	; put the function in ah
	int	21h
	mov	ah,0
	lds	di,[bp+x]
	mov	[di],ax
	pop	ds
	pop	bp
	ret	6
eojstat endp


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Physical Record Lock: Log Record   BCH
;
; var
;	ErrCode,FileHandle,HiByteOffset,LoByteOffset : Integer
;	HiLockLen,LoLockLen,Flags,TimeOut	     : Integer
;
;ErrCode := PRLH_Log(FileHandle,HiByteOffset,LoByteOffset,HiLockLen,
;		     LoLockLen,Flags,TimeOut);
;

begin	PRLH_Log
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+x+24]	; FileHandle
	mov	bx,[si]
	lds	si,[bp+x+20]	; ByteOffset
	mov	cx,[si]
	lds	si,[bp+x+16]
	mov	dx,[si]
	lds	si,[bp+x+4]	; AL = Log Flags
	mov	ax,[si]
	lds	si,[bp+x+12]	; LockLen
	mov	si,[si]
	lds	di,[bp+x+8]
	mov	di,[di]
	lds	bp,[bp+x]	; time out
	mov	bp,[bp]
	mov	ah,0BCH
	int	21H
	mov	ah,0		  ; clear the high byte of the return
	pop	ds
	pop	bp
	ret	30
PRLH_Log endp



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Physical Record Lock: Release Rec  BDH
;
; var
;	FileHandle,HiByteOffset,LoByteOffset,ErrCode,
;  HiWordLen,LoWordLen : integer;
; ErrCode := PRLH_Rel(FileHandle,HiByteOffset,LoByteOffset,HiWordLen,
;                           LoWordLen:integer);

begin	PRLH_Rel
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+x+16]	  ; FileHandle
	mov	bx,[si]
	lds	si,[bp+x+12]	  ; HiByteOffset
	mov	cx,[si]
	lds	si,[bp+x+8]	  ; LoByte
	mov	dx,[si]
	lds	si,[bp+x+4]	  ; HiWordLen
	mov	si,[si]
	lds	di,[bp+x]	  ; LoWordLen
	mov	di,[di]
	mov	ah,0BDH
	int	21H
	mov	ah,0
	pop	ds
	pop	bp
	ret	22
PRLH_Rel endp



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Physical Record Lock: Release Clr  BEH
;
; var
; FileHandle,HiByteOffset,LoByteOffset,ErrCode,
;  HiWordLen,LoWordLen : integer;
; ErrCode := PRLH_Rel(FileHandle,HiByteOffset,LoByteOffset,HiWordLen,
;                           LoWordLen:integer);
;

begin	PRLH_Clr
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+x+16]	; FileHandle
	mov	bx,[si]
	lds	si,[bp+x+12]	; ByteOffset
	mov	cx,[si]
	lds	si,[bp+x+8]
	mov	dx,[si]
	lds	si,[bp+x+4]	; HiWordLen
	mov	si,[si]
	lds	di,[bp+x]	; LoWordLen
	mov	di,[di]
	mov	ah,0BEH
	int	21H
	mov	ah,0
	pop	ds
	pop	bp
	ret	22
PRLH_Clr endp


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Physical Record Lock: Log Rec FCB BFH
;
; var
;	ErrCode,fcb,HiByteOffset,LoByteOffset : Integer;
;	HiLockLen,LoLockLen,Flags,TimeOut     : Integer;
;
; ErrCode := PRLF_Log(fcb,HiByteOffset,LoByteOffset,HiLockLen,LoLockLen,Flags,TimeOut);
;

begin	PRLF_Log
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+x+24]	; FCB
	mov	dx,[si]
	lds	si,[bp+x+20]	; ByteOffset
	mov	bx,[si]
	lds	si,[bp+x+16]
	mov	cx,[si]
	lds	si,[bp+x+4]	; AL = Log Flags
	mov	ax,[si]
	lds	si,[bp+x+8]	; low lock length
	mov	di,[si]
	lds	si,[bp+x+12]	; hi lock length
	mov	si,[si]
	mov	bp,[bp+x]	; timeout value
	mov	bp,[bp]
	mov	ah,0BFH
	int	21H
	mov	ah,0
	pop	ds
	pop	bp
	ret	28
PRLF_Log endp



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Physical Record Lock: Rel Rec FCB C0H
;
; var
;	ErrCode,fcb,HiByteOffset,LoByteOffset : Integer;
;
; ErrCode := PRLF_Rel(fcb,HiByteOffset,LoByteOffset);
;

begin	PRLF_Rel
	push	bp
	mov	bp,sp
	push	ds
	lds	dx,[bp+x+8]	; FCB
	lds	si,[bp+x+4]	; ByteOffset
	mov	bx,[si]
	lds	si,[bp+x]
	mov	cx,[si]
	mov	ah,0C0H
	int	21H
	mov	ah,0
	pop	ds
	pop	bp
	ret	12
PRLF_Rel endp



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Physical Record Lock: Clr Rec FCB C1H
;
; var
;	ErrCode,fcb,HiByteOffset,LoByteOffset : Integer;
;
; ErrCode := PRLF_clr(fcb,HiByteOffset,LoByteOffset);
;

begin	PRLF_Clr
	push	bp
	mov	bp,sp
	push	ds
	lds	dx,[bp+x+8]	; FCB
	lds	si,[bp+x+4]	; ByteOffset
	mov	bx,[si]
	lds	si,[bp+x]
	mov	cx,[si]
	mov	ah,0C0H
	int	21H
	mov	ah,0
	pop	ds
	pop	bp
	ret	12
PRLF_Clr endp


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Lock Record Set  C2H
;
; var
;	ErrCode, Flags, TimeOut : Integer;
;
; ErrCode := PRLS_Lck(Flags,TimeOut);
;

begin	PRLS_Lck
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+x+4]	; AL = Lock flag bits
	mov	ax,[si]
	lds	si,[bp+x]	; TimeOut Value
	mov	bp,[si]
	mov	ah,0C2h
	int	21h
	mov	ah,0
	pop	ds
	pop	bp
	ret	10
PRLS_Lck endp



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Release Record Set  C3H
;
; var
;	ErrCode : Integer;
;
; ErrCode := PRLS_Rel;
;

begin	PRLS_Rel
	mov	ah,0C3h
	int	21h
	mov	ah,0
	ret
PRLS_Rel endp



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Clear Record Set  C4H
;
; var
;	ErrCode : Integer;
;
; errcode := PRLS_Clr;
;

begin	PRLS_Clr
	mov	ah,0C4h
	int	21h
	mov	ah,0
	ret
PRLS_Clr endp


;--------------------------------
; Semaphores func(197) (C5H) subfunction 00h
;
; var
;	RetCode,SemaValu,HiHandle,LoHandle,OpenCnt : Integer;
;	Sema4 : String[n];
;
; RetCode := OpenSem(Sema4,SemaValu,HiHandle,LoHandle,OpenCnt);
;

begin	OpenSem
	push	bp
	mov	bp,sp
	push	ds
	lds	dx,[bp+x+16]	; ptr to Semaphore string
;	inc	dx	    	; add 1 to get the address of the string
	lds	si,[bp+x+12]	; set semaphore value
	mov	cx,[si]
	mov	ax,0C500h	; set the function
	int	21h
	mov	bh,00h
	lds	di,[bp+x]	; return the open count
	mov	[di],bx
	lds	di,[bp+x+4]  	; return low handle
	mov	[di],cx
	lds	di,[bp+x+8]	; return high handle
	mov	[di],dx
	mov	ah,00h
	pop	ds
	pop	bp
	ret	22
OpenSem endp


;--------------------------------
; Semaphores func(197) (C5H) subfunction 01h
;
; var
;	RetCode,HiHandle,LoHandle,SemaValu,OpenCnt : Integer;
;
; RetCode := ExamSem(HiHandle,LoHandle,SemaValu,OpenCnt);
;

begin	ExamSem
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+x+12]	; hi handle
	mov	dx,[si]
	lds	si,[bp+x+8]	; lo handle
	mov	cx,[si]
	mov	ax,0C501h	; set function
	int	21h
	lds	di,[bp+x+4]	; return semaphore value
	mov	[di],cx
	mov	dh,00h
	lds	di,[bp+x]
	mov	[di],dx 	; return open count
	mov	ah,00h
	pop	ds
	pop	bp
	ret	16
ExamSem endp


;--------------------------------
; Semaphores func(197) (C5H) subfunction 02h
;
; var
;	RetCode,HiHandle,LoHandle,TimeOut : Integer;
;
; RetCode := WaitSem(HiHandle,LoHandle,TimeOut);
;

begin	WaitSem
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+x+8]	; hi handle
	mov	dx,[si]
	lds	si,[bp+x+4]	; lo handle
	mov	cx,[si]
	lds	si,[bp+x]
	mov	bp,[si] 	; set time out
	mov	ax,0C502h	; set function
	int     21h
	mov	ah,00h
	pop	ds
	pop	bp
	ret	12
WaitSem endp


;--------------------------------
; Semaphores func(197) (C5H) subfunction 03h
;
; var
;	RetCode,HiHandle,LoHandle : Integer;
;
; RetCode := SigSem(HiHandle,LoHandle);
;

begin	SigSem
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+x+4]	; hi handle
	mov	dx,[si]
	lds	si,[bp+x]	; lo handle
	mov	cx,[si]
	mov	ax,0C503h	; set function
	int	21h
	mov	ah,00h
	pop	ds
	pop	bp
	ret	8
SigSem	endp


;--------------------------------
; Semaphores func(197) (C5H) subfunction 04h
;
; var
;	RetCode,HiHandle,LoHandle : Integer;
;
; RetCode := ClosSem(HiHandle,LoHandle);
;

begin	ClosSem
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+x+4]	; hi handle
	mov	dx,[si]
	lds	si,[bp+x]	; lo handle
	mov	cx,[si]
	mov	ax,0C504h	; set function
	int	21h
	mov	ah,00h
	pop	ds
	pop	bp
	ret	8
ClosSem endp


;--------------------------------
; Get or Set Lock Mode func(198) (C6H)
;
; var
;	Mode,Func : Integer;
;
; Mode := setlck(Func);
;

begin	setlck
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+x]
	mov	ax,[si] 	; set the subfunction
	mov	ah,0C6h 	; set the function
	int	21h
	mov	ah,0
	pop	ds
	pop	bp
	ret	4
setlck endp

;--------------------------------
; Transactional Backout func(199) (C7H)
;
; var
;	RetCode, Func : Integer;
;
; RetCode := BakOuts(Func);
;

begin	BakOuts
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+x]	; set the subfunction
	mov	ax,[si]
	mov	ah,0C7h 	; set the function
	int	21h
	mov	ah,0
	pop	ds
	pop	bp
	ret	4
BakOuts endp


;--------------------------------
; Begin transaction  func(200) (C8H)
;
; var
;	RetCode,Mode : Integer;
;
; RetCode := btrans(Mode);
;

begin	btrans
	mov	ah,0C8h
	call	arg1t
	ret	4
btrans	endp



;--------------------------------
; End Transaction func(201) (C9H)
;
; var
;	RetCode : Integer;
;
; RetCode := etrans;
;

begin	etrans
	mov	ah,0C9H
	int	021h
	mov	ah,00h
	ret
etrans	endp



;--------------------------------
; Exc.log File (202) (CA)
;
; var
;	RetCode, FcbAddr : Integer;
;
; RetCode := exclog(FcbAddr);
;

begin	exclog
	mov	ah,0CAH
	call	arg1f
	ret	4
exclog	endp


;--------------------------------
; Exc Lock Set	func(203) (CBH)
;
; var
;	RetCode, Mode : Integer;
;
; RetCode := exclcks(Mode);
;

begin	exclcks
	mov	ah,0CBH
	call	arg1
	ret	4
exclcks endp



;--------------------------------
; Exclusive file unlock (204) (CC)
;
; var
;	RetCode, FcbAddr : Integer;
;
; RetCode := exculkf(FcbAddr);
;

begin	exculkf
	mov	ah,0CCH
	call	arg1f
	ret	4
exculkf endp



;--------------------------------
; Exclusive Unlock Set (205)(CD)
;
; var
;	RetCode : Integer;
;
; RetCode := exculks;
;

begin	exculks
	mov	ah,0CDH
	int	21h
	mov	ah,00h
	ret
exculks endp



;--------------------------------
; Exc Clear file func(206) (CEH)
;
; var
;	RetCode, FcbAddr : Integer;
;
; RetCode := excclrf(FcbAddr);
;

begin	excclrf
	mov	ah,0CEH
	call	arg1f
	ret	4
excclrf endp



;--------------------------------
; Exc Clear Set  func(207) (CFH)
;
; var
;	RetCode : Integer;
;
; RetCode := excclrs;
;

begin	excclrs
	mov	ah,0CFH
	int	21h
	mov	ah,00h
	ret
excclrs endp



;--------------------------------
; Log Record(s) func(208) (D0H)
;
; var
;	RetCode, Flag, Timeout : Integer ;
;	RecStr	: String[n];
;
; RetCode := reclog(RecStr,Flag,Timeout);
;

begin	reclog
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+x+4]	; load flags
	mov	ax,[si]
	lds	si,[bp+x]	; get timeout
	mov	si,[si]
	lds	dx,[bp+x+8]	; get ptr to string
	; inc	dx
	mov	bp,si      	; move timeout to BP
	mov	ah,0D0h
	int	21h
	mov	ah,0
	pop	ds
	pop	bp
	ret	14
reclog	endp


;--------------------------------
; Record Lock func(209) (D1H)
;
; var
;	RetCode, Mode : Integer;
;
; RetCode := reclck(Mode);
;

begin	reclck
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+x]
	mov	bp,[si]
	mov	ah,0D1h
	int	21h
	mov	ah,0
	pop	ds
	pop	bp
	ret	6
reclck	endp



;--------------------------------
; Record Unlock func(210) (D2H)
;
; var
;	RetCode   : Integer;
;	Semaphore : String[n];
;
; RetCode := reculk(Semaphore);
;

begin	reculk
	mov	ah,0D2H
	call	arg1a
	ret	4
reculk	endp



;--------------------------------
; Unlock Record Set func(211) (D3H)
;
; var
;	RetCode : Integer;
;
; RetCode := reculks;
;

begin	reculks
	mov	ah,0D3H
	int	21h
	mov	ah,00h
	ret
reculks endp



;--------------------------------
; Record Clear func(212) (D4H)
;
; var
;	RetCode   : Integer;
;	Semaphore : String[n];
;
; RetCode := recclr(Semaphore);
;

begin	recclr
	mov	ah,0D4H
	call	arg1a
	ret	4
recclr	endp



;--------------------------------
; Clear record set func(213) (D5H)
;
; var
;	RetCode : Integer;
;
; RetCode := recclrs;
;

begin	recclrs
	mov	ah,0D5H
	int	21h
	mov	ah,00h
	ret	4
recclrs endp



;--------------------------------
; End of Job  func(214) (D6H)
;
; var
;	RetCode : Integer;
;
; RetCode := eoj;
;

begin	eoj
	mov	ah,0D6H
	int	21h
	mov	ah,00h
	ret	4
eoj	endp



;--------------------------------
; Logout System  func(215) (D7H)
;
; var
;	RetCode : Integer;
;
; RetCode := sysout;
;

begin	sysout
	mov	ah,0D7H
	int	21h
	mov	ah,00h
	ret	4
sysout	endp



;--------------------------------
; Vol Statistics func(218) (DAH)
;
; var
;	RetCode,volume : Integer;
;	reply  : String[n];
;
; RetCode := volstat(volume, reply);

begin	volstat
	mov	ah,0DAh
	push	bp
	mov	bp,sp
	push	ds
	push	es
	lds	si,[bp+x+4]	; addr for the volume number
	mov	dx,[si]		; get the volume number
	les	di,[bp+x]	; ptr to reply buffer
	inc	di		; add 1 to get the address of the string
	int	21h
	mov	ah,00h
	pop	es
	pop	ds
	pop	bp
	ret	8
volstat endp



;--------------------------------
; Local Disks  func(219) (DBH)
;
; var
;	NumDisks : Integer;
;
; NumDisks := locdrv;
;

begin	locdrv
	mov	ah,0DBH
	int	21h
	mov	ah,00h
	ret
locdrv endp



;--------------------------------
; WorkStation ID func(220) (DCH)
;
; note: This routine returns the station number as an integer.
;	It can also be returned in ASCII with this call.
;
; var
;	StationNum : Integer;
;
; StationNum := wsid;
;

begin	wsid
       mov     ah,0DCH
       int     21h
       mov     ah,00h
       ret
wsid   endp


;--------------------------------
; Set Error mode func(221) (DDH)
;
; var
;	mode : Integer;
;
; errmode(mode);
;


begin	errmode
	mov	ah,0DDH
	call	arg1
	ret	4
errmode endp



;--------------------------------
; Broadcast Mode func(222) (DEH)
;
; var
;	mode : Integer;
;
; bcsmode(mode);
;

begin	bcsmode
	mov	ah,0DEH
	call	arg1
	ret	4
bcsmode endp



;--------------------------------
; Modify LST Device  func(223) (DFH)
;
; var
;	RetCode, Mode : Integer;
;
; RetCode := ctlspl(Mode);
;

begin	ctlspl
	mov	ah,0DFh
	call	arg1
	ret	4
ctlspl	endp



;--------------------------------
; Spool Request func(224) (E0H)
;
; var
;	ErrCode 	    : Integer;
;	RequestBlock, Reply : String[n];
;
; ErrCode := splreq(RequestBlock, Reply);
;

begin	splreq
	mov	ah,0E0h
	call	req_rep
	ret	8
splreq	endp



;--------------------------------
; Pipe Request func(225) (E1H)
;
; var
;	ErrCode 	    : Integer;
;	RequestBlock, Reply : String[n];
;
; ErrCode := pipreq(RequestBlock, Reply);
;

begin	pipreq
	mov	ah,0E1h
	call	req_rep
	ret	8
pipreq	endp



;--------------------------------
; Directory Path func(226) (E2H)
;
; var
;	ErrCode 	    : Integer;
;	RequestBlock, Reply : String[n];
;
; ErrCode := dpath(RequestBlock, Reply);
;

begin	dpath
	mov	ah,0E2h
	call	req_rep
	ret	8
dpath	endp



;--------------------------------
; Login system func(227) (E3H)
;
; var
;	ErrCode 	    : Integer;
;	RequestBlock, Reply : String[n];
;
; ErrCode := syslog(RequestBlock, Reply);
;

begin	syslog
	mov	ah,0E3h
	call	req_rep
	ret	8
syslog	endp



;--------------------------------
; Set File Attribute func(228) (E4H)
;
; var
;	RetCode, FcbAddr, Attribute : Integer;
;
; RetCode := fattr(FcbAddr, Attribute);
;

begin	fattr
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+x]
	mov	cx,[si]		; cx = attribute
	lds	dx,[bp+x+4]	; dx = address of fcb
	mov	ah,0E4h
	int	21h
	mov	ah,0
	pop	ds
	pop	bp
	ret
fattr	endp



;--------------------------------
; Update file size func(229) (E5H)
;
; var
;	ErrCode,FcbAddr : Integer;
;
; ErrCode := updfcb(FcbAddr);
;

begin	updfcb
	mov	ah,0E5H
	call	arg1f
	ret	4
updfcb	endp



;--------------------------------
; Copy File to File func(230) (E6H)
;
; var
;	RetCode,FcbSource,FcbDest : Integer;
;	CountLow, CountHigh	  : Integer;
;
; RetCode := cpyfile(FcbSource, FcbDest, CountLow, CountHigh)
;
;

begin	cpyfile
	mov	ah,0E6h
	push	bp
	mov	bp,sp
	push	ds
	push	es
	lds	si,[bp+x]	; addr of the high byte cnt
	mov	dx,[si]		; dx=high word of byte cnt
	lds	si,[bp+x+4]	; addr low word of byte cnt
	mov	cx,[si]		; cx=low 16 bits of count
	les	di,[bp+x+8]	; address of dest fcb
	lds	si,[bp+x+12]	; address of the source fcb
	int	21h
	mov	ah,0
	pop	es
	pop	ds
	pop	bp
	ret	16
cpyfile endp



;--------------------------------
; get time / date string func(231) (E7H)
;
; var
;	time : String[n];
;
; nettod(time);
;
; where time is a string of the form Y M D H M S
;

begin	nettod
	mov	ah,0E7h
	call	arg1a
	ret	4
nettod	endp



;--------------------------------
; Set Close mode func(232) (E8H)
;
; var
;	mode : Integer;
;
; clsmode(mode);
;

begin	clsmode
	mov	ah,0E8H
	call	arg1wor
	ret	4
clsmode endp


;--------------------------------
; Shell Base Status func(233) (E9H)
;
; var
;	RetFlags, drive : Integer;
;
; RetFlags := drvmap(drive);
;

begin	drvmap
	mov	ax,0E900h
	call	arg1
	ret	4
drvmap	endp


;--------------------------------
; Return Shell Version func(234) (EAH)
;
; var
;	RetCode, Mode : Integer;
;	EnvirStr      : String[n];
;
; RetCode := retshl(EnvirStr, Mode);
;

begin	retshl
	push	bp
	mov	bp,sp
	push	ds
	push	es
	les	di,[bp+x+4]	; set es:di to point at the buffer
	inc	di		; point di at the start of the data area
	lds	si,[bp+x]	; put the mode into al
	mov	ax,[si]
	mov	ah,0EAh
	int	21h
	mov	ah,00h
	pop	es
	pop	ds
	pop	bp
	ret	8
retshl	endp


;--------------------------------
; ascii log File (235) (EB)
;
; var
;	RetCode, Flags, TimeOut : Integer;
;	Asciiz			: String[n];
;
; RetCode := asclog(Flags, TimeOut, Asciiz);
;

begin	asclog
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+x+8]
	mov	ax,[si]		; flags into al
	lds	dx,[bp+x]	; pointer to the asciiz string
	lds	si,[bp+x+4]
	mov	bp,[si]		; time out into bp
	mov	ah,0EBH
	int	21h
	mov	ah,00h
	pop	ds
	pop	bp
	ret	12
asclog	endp


;--------------------------------
; ASCIIZ file unlock (236) (EC)
;
; var
;	RetCode : Integer;
;	Asciiz	: String[n];
;
; RetCode := asculkf(Asciiz);
;

begin	asculkf
	mov	ah,0ECH
	call	arg1a
	ret	4
asculkf endp


;--------------------------------
; ASCIIZ Clear file func(237) (EDH)
;
; var
;	RetCode : Integer;
;	Asciiz	: String[n];
;
; RetCode := ascclrf(Asciiz);
;

begin	ascclrf
	mov	ah,0EDH
	call	arg1a
	ret	4
ascclrf endp


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Get Physical Station Number  EEH
;
; var
;	StationNo : Integer;
;
; StationNo := Get_PSN;
;

begin	Get_PSN
	mov	ah,0EEh
	int	21h
	mov	ah,0
	ret
Get_PSN endp


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Get Shell Table Addresses (239) EFH
;
; var
;	Mode,Segment,Offset : Integer;
;
; Get_STA(Mode,Segment,Offset);
;

begin	Get_STA
	push	bp
	mov	bp,sp
	push	es
	push	ds
	mov	si,[bp+x+8]	; get the mode
	mov	ax,[si]
	mov	ah,0EFh 	; set the function
	int	21h
	lds	di,[bp+x+4]	; store the segment location
	mov	[di],es
	lds	di,[bp+x]	; store the offset location
	mov	[di],si
	pop	ds
	pop	es
	pop	bp
	ret	12
Get_STA endp


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Set Preferred File Server (240) F0H
;
; var
;	RetServer, Mode, NewServ : Integer;
;
; RetServer := SetServ(Mode,NewServ);
;

begin	SetServ
	push	bp
	mov	bp,sp
	push	ds
	mov	si,[bp+x+4]	; get the mode
	mov	ax,[si]
	mov	di,[bp+x]	; set the preferred server number
	mov	dx,[di]
	mov	ah,0F0h 	; set the function
	int	21h
	mov	ah,0
	pop	ds
	pop	bp
	ret	6
SetServ endp


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Attach/Detach To File Server (241) F1H
;
; var
;	RetCode, Mode, NewServ : Integer;
;
; RetCode := ModServ(Mode,NewServ);
;

begin	ModServ
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+x+4]	; get the mode
	mov	ax,[si]
	lds	di,[bp+x]	; set the preferred server number
	mov	dx,[di]
	mov	ah,0F1h 	; set the function
	int	21h
	mov	ah,0
	pop	ds
	pop	bp
	ret	6
ModServ endp


;-------------------------------
; Place a single integer argument into dx
; with a return code

arg1	proc	near
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+x+2]
	mov	dx,[si]		; dx gets the argument
	int	21h
	mov	ah,0		; clear ah for al return code
	pop	ds
	pop	bp
	ret
arg1	endp

;--------------------------------
; Place a single integer argument into bp
; for use with time outs - with a return code

arg1t	proc	near
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+x+2]
	mov	bp,[si]		; dx gets the argument
	int	21h
	mov	ah,0		; clear ah for al return code
	pop	ds
	pop	bp
	ret
arg1t	endp



;--------------------------------
; Process an fcb address in a
; function call with a return code

arg1f	proc	near
	push	bp
	mov	bp,sp
	push	ds
	lds	dx,[bp+x+2]	; dx gets the argument
	int	21h
	mov	ah,0		; clear ah for al return code
	pop	ds
	pop	bp
	ret
arg1f	endp


;--------------------------------
; Process a single string argument in a
; function call with a return code

arg1a	proc	near
	push	bp
	mov	bp,sp
	push	ds
	lds	dx,[bp+x+2]	; ptr to parameter string
;	inc	dx		; add 1 to get the address of the string
	int	21h
	mov	ah,0		; clear ah for al return code
	pop	ds
	pop	bp
	ret
arg1a	endp



;----------------------------
; Perform a single integer argument
; but without a return code

arg1wor proc	near
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+x+2]
	mov	dx,[si]		; dx gets the arg (or ptr)
	int	21h
	pop	ds
	pop	bp
	ret
arg1wor endp


;----------------------------
; Perform a single string argument
; but without a return code

arg1awor proc	near
	push	bp
	mov	bp,sp
	push	ds
	lds	dx,[bp+x+2]
	inc	dx		; add 1 to get the start of the string
	int	21h
	pop	ds
	pop	bp
	ret
arg1awor endp


;----------------------------
; Handle a request$ and reply$ function
; with error code

req_rep proc	near
	push	bp
	mov	bp,sp
	push	ds
	push	es
	lds	si,[bp+x+6]	; ptr to req. string
	inc	si		; add 1 to get the address of the string
	les	di,[bp+x+2]	; ptr to var desc block for reply buf
	inc	di		; add 1 to get the address of the string
	pushf			; save the direction flag
	int	21h
	popf
	mov	ah,0
	pop	es
	pop	ds
	pop	bp
	ret
req_rep endp
cseg	ends
	end
