{ OS-CPM80.PAS }
{ put all operating-system specific code in this file }


  procedure listcat;
    { List file names on standard output; written by W. Kempton, loosely
      based on program by Thomas Flemer in TUG Lines v1 n4 }
    { version: January 1985 }
    { CP/M-80 only }
  const
    maxfiles    = 256;
    SearchFirst = 17;
    SearchNext  = 18;
    SetDma      = 26;
    DfltFCB     = $80;

  var
    i,j,k: integer;
    dmabuf:  array [1..130] of byte;
    DirBuf: array[1..maxfiles] of packed array [0..11] of char;
    fcb : array[0..36] of byte;
    name : XSTRING ;
    kDB : integer;

   begin
    fcb[0] := 0;                             { set up file control block }
    for i:=1 to 11 do fcb[i]:= ord('?');
    for i:= 12 to 36 do fcb[i] := 0;
    bdos(SetDma, addr(dmabuf) );             { DMA set to local variable }
    i := 0;
    j := bdos(SearchFirst, addr(fcb));
    while (j < 255) and (i < maxfiles) do
      begin
       i := i + 1;
       move (dmabuf[j*32 +1], DirBuf[i], 12); { save name }
       j := bdos(SearchNext, addr(fcb));      { search for next }
      end;
    bdos(SetDma, DfltFCB);                    { restore DMA address }
    for j := 1 to i do                        { write names to STDOUT }
      begin
        k := 1;
        while (k<9) and (DirBuf[j,k]<>' ') do
           begin name[k]:=ord(DirBuf[j,k]);  k:=k+1; end;
        if DirBuf[j,9] <> ' ' then
          begin  { read from kDB, write to k }
            kDB := 9;
            name[k] := ord('.'); k := k+1;
            repeat name[k] := ord(DirBuf[j,kDB]); k := k+1; kDB:=kDB+1;
            until (kDB=12) or (DirBuf[j,kDB] = ' ');
          end;
        for i := 1 to (k-1) do
           name[i] := name[i] mod 128; { clear attribute bits }
        name[k] := ENDSTR;
        PUTSTR(name,STDOUT);PUTC(NEWLINE);{ use K&R STDOUT, not WRITE/WRITELN }
      end;
   end;

