/*
 *  Copyright 2004 the mime4j project
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

using System;
using System.IO;
using System.Text;

using NI.Common;
using NI.Email.Mime.Decoder;
using NUnit.Framework;

namespace NI.Tests.Email.Mime.Decoder {


	/**
	* 
	*
	* @author Niklas Therning
	* @version $Id: QuotedPrintableInputStreamTest.java,v 1.3 2004/10/04 15:36:44 ntherning Exp $
	*/
	[TestFixture]
	public class QuotedPrintableInputStreamTest {

		string[] qpEncodedPatterns = new string[] {
			"=e1=e2=E3=E4\r\n",
			"=e1=g2=E3=E4\r\n",
			"   =e1 =e2  =E3\t=E4  \t \t    \r\n",
			"Soft line   = \t \r\nHard line   \r\n",
			"width==\r\n340 height=3d200\r\n",
			
		};
		string[] qpDecodedPatterns = new string[] {
			"\u00e1\u00e2\u00e3\u00e4\r\n",
			"\u00e1=g2\u00e3\u00e4\r\n",
			"   \u00e1 \u00e2  \u00e3\t\u00e4\r\n",
			"Soft line   Hard line\r\n",
			"width=340 height=200\r\n"
		};
		
		byte[] ReadBytes(Stream stream) {
			MemoryStream resultStream = new MemoryStream();
			int b;
			while ( (b = stream.ReadByte() ) != -1 ) {
				resultStream.WriteByte( (byte)b);
			}
			return resultStream.ToArray();			
		}

		[Test]
		public void test_Decode()  {
			MemoryStream memStream = null;
			
			QuotedPrintableInputStream decoder = null;
	        
			for (int i=0; i<qpEncodedPatterns.Length; i++) {
				memStream = new MemoryStream(Encoding.ASCII.GetBytes(qpEncodedPatterns[i]));
				decoder = new QuotedPrintableInputStream(memStream);
				byte[] data = ReadBytes(decoder);
				Assert.AreEqual(
					Encoding.GetEncoding("ISO8859-1").GetString(data),
					qpDecodedPatterns[i], "Pattern "+i.ToString());
			}		
		
		}

	}

}