/*
 *  Copyright 2004 the mime4j project
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
using System;
using System.IO;
using System.Text;

using NI.Email.Mime;
using NUnit.Framework;

namespace NI.Tests.Email.Mime {
	[TestFixture]
	public class RootInputStreamTest {
		
		[Test]
		public void test_Truncate() {
			String s = "Yada yada yada";
			RootInputStream inputStream = 
				new RootInputStream(new MemoryStream( Encoding.ASCII.GetBytes(s) ) );
			Assert.AreEqual( (char)inputStream.ReadByte(), s[0] );
			Assert.AreEqual( (char)inputStream.ReadByte(), s[1] );
			Assert.AreEqual( (char)inputStream.ReadByte(), s[2] );
			Assert.AreEqual( (char)inputStream.ReadByte(), s[3] );

			inputStream.Truncate();
			Assert.AreEqual( inputStream.ReadByte(), -1);
			
			byte[] buf = new byte[100];
			Assert.AreEqual( inputStream.Read(buf), -1 );
			Assert.AreEqual( inputStream.Read(buf, 2, 5), -1 );
		}

		/**
		* Tests that reading single bytes updates the line number appropriately.
		*/
		[Test]
		public void test_ReadSingleByte() {
			String s = "Yada\r\nyada\r\nyada\r\n";
			RootInputStream inputStream = 
				new RootInputStream(new MemoryStream( Encoding.ASCII.GetBytes(s) ) );
	        
			for (int i = 0; i < 6; i++) {
				Assert.AreEqual(inputStream.LineNumber, 1);
				inputStream.ReadByte();
			}
	        
			for (int i = 6; i < 12; i++) {
				Assert.AreEqual(inputStream.LineNumber, 2);
				inputStream.ReadByte();
			}
	        
			for (int i = 12; i < 18; i++) {
				Assert.AreEqual(inputStream.LineNumber, 3);
				inputStream.ReadByte();
			}
	        
			Assert.AreEqual(inputStream.LineNumber, 4);
			Assert.AreEqual(inputStream.ReadByte(), -1);
		}
	    
		/**
		* Tests that reading multiple bytes at once 
		* updates the line number appropriately.
		*/
		[Test]
		public void test_ReadManyBytes() {
			String s = "Yada\r\nyada\r\nyada\r\n";
			RootInputStream inputStream = 
				new RootInputStream(new MemoryStream( Encoding.ASCII.GetBytes(s) ) );
	        
			byte[] buf = new byte[4];
			Assert.AreEqual(inputStream.LineNumber, 1);
			inputStream.Read(buf, 0, 4);
			Assert.AreEqual(inputStream.LineNumber, 1);
			inputStream.Read(buf, 0, 4);
			Assert.AreEqual(inputStream.LineNumber, 2);
			inputStream.Read(buf, 0, 4);
			Assert.AreEqual(inputStream.LineNumber, 3);
			inputStream.Read(buf, 0, 4);
			Assert.AreEqual(inputStream.LineNumber, 3);
			inputStream.Read(buf, 0, 4);
			Assert.AreEqual(inputStream.LineNumber, 4);
	        
			Assert.AreEqual(inputStream.ReadByte(), -1);
		}
	}


}