using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Win32.SafeHandles;
using System.Runtime.InteropServices;
using System.IO;

namespace SampleN
{
  class LongFileAndDirectoryManager
  {
    #region DllImopt

    [DllImport("LongPathLibraryDLL.dll", SetLastError = true, CharSet = CharSet.Unicode)]
    [return: MarshalAs(UnmanagedType.Bool)]
    private extern static bool RemoveDirectoryL(string dirToRemove);

    public static bool RemoveDirectory(string dirToRemove)
    {
        bool removed = RemoveDirectoryL(dirToRemove);
        int lastWin32Error = Marshal.GetLastWin32Error();
        if (lastWin32Error == 0x5)
            throw new Exception("Unnacceptable in trial mode.");
        return removed;
    }

    [DllImport("LongPathLibraryDLL.dll", SetLastError = true, CharSet = CharSet.Unicode)]
    [return: MarshalAs(UnmanagedType.Bool)]
    private static extern bool CreateDirectoryL(string lpPathName, IntPtr lpSecurityAttributes);

    public static bool CreateDirectory(string lpPathName, IntPtr lpSecurityAttributes)
    {
        bool created = CreateDirectoryL(lpPathName, lpSecurityAttributes);
        int lastWin32Error = Marshal.GetLastWin32Error();
        if (lastWin32Error == 0x5)
            throw new Exception("Unnacceptable in trial mode.");
        return created;
    }

    [DllImport("LongPathLibraryDLL.dll", SetLastError = true, CharSet = CharSet.Unicode)]
    [return: MarshalAs(UnmanagedType.Bool)]
    private static extern bool CopyFileL(string lpExistingFileName, string lpNewFileName, bool bFailIfExists);

    public static bool CopyFile(string lpExistingFileName, string lpNewFileName, bool bFailIfExists)
    {
        bool copied = CopyFileL(lpExistingFileName, lpNewFileName, bFailIfExists);
        int lastWin32Error = Marshal.GetLastWin32Error();
        if (lastWin32Error == 0x5)
            throw new Exception("Unnacceptable in trial mode.");
        return copied;
       
    }

    [DllImport("LongPathLibraryDLL.dll", CharSet = CharSet.Unicode)]
    private static extern uint GetFileAttributesL(string lpFileName);

    public static uint GetFileAttributes(string lpFileName)
    {
        uint getFilesAttr = GetFileAttributesL(lpFileName);
        int lastWin32Error = Marshal.GetLastWin32Error();
        if (lastWin32Error == 0x5)
          throw new Exception("Unnacceptable in trial mode.");
        return getFilesAttr;
    }

    [DllImport("LongPathLibraryDLL.dll", SetLastError = true, CharSet = CharSet.Unicode)]
    private static extern SafeFileHandle CreateFileL(
      string lpFileName,
      EFileAccess dwDesiredAccess,
      EFileShare dwShareMode,
      IntPtr lpSecurityAttributes,
      ECreationDisposition dwCreationDisposition,
      EFileAttributes dwFlagsAndAttributes,
      IntPtr hTemplateFile);

    public static SafeFileHandle CreateFile(
    string lpFileName,
    EFileAccess dwDesiredAccess,
    EFileShare dwShareMode,
    IntPtr lpSecurityAttributes,
    ECreationDisposition dwCreationDisposition,
    EFileAttributes dwFlagsAndAttributes,
    IntPtr hTemplateFile)
    {
        SafeFileHandle safeFileHandle = CreateFileL(lpFileName, dwDesiredAccess, dwShareMode, lpSecurityAttributes, dwCreationDisposition, dwFlagsAndAttributes, hTemplateFile);
        int lastWin32Error = Marshal.GetLastWin32Error();
        if (lastWin32Error == 0x5)
          throw new Exception("Unnacceptable in trial mode.");
        return safeFileHandle;
    }

    [DllImport("LongPathLibraryDLL.dll", SetLastError = true, CharSet = CharSet.Unicode)]
    [return: MarshalAs(UnmanagedType.Bool)]
    private static extern bool DeleteFileL(string lpFileName);

    public static bool DeleteFile(string lpFileName)
    {
        bool deleted = DeleteFileL(lpFileName);
        int lastWin32Error = Marshal.GetLastWin32Error();
        if (lastWin32Error == 0x5)
          throw new Exception("Unnacceptable in trial mode.");
        return deleted;
    }

    [DllImport("LongPathLibraryDLL.dll", SetLastError = true, CharSet = CharSet.Unicode)]
    [return: MarshalAs(UnmanagedType.Bool)]
    private static extern bool MoveFileL(string lpExistingFileName, string lpNewFileName);

    public static bool MoveFile(string lpExistingFileName, string lpNewFileName)
    {
        bool moved = MoveFileL(lpExistingFileName, lpNewFileName);
        int lastWin32Error = Marshal.GetLastWin32Error();
        if (lastWin32Error == 0x5)
          throw new Exception("Unnacceptable in trial mode.");
        return moved;
    }

    [DllImport("LongPathLibraryDLL.dll", SetLastError = true, CharSet = CharSet.Unicode)]
    //[return: MarshalAs(UnmanagedType.Bool)]
    private static extern IntPtr FindFirstFileL(string lpFileName, out WIN32_FIND_DATA lpFindFileData);

    public static IntPtr FindFirstFile(string lpFileName, out WIN32_FIND_DATA lpFindFileData)
    {
        IntPtr findFirstFile = FindFirstFileL(lpFileName, out lpFindFileData);
        int lastWin32Error = Marshal.GetLastWin32Error();
        if (lastWin32Error == 0x5)
          throw new Exception("Unnacceptable in trial mode.");
        return findFirstFile;
    }

    [DllImport("LongPathLibraryDLL.dll", SetLastError = true, CharSet = CharSet.Unicode)]
    [return: MarshalAs(UnmanagedType.Bool)]
    private static extern bool FindNextFileL(IntPtr hFindFile, out WIN32_FIND_DATA lpFindFileData);

    public static bool FindNextFile(IntPtr hFindFile, out WIN32_FIND_DATA lpFindFileData)
    {
        bool findNextFile = FindNextFileL(hFindFile, out lpFindFileData);
        int lastWin32Error = Marshal.GetLastWin32Error();
        if (lastWin32Error == 0x5)
          throw new Exception("Unnacceptable in trial mode.");
        return findNextFile;
    }

    [DllImport("LongPathLibraryDLL.dll", SetLastError = true, CharSet = CharSet.Unicode)]
    [return: MarshalAs(UnmanagedType.Bool)]
    private static extern bool FindCloseL(IntPtr hFindFile);

    public static bool FindClose(IntPtr hFindFile)
    {
        bool findClose = FindCloseL(hFindFile);
        int lastWin32Error = Marshal.GetLastWin32Error();
        if (lastWin32Error == 0x5)
          throw new Exception("Unnacceptable in trial mode.");
        return findClose;
    }
    
    [DllImport("LongPathLibraryDLL.dll", SetLastError = true, CharSet = CharSet.Unicode)]
    [return: MarshalAs(UnmanagedType.Bool)]
    private static extern bool DirectoryExistsL(string lpFileName);

    public static bool DirectoryExists(string lpFileName)
    {
        bool directoryExists = DirectoryExistsL(lpFileName);
        int lastWin32Error = Marshal.GetLastWin32Error();
        if (lastWin32Error == 0x5)
          throw new Exception("Unnacceptable in trial mode.");
        return directoryExists;
    }

    #endregion

    #region ConstantsFlags

    [Flags]
    public enum EFileAccess : uint
    {
      GenericRead = 0x80000000,
      GenericWrite = 0x40000000,
      GenericExecute = 0x20000000,
      GenericAll = 0x10000000,
    }

    [Flags]
    public enum EFileShare : uint
    {
      None = 0x00000000,
      Read = 0x00000001,
      Write = 0x00000002,
      Delete = 0x00000004,
    }

    public enum ECreationDisposition : uint
    {
      New = 1,
      CreateAlways = 2,
      OpenExisting = 3,
      OpenAlways = 4,
      TruncateExisting = 5,
    }

    [Flags]
    public enum EFileAttributes : uint
    {
      Readonly = 0x00000001,
      Hidden = 0x00000002,
      System = 0x00000004,
      Directory = 0x00000010,
      Archive = 0x00000020,
      Device = 0x00000040,
      Normal = 0x00000080,
      Temporary = 0x00000100,
      SparseFile = 0x00000200,
      ReparsePoint = 0x00000400,
      Compressed = 0x00000800,
      Offline = 0x00001000,
      NotContentIndexed = 0x00002000,
      Encrypted = 0x00004000,
      Write_Through = 0x80000000,
      Overlapped = 0x40000000,
      NoBuffering = 0x20000000,
      RandomAccess = 0x10000000,
      SequentialScan = 0x08000000,
      DeleteOnClose = 0x04000000,
      BackupSemantics = 0x02000000,
      PosixSemantics = 0x01000000,
      OpenReparsePoint = 0x00200000,
      OpenNoRecall = 0x00100000,
      FirstPipeInstance = 0x00080000
    }

    [StructLayout(LayoutKind.Sequential)]
    public struct SECURITY_ATTRIBUTES
    {
      public int nLength;
      public IntPtr lpSecurityDescriptor;
      public int bInheritHandle;
    }

    internal static IntPtr INVALID_HANDLE_VALUE = new IntPtr(-1);
    internal static int FILE_ATTRIBUTE_DIRECTORY = 0x00000010;
    internal const int MAX_PATH = 260;
    [StructLayout(LayoutKind.Sequential)]
    internal struct FILETIME
    {
      internal uint dwLowDateTime;
      internal uint dwHighDateTime;
    };

    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
    internal struct WIN32_FIND_DATA
    {
      internal FileAttributes dwFileAttributes;
      internal FILETIME ftCreationTime;
      internal FILETIME ftLastAccessTime;
      internal FILETIME ftLastWriteTime;
      internal int nFileSizeHigh;
      internal int nFileSizeLow;
      internal int dwReserved0;
      internal int dwReserved1;
      [MarshalAs(UnmanagedType.ByValTStr, SizeConst = MAX_PATH)]
      internal string cFileName;
      // not using this
      [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 14)]
      internal string cAlternate;
    }
    #endregion

    public static List<string> GetDirectoriesList(string path)
    {
      List<string> results = new List<string>();
      WIN32_FIND_DATA findData;
      IntPtr findHandle = FindFirstFileL(path + @"\*", out findData);
      if (findHandle != INVALID_HANDLE_VALUE)
      {
        bool found;
        do
        {
          string currentFileName = findData.cFileName;
          // It's a directory; add it to the results.
          if (((int)findData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) != 0)
          {
            if (currentFileName != "." && currentFileName != "..")
            {
              results.Add(Path.Combine(path, currentFileName));
            }
          }
          // Find next.
          found = FindNextFileL(findHandle, out findData);
        }
        while (found);
      }
      // Close the find handle.
      FindCloseL(findHandle);
      return results;
    }

    /// <summary>
    /// Deletes an empty directory from a specified path. 
    /// </summary>
    /// <param name="path">The name of the empty directory to remove. This directory must be writable or empty.</param>
    public static void DirectoryDelete(string path)
    {
      bool removed = RemoveDirectoryL(path);
      int lastWin32Error = Marshal.GetLastWin32Error();
      if (!removed && lastWin32Error != 0)
        throw new System.ComponentModel.Win32Exception(lastWin32Error); ;
    }

    public static string[] GetFiles(string path)
    {
      List<string> results = new List<string>();
      WIN32_FIND_DATA findData;
      IntPtr findHandle = FindFirstFileL(path + @"\*", out findData);
      if (findHandle != INVALID_HANDLE_VALUE)
      {
        bool found = false;
        do
        {
          string currentFileName = findData.cFileName;
          // It's a file; add it to the results.
          if (((int)findData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) == 0)
          {
            results.Add(Path.Combine(path, currentFileName));
          }
          // Find next.
          found = FindNextFileL(findHandle, out findData);
        }
        while (found);
      }
      // Close the find handle.
      FindCloseL(findHandle);
      return results.ToArray();
    }

    /// <summary>
    /// Moves a file or a directory and its contents to a new location.
    /// </summary>
    /// <param name="sourceDirName">The path of the file or directory to move.</param>
    /// <param name="destDirName">The path to the new location for sourceDirName.</param>
  }
}
