using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using SampleN;
using System.Windows.Forms;
using System.Reflection;

namespace RemoveTrailingSpaces
{
  class Program
  {
    static string toAddToEndIfCollision = "1";
    static string toAddToStartIfCollision = "";
    static void Main(string[] args)
    {
      Console.Out.WriteLine("Program recursively renames folders and files to eliminate trailing spaces in names");
      if (args.Length == 0)
      {
        Console.Out.WriteLine("usage: " + Assembly.GetExecutingAssembly().ManifestModule.Name + " FolderToProcessRecursively");
        Console.Out.WriteLine("eg:");
        Console.Out.WriteLine(Assembly.GetExecutingAssembly().ManifestModule.Name + @" c:\temp");
      }
      else
      {
        RemoveTrailingSpaces(args[0]);
      }
    }


    private static void RemoveTrailingSpaces(string folder)
    {
      string[] files = LongFileAndDirectoryManager.GetFiles(folder);
      foreach (string file in files)
      {
        string newFileName = file.Trim();
        if (file.CompareTo(newFileName) != 0)
        {
          try
          {
            //newFileName is supposed to be normal thats why using normal functions
            //cause extended function tells that file "1.txt " and "1.txt" exists
            while (File.Exists(newFileName))
            {
              newFileName = toAddToStartIfCollision + newFileName + toAddToEndIfCollision;
            }
            LongFileAndDirectoryManager.MoveFile(file, newFileName);
          }
          catch (Exception ex)
          {
            Console.Out.WriteLine(ex.Message);
          }
        }
      }
      string[] directories = LongFileAndDirectoryManager.GetDirectoriesList(folder).ToArray();
      foreach (string dirName in directories)
      {
        string newdirName = dirName.Trim();
        if (dirName.CompareTo(newdirName) != 0)
        {
          try
          {
            while (LongFileAndDirectoryManager.DirectoryExists(newdirName))
            {
              newdirName = toAddToStartIfCollision + newdirName + toAddToEndIfCollision;
            }
            LongFileAndDirectoryManager.MoveFile(dirName, newdirName);
          }
          catch (Exception ex)
          {
            Console.Out.WriteLine(ex.Message);
          }
        }
        RemoveTrailingSpaces(newdirName);
      }
    }
  }
}
