/*
 * Copyright 1992 SynOptics Communications, Inc.  All Rights Reserved.
 * SynOptics grants a non-exclusive license to use, copy, modify, and
 * distribute this software for any purpose and without fee, provided
 * that this copyright notice and license appear on all copies and
 * supporting documentation.
 * SynOptics makes no representations about the suitability of this
 * software for any particular purpose.  The software is supplied
 * "AS IS", and SynOptics makes no warranty, either express or implied,
 * as to the use, operation, condition, or performance of the software.
 * SynOptics retains all title and ownership in the software.
 *
 * file: SMEXT.C - Global for SNMP Concise MIB Compiler
 *
 * $Revision:   1.4  $ $Date:   27 Jul 1992 19:52:06  $
 * $Log:   R:/MIBTOOLS/V1.0/SMIC/SRC/SMEXT.C_V  $
 * 
 *    Rev 1.4   27 Jul 1992 19:52:06   gfoster
 * Changed the variable name fNoCheckIndxSeq
 * to fCheckIndxSeq to accommodate the -7
 * option providing stricter index item checking
 * instead of looser checking.
 * 
 *    Rev 1.3   08 Jul 1992 17:30:34   gfoster
 * Removed unnecessary revision comment lines added by
 * PVCS to make revision history easier to read.
 * 
 *    Rev 1.2   29 Jun 1992 20:01:28   gfoster
 * Changed the path name separator character in UNIX
 * from chSepChar = ';' to chSepChar = ':'.
 * 
 *    Rev 1.1   19 Jun 1992 16:04:24   gfoster
 * Copyright text was reformated.
 * 
 * The misspelling of "not-accessible" was corrected.
 * 
 * Dump of Opaque will print size, if given in MIB.
 * 
 * Dumps work with excluded objects.  The OID list
 * name list, and MOSY lists don't print the excluded
 * objects, dumps do.
 * 
 * Corrects print of OID value is not defined.
 * 
 * The OID list also prints the traps in the MIB.
 * 
 *    Rev 1.0   27 May 1992 16:15:40   gfoster
 * Initial revision.
 *
*/
#include <stdio.h>

#ifdef MS_DOS
#include <stdlib.h>
#endif /* MS_DOS */

#include "tds.h"
#include "smscdefs.h"
#include "smstdefs.h"
#include "smsydefs.h"


#ifdef MS_DOS
CHAR chOptChar = '/';           /* program's option character */
CHAR chSepChar = ';';           /* separator char for files in
                                    include environment variable */
CHAR chDirChar = '\\';          /* filename separtor character */
#else
CHAR chOptChar = '-';           /* program's option character */
CHAR chSepChar = ':';           /* separator char for files in
                                    include environment variable */
CHAR chDirChar = '/';           /* filename separtor character */
#endif /* MS_DOS */

PSZ pszSmicIncl;                /* value of include environment */

/* output options */
BOOL fDebugStrTab;              /* dump string table */
BOOL fDebugMOD;                 /* dump module names */
BOOL fDebugOID;                 /* dump OID table */
BOOL fDebugOIDtree;             /* dump OID tree */
BOOL fDebugName;                /* dump names of OID items */
BOOL fDebugIMP;                 /* dump IMP names */
BOOL fDebugAL;                  /* dump Alias names */
BOOL fDebugSMI;                 /* dump SMI names */
BOOL fDebugTRAP;                /* dump trap names */
BOOL fDebugTC;                  /* dump textual conventions */
BOOL fDebugSEQ;                 /* dump Sequences */
BOOL fDebugStats;               /* dump resource statistics */
BOOL fDumpMosy;                 /* dump in Mosy format */
BOOL fDumpExtMosy;              /* dump in Extended Mosy format */
BOOL fDumpInterm;               /* dump in Intermediate format */

/* checking options */
BOOL fCheckRoIndx;              /* check that access for INDEX obs is RO */
BOOL fCheckSEQ;                 /* strong check of seq item syntax */
BOOL fCheckSR;                  /* check that all objects have size/range
                                     where appropriate */
BOOL fCheckISR;                 /* strong check on size/range of
                                     index items */
BOOL fCheckIndxSeq;             /* check that all indx items are in seq */
BOOL fNoCheckTab;               /* no check that TABLE, ROW, SEQUENCE
                                     have related Names */
BOOL fNoSeqTcErr;               /* no error if syntax of item in sequence
                                     doesn't match syntax of object
                                     when object syntax is a TC and
                                     syntax in sequence is base type */
BOOL fAllowIndx;                /* allow INDEX clause for leaf objects */
BOOL fNoUnUsedWarn;             /* no warnings for unused IMPORTs and TCs */
BOOL fAllowAccess;              /* allow "not-accessible" and "write-only"
                                    access on leaf objects */
BOOL fAllowOpt;                 /* allow status of "optional" */
BOOL fAllowDV;                  /* allow default value for counters & gauges */


FILE *fhMsg = stderr;           /* output file for messages */
FILE *fhOut = stdout;           /* output file */

MIBSYM *pOidAvail;              /* available list ptr to oid objects */
MIBSYM *pOidGHL;                /* header of global list of oid objects */
MIBSYM *pOidGTL;                /* tail of global list of oid objects */
USHORT cOidUsed;                /* number of oid objects allocated */
USHORT cOidAlloc;               /* number of oid objects used */

MIBSYM OidRoot;                 /* root of OID tree (note: must be init'ed) */
CHAR szBuf[80];                 /* temp formatting area */


MIBSYM *pModAvail;              /* available list ptr to modules */
MIBSYM *pModGHL;                /* header of global list of modules */
MIBSYM *pModGTL;                /* tail of global list of modules */
USHORT cModUsed;                /* number of modules used */
USHORT cModAlloc;               /* number of modules allocated */

MIBMODREF *pModRefAvail;        /* available list ptr to module refs */
USHORT cModRefUsed;             /* number of module refs used */
USHORT cModRefAlloc;            /* number of module refs allocated */

MIBIMPI *pImpiAvail;            /* available list ptr to imported items */
USHORT cImpiUsed;               /* number of imported items used */
USHORT cImpiAlloc;              /* number of imported items allocated */

MIBSYM *pImpAvail;              /* available list ptr to imported items */
MIBSYM *pImpGHL;                /* header of global list of imports */
MIBSYM *pImpGTL;                /* tail of global list of imports */
USHORT cImpUsed;                /* number of imports used */
USHORT cImpAlloc;               /* number of imports allocated */

MIBSYM *pAlAvail;               /* available list ptr to imported items */
MIBSYM *pAlGHL;                 /* header of global list of imports */
MIBSYM *pAlGTL;                 /* tail of global list of imports */
USHORT cAlUsed;                 /* number of imports used */
USHORT cAlAlloc;                /* number of imports allocated */

MIBSYM *pSmiAvail;              /* available list ptr to smi items */
MIBSYM *pSmiGHL;                /* header of global list of smi items */
MIBSYM *pSmiGTL;                /* tail of global list of smi items */
USHORT cSmiUsed;                /* number of SMI items used */
USHORT cSmiAlloc;               /* number of SMI items allocated */


MIBSYM *pTrAvail;               /* available list ptr to traps */
MIBSYM *pTrGHL;                 /* header of global list of traps */
MIBSYM *pTrGTL;                 /* tail of global list of traps */
USHORT cTrUsed;                 /* number of traps used */
USHORT cTrAlloc;                /* number of traps allocated */

MIBVAR *pVarAvail;              /* available list ptr to trap vars */
USHORT cVarUsed;                /* number of trap variables used */
USHORT cVarAlloc;               /* number of trap variables allocated */

MIBENT *pEntAvail;              /* available list ptr to enterprises */
MIBENT *pEntGHL;                /* header of global list of enterprises */
MIBENT *pEntGTL;                /* tail of global list of enterprises */
USHORT cEntUsed;                /* number of enterprises used */
USHORT cEntAlloc;               /* number of enterprises allocated */


MIBSYM *pSeqAvail;              /* available list ptr to seq objects */
MIBSYM *pSeqGHL;                /* header of global list of seq objects */
MIBSYM *pSeqGTL;                /* tail of global list of seq objects */
USHORT cSeqUsed;                /* number of sequence objects used */
USHORT cSeqAlloc;               /* number of sequence objects allocated */

MIBSEQI *pSeqiAvail;            /* available list ptr to sequence items */
USHORT cSeqiUsed;               /* number of sequence items used */
USHORT cSeqiAlloc;              /* number of sequence items allocated */

MIBSYM *pTcAvail;               /* available list ptr to tc objects */
MIBSYM *pTcGHL;                 /* header of global list of tc objects */
MIBSYM *pTcGTL;                 /* tail of global list of tc objects */
USHORT cTcUsed;                 /* number of tc objects used */
USHORT cTcAlloc;                /* number of tc objects allocated */

MIBENUM *pEnumAvail;            /* available list ptr to enumerated items */
USHORT cEnumUsed;               /* number of enumerated items used */
USHORT cEnumAlloc;              /* number of enumerated items allocated */

MIBINDX *pIndxAvail;            /* available list ptr to index items */
USHORT cIndxUsed;               /* number of index items used */
USHORT cIndxAlloc;              /* number of index items allocated */


BOOL NEAR fPrintIname;          /* flag to print include file names */
BOOL NEAR fNoStr;               /* flag to not output strings */

USHORT NEAR cErr;               /* error counter */
USHORT NEAR cWarn;              /* warning counter */

FILE * NEAR fhIn;               /* current input file handle */
PSZ NEAR pszInFile;             /* current input file name */
PSZ NEAR pszBaseFile;           /* base input file name */
USHORT NEAR usLineNo;           /* current line number */
USHORT NEAR usColNo;            /* current char position on line */
USHORT NEAR usTokLineNo;        /* line where token starts */
USHORT NEAR usTokColNo;         /* column where token starts */
SHORT NEAR sTokType;            /* token type */
PSZ NEAR pszTokVal;             /* literal value of current token */

BYTE * NEAR pbStrSpace;         /* ptr to current string space */
USHORT NEAR usStrSpaceSz;       /* size of current string space */
USHORT NEAR usStrSpaceIndx;     /* current position in string space */
USHORT NEAR usStrSpaceTokIndx;  /* position of start of current token */
USHORT NEAR cStrSpace;          /* number of string spaces */
BYTE * NEAR apbStrSpace[MXCSTRSP]; /* ptrs for string spaces */
USHORT NEAR ausStrSpaceSz[MXCSTRSP]; /* actual amount of space used */

INT NEAR LexChar = ' ';         /* current(or next) input character */
CHAR szTok[2];                  /* place to store single char tokens */
CHAR szNum[MXDFINT+1];          /* place to store a number */


/* end of file: SMEXT.H */
