/*
 * print serial line IP statistics:
 * 	dpstats [-i interval] [-v] [interface] [system] [core] 
 *
 * Copyright (c) 1989 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 *	Van Jacobson (van@helios.ee.lbl.gov), Dec 31, 1989:
 *	- Initial distribution.
 */
/*
 * Copyright (c) 1992 Purdue University
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by Purdue University.  The name of the University may not be used
 * to endorse or promote products derived * from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Note: this copyright applies to portions of this software developed
 * at Purdue beyond the software covered by the original copyright.
 */

#define		PPP

#include <sys/param.h>
#include <sys/mbuf.h>
#include <sys/types.h>
#include <sys/vmmac.h>
#include <sys/socket.h>
#include <sys/file.h>
#include <machine/pte.h>
#include <ctype.h>
#include <errno.h>
#include <nlist.h>
#include <stdio.h>
#include <stdio.h>
#include <signal.h>
#include <net/if.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/ip_var.h>
#include <kvm.h>
#include <fcntl.h>

#include "slcompress.h"
#ifdef	PPP
#define	VJC	1
#define	PPP_STATS	1
#include "slip_var.h"
#include <sys/stream.h>
#include <sys/stropts.h>
#include "dp_str.h"
#else
#include <net/if_slvar.h>
#endif
#ifdef sun
#define KERNBASE KERNELBASE
#endif

struct nlist nl[] = {
#define N_SOFTC 0
#ifdef	PPP
	{ "_dupii" },
#else
	{ "_sl_softc" },
#endif
	"",
};

struct	pte *Sysmap;

char	*system = "/vmunix";
char	*kmemf = "/dev/mem";
kvm_t	*kmem;
int	kflag;
int	vflag;
unsigned interval = 5;
int	unit;


extern	char *malloc();
extern	off_t lseek();

main(argc, argv)
	int argc;
	char *argv[];
{
	--argc; ++argv;
	while (argc > 0) {
		if (strcmp(argv[0], "-v") == 0) {
			++vflag;
			++argv, --argc;
			continue;
		}
		if (strcmp(argv[0], "-i") == 0 && argv[1] &&
		    isdigit(argv[1][0])) {
			interval = atoi(argv[1]);
			if (interval <= 0)
				usage();
			++argv, --argc;
			++argv, --argc;
			continue;
		}
		if (isdigit(argv[0][0])) {
			unit = atoi(argv[0]);
			if (unit < 0)
				usage();
			++argv, --argc;
			continue;
		}
		if (kflag)
			usage();

		system = *argv;
		++argv, --argc;
		if (argc > 0) {
			kmemf = *argv++;
			--argc;
			kflag++;
		}
	}
	kmem = kvm_open(system, kmemf, (char *)0, O_RDONLY, "dpstats");
	if (!kmem) {
		perror(kmemf);
		exit(1);
	}
	if (kvm_nlist(kmem, nl) < 0) {
		fprintf(stderr, "%s: no namelist\n", system);
		exit(1);
	}
	intpr();
	exit(0);
}

usage()
{
	fprintf(stderr,"usage: slstats [-i interval] [-v] [unit] [system] [core]\n");
	exit(1);
}

u_char	signalled;			/* set if alarm goes off "early" */

#define V(offset) ((line % 20)? sc->offset - osc->offset : sc->offset)
#ifndef	PPP
#define AMT (sizeof(*sc) - 2 * sizeof(sc->sc_comp.tstate))
#else
#define AMT (sizeof(*sc))
#endif
/*
 * Print a running summary of interface statistics.
 * Repeat display every interval seconds, showing statistics
 * collected over that interval.  Assumes that interval is non-zero.
 * First line printed at top of screen is always cumulative.
 */
intpr()
{
	register int line = 0;
	int oldmask;
	int catchalarm();
#ifdef	PPP
	struct dp_if_info	*sc, *osc;
	nl[N_SOFTC].n_value += unit * sizeof(struct dp_if_info);
	sc = (struct dp_if_info *)malloc(AMT);
	osc = (struct dp_if_info  *)malloc(AMT);

#else
	struct sl_softc *sc, *osc;
	nl[N_SOFTC].n_value += unit * sizeof(struct sl_softc);
	sc = (struct sl_softc *)malloc(AMT);
	osc = (struct sl_softc *)malloc(AMT);
#endif
	bzero((char *)osc, AMT);

	while (1) {
		kvm_read(kmem, (off_t)nl[N_SOFTC].n_value, (char *)sc, AMT);
		(void)signal(SIGALRM, catchalarm);
		signalled = 0;
		(void)alarm(interval);

		if ((line % 20) == 0) {
			printf("%6.6s %6.6s %6.6s %6.6s %6.6s",
				"in", "pack", "comp", "uncomp", "err");
			if (vflag)
				printf(" %6.6s %6.6s", "toss", "ip");
			printf(" | %6.6s %6.6s %6.6s %6.6s %6.6s",
				"out", "pack", "comp", "uncomp", "ip");
			if (vflag)
				printf(" %6.6s %6.6s", "search", "miss");
			putchar('\n');
		}
#ifdef	PPP
#define	COMP	pii_sc_comp
#define	STATS	pii_stats
#else
#define	COMP	sc_comp
#define	STATS	stats
#endif
		printf("%6d %6d %6d %6d %6d",
			V(STATS.sl_ibytes),
			V(STATS.sl_ipackets),
			V(COMP.sls_compressedin),
			V(COMP.sls_uncompressedin),
			V(COMP.sls_errorin));
		if (vflag)
			printf(" %6d %6d",
				V(COMP.sls_tossed),
				V(STATS.sl_ipackets) -
				  V(COMP.sls_compressedin) -
				  V(COMP.sls_uncompressedin) -
				  V(COMP.sls_errorin));
		printf(" | %6d %6d %6d %6d %6d",
			V(STATS.sl_obytes),
			V(STATS.sl_opackets),
			V(COMP.sls_compressed),
			V(COMP.sls_packets) - V(COMP.sls_compressed),
			V(STATS.sl_opackets) - V(COMP.sls_packets));
		if (vflag)
			printf(" %6d %6d",
				V(COMP.sls_searches),
				V(COMP.sls_misses));

		putchar('\n');
		fflush(stdout);
		line++;
		oldmask = sigblock(sigmask(SIGALRM));
		if (! signalled) {
			sigpause(0);
		}
		sigsetmask(oldmask);
		signalled = 0;
		(void)alarm(interval);
		bcopy((char *)sc, (char *)osc, AMT);
	}
}

/*
 * Called if an interval expires before sidewaysintpr has completed a loop.
 * Sets a flag to not wait for the alarm.
 */
catchalarm()
{
	signalled = 1;
}
