/*
 * Copyright (c) 1992 Purdue University
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by Purdue University.  The name of the University may not be used
 * to endorse or promote products derived * from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Note: this copyright applies to portions of this software developed
 * at Purdue beyond the software covered by the original copyright.
 */

#include <sys/types.h>
#include <sys/param.h>
#include <sys/stream.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <sys/file.h>
#include <sys/dir.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <net/if.h>
#include "dp_str.h"
#include "dpd.h"
#include "dp.h"

/*
**  Log that a call failed.
*/
void
if_callstat(rp, stat)
REMOTE *rp;
char stat;
{
    static char		WHERE[] = "if_callstat";
    int			s;
    struct ifreq	ifr;

    if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
	d_log(DLOG_GENERAL, WHERE, "Can't create socket for \"%s\", %m",
	    rp->Device);
	return;
    }

    (void)strcpy(ifr.ifr_name, rp->Device);
    ifr.ifr_data[0] = stat;
    if (ioctl(s, SIOCICALLSTAT, (caddr_t)&ifr) < 0)
	d_log(DLOG_GENERAL, WHERE, "Can't SIOCICALLSTAT on \"%s\", %m",
	    rp->Device);
    (void)close(s);
}
