/*
**  Copyright (c) 1991 Bolt Beranek and Newman, Inc.
**  All rights reserved.
**
**  Redistribution and use in source and binary forms are permitted
**  provided that: (1) source distributions retain this entire copyright
**  notice and comment, and (2) distributions including binaries display
**  the following acknowledgement:  ``This product includes software
**  developed by Bolt Beranek and Newman, Inc. and CREN/CSNET'' in the
**  documentation or other materials provided with the distribution and in
**  all advertising materials mentioning features or use of this software.
**  Neither the name of Bolt Beranek and Newman nor CREN/CSNET may be used
**  to endorse or promote products derived from this software without
**  specific prior written permission.
**
**  THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
**  WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
**  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*/
/*
 * Copyright (c) 1992 Purdue University
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by Purdue University.  The name of the University may not be used
 * to endorse or promote products derived * from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Note: this copyright applies to portions of this software developed
 * at Purdue beyond the software covered by the original copyright.
 */
#define MAXHOSTS	25		/* Number of known hosts	*/
#define MAXDEVLEN 	8		/* Length of a device name	*/
#define MAXDEVICES	8		/* Number of devices/config	*/
#define MAXFIELDSIZE	30		/* Length of script parameters	*/
#define OPEN_TIMEOUT	10		/* How long to wait for modem	*/
#define TIMEOUT_UNDEF	(-1)		/* No inactivity time defined	*/


#ifndef	MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 64
#endif	/* MAXHOSTNAMELEN */


/*
**  Get the word and bit within the REMOTE.Protocols bitarray (see below).
**  Assumes 32-bit longs.
*/
#define P_WORD(i)		((i) >> 5)
#define P_BIT(i)		(1L << (i & 31))
#define P_SET			1  /* to signal to set the protocol bit */
#define P_RESET			0

/*
**  Return codes from makecall.
*/
#define CALL_SUCCESS	 0	/* Call was made successfully		*/
#define CALL_COMPLETED	 1	/* Call was completed normally		*/
#define CALL_NOMODEM	 2	/* No modem available			*/
#define CALL_PERMISSION  3	/* File or device access/protection problem*/
#define CALL_FAIL	 4	/* Call failed (busy for example)	*/
#define CALL_NOCONNECT   5	/* No connection at far end		*/
#define CALL_NOSETUID	 6	/* Program does not have setuid root	*/
#define CALL_IOCTL_ERR	 7	/* Problem setting IOCTL parameters	*/
#define CALL_BAD_IF	 8	/* Interface name is mis-formed		*/
#define CALL_TTYTIMEOUT	 9	/* Open on Modem line timed out		*/
#define CALL_NOSOCKET	10	/* Unable to get a socket		*/


/*
**  Configuration data for a remote host.
*/
typedef struct _REMOTE {
    /*
     * These fields are basically set from the IF entries.
     */
    char		Device[MAXDEVLEN];	/* dp device to use	*/
    int			Unit;			/* DP Unit number	*/
    struct in_addr	Address;		/* Interface address	*/
    struct in_addr	DstAddress;		/* Destination address	*/
    char		*Sitename;		/* Host name		*/
    char		*Login;			/* Login id (incoming)	*/
    char		*Phone;			/* Phone number		*/
    char		*Script;		/* Login script		*/
    char		**ScriptArgs;		/* Login script	args	*/
    char		*Transcript;		/* Dialing transcript	*/
    int			Transtyle;		/* Transcript style	*/
    char		**PppArgs;		/* Arguments to PPP	*/
    struct _MODEM	**Modems;		/* Modem rotaries	*/
    int			NModems;		/* # of modems/rotaries */
    char		*AuxProgram;		/* Auxilliary program	*/
    char		**AuxArgs;		/* Args for Aux program	*/
    int			LogLevel;		/* Logging Level	*/
    int			AsyncMap;		/* Async Map for PPP */
    /*
     * The following fields are set from the associated Access file.
     */
    u_long		Times[7];		/* calling times	*/
    u_long		Protocols[8];		/* Valid protocols	*/
    int			AllowCount;
    int			DisallowCount;
    struct in_addr	AllowTo[MAXHOSTS];	/* Legal destinations	*/
    struct in_addr	DisallowFrom[MAXHOSTS];	/* Bad sources		*/
    long		DTimeouts[DP_NTIMEOUTS];/* Dailer Timeouts	*/
    long		ATimeouts[DP_NTIMEOUTS];/* Answer Timeouts	*/
} REMOTE;

/*
 * A Rotary can have one or more Modems that are used on a "next available"
 * basis (as opposed to "first available"). This structure can hold information
 * about modems or rotaries depending on the fields as given.
 */

typedef struct _MODEM {
    char *Name;			/* Name of modem or rotary */
    int Flag;			/* Currently unused */
    int NModems;		/* # of modems in rotary (0 if not rotary) */
    int LastUsed;		/* Last modem used in rotary */
    char *Line;			/* Device (modem only) */
    int Speed;			/* Baud rate */
    char *DialScript;		/* Dialing Script */
    char *DialCharMap;		/* Phone Number Character Translations */
    int	AsyncMap;		/* Async Map for PPP */
    struct _MODEM **Modems;	/* List of modems (rotary only) */
} MODEM;

#define TS_LOW		0			/* Low-level transcript	*/
#define TS_HIGH		1			/* Hi-level transcript	*/

extern REMOTE		*findconfig();
extern void		failcall();

extern char		*optarg;
extern int		optind;
extern int		errno;
extern char		*ctime();
extern char		*inet_ntoa();
extern char		*malloc();
extern char		*strchr();
extern char		*strcpy();
extern char		*strncpy();
extern char		*strrchr();
extern char		*strtok();
extern time_t		time();
extern unsigned 	sleep();
extern void		exit();
