/*
 * Copyright (c) 1992 Purdue University
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by Purdue University.  The name of the University may not be used
 * to endorse or promote products derived * from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Note: this copyright applies to portions of this software developed
 * at Purdue beyond the software covered by the original copyright.
 */

#include <stdio.h>
#include <malloc.h>
#include <fcntl.h>
#include <termios.h>
#ifdef	STS
#include <sys/ctio.h>
#endif	STS

char *argv0;
int verbose;

main(argc, argv)
int argc;
char **argv;
{
    char *dev;
    char *file;
    int baud;
    argv0 = argv[0];
    if (argc < 3) {
	fprintf(stderr, "usage: %s [-v] scriptfile device [baud]\n", argv0);
	exit(33);
    }
    if (strcmp(argv[1], "-v") == 0) {
	verbose++;
	argv++;
	argc--;
    }
    file = argv[1];
    if (argv[2][0] == '/')
	dev = argv[1];
    else {
	dev = malloc(strlen(argv[2])+sizeof("/dev/"));
	(void)sprintf(dev, "/dev/%s", argv[2]);
    }
    baud = argc > 3 ? atoi(argv[3]) : 38400;
    setmodem(dev, file, baud);
    exit(0);
}

setmodem(dev, file, baud)
char *dev, *file;
int baud;
{
    FILE *od, *id, *f;
    char lnbuf[256], *l;
    int d;
    int osoft, soft;

    if ((d = open(dev, O_RDWR|O_NDELAY, 0)) < 0) {
	perror(dev);
	exit(34);
    }
    if (!(id = fdopen(d, "r"))) {
	perror(dev);
	exit(34);
    }
    if (!(od = fdopen(d, "w"))) {
	perror(dev);
	exit(34);
    }
    if (!(f = fopen(file, "r"))) {
	perror(file);
	exit(35);
    }
    if (ioctl(d, TIOCGSOFTCAR, &osoft) < 0)
	perror("TIOCGSOFTCAR");
    soft = osoft;
    if (!osoft) {
	soft = 1;
	if (ioctl(d, TIOCSSOFTCAR, &soft) < 0)
	    perror("TIOCSSOFTCAR(1)");
    }
    setbaud(d, baud);
    sendcom(od, id, "AT");
    while (fgets(lnbuf, sizeof(lnbuf), f)) {
	l = lnbuf + strlen(lnbuf) - 1;
	if (*l = '\n')
	    *l = '\0';
	sendcom(od, id, lnbuf);
    }
    if (osoft != soft) {
	soft = 0;
	if (ioctl(d, TIOCSSOFTCAR, &soft) < 0)
	    perror("TIOCSSOFTCAR(0)");
    }
}
#include <errno.h>

#define	TIMEOUT 3

sendcom(o, i, com)
FILE *o, *i;
char *com;
{
    char ln[128], *l;
    int c;
    if (*com == '#') {
	if (verbose)
	    fprintf(stderr, "Setting baud rate to: %s\n", com+1);
	setbaud(fileno(o), atoi(com+1));
	return;
    }
    if (verbose)
	fprintf(stderr, "Send: %s\n", com);
    fputs(com, o);
    putc('\r', o);
    fflush(o);
    errno = 0;
#if	1
    while (fgets(ln, sizeof(ln), i)) {
	l = ln + strlen(ln) - 1;
	while (l >= ln && (*l == '\n' || *l == '\r'))
	    *l-- = '\0';
	if (verbose && ln[0])
	    fprintf(stderr, "Recv: %s\n", ln);
	if (strcmp(ln, "OK") == 0)
	    return;
    }
    if (errno) {
	fprintf(stderr, "%s: ", argv0);
	perror("Error reading from modem");
    }
    else
	fprintf(stderr, "%s: modem timeout\n", argv0);
    exit(38);
#else
    for (l = ln ; l < ln + sizeof(ln)-1 ; l++) {
	if ((c = getc(i)) == EOF) {
	    perror("Error reading from modem");
	    exit(38);
	}
#if	1
	fprintf(stderr, "getc %d '%c'\n", c, c);
#endif
	if (!(c == '\r' || c == '\n')) {
	    *l++ = c;
	    continue;
	}
	*l = '\0';
	if (strcmp(ln, "OK") == 0)
	    return;
	l = ln;
    }
    perror("Error reading from modem");
    exit(39);
#endif
}


setbaud(d, baud)
int d, baud;
{
    int b;
    struct termios t;
    int baudext = 0;
    switch (baud) {
     case 300:	 b = B300; break;
     case 1200:  b = B1200; break;
     case 9600:  b = B9600; break;
     case 19200: b = B19200; break;
     default:
		 fprintf(stderr,
			"Invalid baud rate %d, setting baud rate to 38400\n",
			baud);
     case 38400: b = B38400; break;
#ifdef	STS
     case 57600: b = B38400; baudext = 1; break;
#endif	STS
    }
    if (tcgetattr(d, &t) < 0) {
	perror("tcgetattr");
	exit(36);
    }
    cfsetispeed(&t, b);
    cfsetospeed(&t, b);
    t.c_oflag &= ~OPOST;
    t.c_lflag &= ~(ICANON|ISIG);
    t.c_cc[VTIME] = TIMEOUT*10;
    t.c_cc[VMIN] = 0;
    if (tcsetattr(d, TCSAFLUSH, &t) < 0) {
	perror("tcsetattr");
	exit(36);
    }
#ifdef	STS
    (void)ioctl(d, STSBAUDEXTEN, &baudext);
#endif  STS
}
