
#define DFPALSIZE 768
#define PALBUFSIZE DFPALSIZE/3
#define LUTOFFSET 512

#define ROT	1	/* rotation				*/
#define TRA	2	/* translation				*/
#define SCA	3	/* scale				*/
#define LLO	4	/* light location			*/
#define LCO	5	/* light color				*/
#define KCO	6	/* ka,kd,ks coefficients		*/
#define NSV	7	/* ns value				*/
#define OD2	8	/* use alternate defaults		*/
#define NTS	9	/* use ntsc size viewport		*/
#define VPT	10	/* create user specified viewport	*/
#define ILU	11	/* illumination model [0,1]		*/
#define COL	12	/* color map name			*/
#define BKC	13	/* background RGB color			*/
#define AXS	14	/* draw axes with labels		*/
#define OO8	15	/* output image bits/pixel		*/
#define RLF	16	/* generate relief 			*/
#define WFM	17	/* generate wireframe 			*/
#define OPR	18	/* print current settings		*/
#define SXY	19	/* swap X and Y data dims		*/
#define OPF	20	/* output file name			*/

typedef struct{
	float	v[3];
	float	nv[3];
	long	cv[3];
	int	lut;
}VERTEX_STRUCT;

typedef struct{
	int	vs;
	float	np[3];
}POLY_STRUCT;

typedef int (Func_ptr)();

#define min(X,Y) ( (X) < (Y) ? (X) : (Y) )
#define max(X,Y) ( (X) > (Y) ? (X) : (Y) )

