
/*****************************************************************************
* 
* The following source code is in the public domain.
* Specifically, we give to the public domain all rights for future licensing
* of the source code, all resale rights, and all publishing rights.
* 
* We ask, but do not require, that the following message be included in all
* derived works:
* 
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
* 
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
* 
****************************************************************************/

#include <gl.h>
#include <device.h>
#include <math.h>

#include "fdefs.h"

#ifndef NULL
#define NULL 0
#endif

#define INFINITE	1

float infinite[] = {AMBIENT, 0.0, 0.0, 0.0,
		    LOCALVIEWER, 0.0,
		    ATTENUATION, 1.0, 0.0,
		    LMNULL};

int gx_setlite(fmat)
float fmat[][3];
{
	float lx,ly,lz;
	float lr,lg,lb;
	float ka,kd,ks;
	float nval,lnorm;
	float lt[10];
	int i;

	lx = fmat[LLO][0];
	ly = fmat[LLO][1];
	lz = fmat[LLO][2];

	lr = fmat[LCO][0];
	lg = fmat[LCO][1];
	lb = fmat[LCO][2];

	ka = fmat[KCO][0];
	kd = fmat[KCO][1];
	ks = fmat[KCO][2];

	nval = ((lx * lx) + (ly * ly) + (lz * lz));
	lnorm = fsqrt( nval );

	lx = lx / lnorm;
	ly = ly / lnorm;
	lz = lz / lnorm;

	i = 0;
	lt[i++] = LCOLOR;
	lt[i++] = lr;
	lt[i++] = lg;
	lt[i++] = lb;
	lt[i++] = POSITION;
	lt[i++] = lx;
	lt[i++] = ly;
	lt[i++] = lz;
	lt[i++] = 0.0;
	lt[i++] = AMBIENT;
	lt[i++] = ka * lr;
	lt[i++] = ka * lg;
	lt[i++] = ka * lb;
	lt[i++] = LMNULL;

	lmdef(DEFLIGHT, 1, 0, lt);
	lmdef(DEFLMODEL, INFINITE, 0, infinite);

	lmbind(LIGHT0, 1);
	lmbind(LMODEL, INFINITE);

	return(0);
}
