/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  b_stack.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/




#ifndef BSTACKH
#define BSTACKH

#include <LEDA/basic.h>


//------------------------------------------------------------------------------
// bounded stacks 
//------------------------------------------------------------------------------

#define b_stack_body(type) {\
	type* v;\
	int sz;	\
        int t;\
public:\
\
_b_stack(type)(int n)\
{ if (n<1) error_handler(99,"_b_stack: bad size");\
  sz = n;\
  t = -1;\
  v = new type[sz];\
  if (v==0) error_handler(99,"_b_stack: out of memory");\
 }\
\
~_b_stack(type)() { delete[0] v; }\
\
int   size()  const { return t+1; }\
int   empty() const { return (t<0) ? true : false; }\
\
void push(type& a)\
{ t++;\
  if (t==sz) error_handler(99,"_b_stack overflow");\
  v[t] = a;\
}\
\
type pop()\
{ if (t<0) error_handler(99,"_b_stack underflow");\
  return v[t--];\
}\
\
type top() const \
{ if (t<0) error_handler(99,"_b_stack empty");\
  return v[t];\
}\
\
void clear() { t = -1; }\
};


#ifdef __TEMPLATES__
#define _b_stack(T) b_stack
template<class T> class b_stack b_stack_body(T)

#else
#define _b_stack(T) name2(T,b_stack)
#define b_stack(T) name2(T,b_stack)
#define b_stackdeclare(T) class b_stack(T) b_stack_body(T)

#endif

#endif
