/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  sortseq.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/




#ifndef SORTSEQH
#define SORTSEQH


//------------------------------------------------------------------------------
// sorted sequences ((2,4)-Trees)
//------------------------------------------------------------------------------

#include <LEDA/ab_tree.h>

typedef ab_tree_node* seq_item;

#define sortseq(keytype,inftype) name3(keytype,inftype,sortseq)

#define sortseqdeclare2(keytype,inftype)\
\
struct sortseq(keytype,inftype) : public ab_tree {\
\
keytype name2(keytype,X1);\
inftype name2(inftype,X2);\
\
int  cmp(GenPtr x, GenPtr y) const\
                     { return compare(ACCESS1(keytype,x),ACCESS1(keytype,y)); }\
void clear_key(GenPtr& x)   const { Clear(ACCESS1(keytype,x)); }\
void clear_inf(GenPtr& x)   const { Clear(ACCESS2(inftype,x)); }\
void copy_key(GenPtr& x)    const { x = Copy(ACCESS1(keytype,x)); }\
void copy_inf(GenPtr& x)    const { x = Copy(ACCESS2(inftype,x)); }\
void print_key(GenPtr& x)   const { Print(ACCESS1(keytype,x),cout); }\
void print_inf(GenPtr& x)   const { Print(ACCESS2(inftype,x),cout); }\
\
keytype  key(seq_item it) const { return ACCESS1(keytype,ab_tree::key(it)); }\
inftype  inf(seq_item it) const { return ACCESS2(inftype,ab_tree::inf(it)); } \
\
seq_item  lookup(keytype y) const { return ab_tree::lookup(Convert(y)); }\
seq_item  locate(keytype y) const { return ab_tree::locate(Convert(y)); }\
seq_item  locate_pred(keytype y) const { return ab_tree::locate_pred(Convert(y)); }\
\
seq_item  succ(seq_item x) const { return ab_tree::succ(x); }\
seq_item  succ(keytype y) const { return locate(y); }\
\
seq_item  pred(seq_item x) const { return ab_tree::pred(x); }\
seq_item  pred(keytype y) const { return locate_pred(y); }\
\
seq_item  insert(keytype y,inftype x)\
                         { return ab_tree::insert(Convert(y),Convert(x)); } \
\
seq_item  insert_at(seq_item it,keytype y,inftype x)\
                         { return ab_tree::insert_at_node(it,Convert(y),Convert(x)); } \
\
void      flip_items(seq_item a, seq_item b)    { ab_tree::flip(a,b); }\
void      reverse_items(seq_item a, seq_item b) { ab_tree::reverse(a,b); }\
\
void      del(keytype y)         { ab_tree::del(Convert(y)); } \
void      del_item(seq_item it)  { ab_tree::del_node(it); } \
void      change_inf(seq_item it, inftype i) { ab_tree::change_inf(it,Convert(i));}\
void split(seq_item x,sortseq(keytype,inftype)& S1,sortseq(keytype,inftype)& S2)\
                      { ab_tree::split_at_item(x,(ab_tree&)S1,(ab_tree&)S2); }\
\
sortseq(keytype,inftype)& conc(sortseq(keytype,inftype)& S)\
                           { ab_tree::conc((ab_tree&)S); return *this; }\
\
sortseq(keytype,inftype)()    {}\
sortseq(keytype,inftype)(const sortseq(keytype,inftype)& w) : ab_tree((ab_tree&)w) {}\
\
sortseq(keytype,inftype)& operator=(const sortseq(keytype,inftype)& w)\
{ ab_tree::operator=((ab_tree&)w); return *this; }\
\
~sortseq(keytype,inftype)()   { clear(); }\
} ;


// ----------------------------------------------------------------
// iteration
// ----------------------------------------------------------------

#define forall_seq_items(i,S) for(i=(S).first_item(); i; i=(S).next_item(i))


#endif
