(*  :Title:	Initialization for Digital Signal Processing Package  *)

(*  :Authors:	Brian Evans, James McClellan  *)

(*  :Summary:	This is an initialization file only  *)

(*  :Context:	Global`  *)

(*  :PackageVersion:  2.4	*)

(*
    :Copyright:	Copyright 1989, 1990 by
		the Digital Signal Processing Group
		at the Georgia Institute of Technology

	Permission to use, copy, modify, and distribute this software
	and its documentation for any purpose and without fee is
	hereby granted, provided that the above copyright notice
	appear in all copies and that both that copyright notice and
	this permission notice appear in supporting documentation,
	and that the name of Georgia Tech or Georgia Institute of
	Technology not be used in advertising or publicity pertaining
	to distribution of the software without specific, written prior
	permission.  Georgia Tech makes no representations about the
	suitability of this software for any purpose.  It is provided
	"as is" without express or implied warranty.
 *)

(*  :History:	*)

(*  :Keywords:	*)

(*  :Source:	*)

(*  :Warning:	*)

(*  :Mathematica Version:  1.2 or 2.0  *)

(*  :Limitation:  *)

(*
    :Discussion:	Hierarchy of digital signal processing packages:

					|
			 ---------------+---------------
			|		|		|
(d)	DSPAnalyze.m   DFT.m		|		|		 D
	    |		|		|		|		 I
	     -----------+		|		|		 G
			|		|		|		 I
(c)		      DTFT.m       ZSolve.m    Correlation.m		 T
			|		|		|		 A
	     -----------+	 -------+---------------+---		 L
	    |		|	|			    |
(b)	    |	      ZTransform.m		     InvZTransform.m
	    |			|			    |
	    |		         ----------------------
	    |				       |
(a)	DSupport.m			   ZSupport.m
	    |				       |
	     ----------------------------------
			      |
		      (Support Packages)
 *)


(*  B E G I N     I N I T I A L I Z A T I O N  *)


(*  Load in the packages on which the DSP packages rely  *)

Needs[ "SignalProcessing`Support`" ]


Which [


(*  Check to see if this has already been loaded  *)

MemberQ[ $ContextPath, "SignalProcessing`Digital`" ],

  Print["Version 2.4 of the digital signal processing packages has \
         already been loaded."],


(*  For Mathematica 2.0, we only define the stubs  *)

TrueQ[ $VersionNumber >= 2.0 ],

  Print["Defining stubs for the objects in version 2.4 of the \
        digital signal processing packages ..."];

  DeclarePackage[ "SignalProcessing`Digital`Correlation`", { 
			"CorrelationSequence" } ];

  DeclarePackage[ "SignalProcessing`Digital`DFT`", { 
			"DFTData", "DFTransform", "Finish",
			"InvDFTransform", "KVariables", "Start" } ];

  DeclarePackage[ "SignalProcessing`Digital`DSPAnalyze`", { "DSPAnalyze" } ];

  DeclarePackage[ "SignalProcessing`Digital`DSupport`", { 
			"FourierSimplify", "FVariables" } ];

  DeclarePackage[ "SignalProcessing`Digital`DTFT`", {
			"DTFTData", "DTFTransform", "InvDTFTransform" } ];

  DeclarePackage[ "SignalProcessing`Digital`InvZTransform`", { 
			"InvZTransform" } ];

  DeclarePackage[ "SignalProcessing`Digital`ZMath`", { 
			"AddROCInformation", "ZCombineROC", "ZInvert" } ];

  DeclarePackage[ "SignalProcessing`Digital`ZSolve`", { 
			"RightSided", "ZSolve" } ];

  DeclarePackage[ "SignalProcessing`Digital`ZSupport`", { 
			"InvalidZTransformQ", "InvalidInvZTransformQ",
			"KeepNormalized", "MakeZObject", "ZForm",
			"ZTransformQ", "ZUpsampledQ" } ];

  DeclarePackage[ "SignalProcessing`Digital`ZTransform`", { 
			"ZTransform" } ];

  AppendTo[ $ContextPath, "SignalProcessing`Digital`" ],


(*  Load them in manually under Mathematica 1.2  *)

True, 

  Print["Loading version 2.4 of the digital signal processing packages ..."];

  Needs[ "SignalProcessing`Digital`ZSupport`" ];		(* level a *)
  Needs[ "SignalProcessing`Digital`DSupport`" ];

  Needs[ "SignalProcessing`Digital`ZTransform`" ];		(* level b *)
  Needs[ "SignalProcessing`Digital`InvZTransform`" ];

  Needs[ "SignalProcessing`Digital`DTFT`" ];			(* level c *)
  Needs[ "SignalProcessing`Digital`Correlation`" ];
  Needs[ "SignalProcessing`Digital`ZSolve`" ];

  Needs[ "SignalProcessing`Digital`DSPAnalyze`" ];		(* level d *)
  Needs[ "SignalProcessing`Digital`DFT`" ];

  AppendTo[$ContextPath, "SignalProcessing`Digital`"]

]


(*  Temporary messages  *)

digital::error = "The current context should be Global` and it is not."
digital::loaded =
	"Routines, objects, and rules for the digital signal \
	processing packages have been loaded successfully."

(*  Error checking  *)

If [ SameQ[$Context, "Global`"],
     Message[ digital::loaded ],
     Message[ digital::error ] ]

(*  Remove temporary messages  *)

digital::error = .
digital::loaded = .


(*  Inform the user about the digital signal processing packages  *)

Print[ " " ]
Print[ "Digital signal processing extensions have been loaded." ]
Print[ "Good starting points are the objects DSPAnalyze and ZTransform." ]
Print[ "Active packages are maintained in $Packages." ]
Print[ "  New signals (functions) are in SPsignals." ]
Print[ "  New systems (operators) are in SPoperators." ]
Print[ "  New Mathematica routines are in SPfunctions." ]
Print[ "Note that all signal processing expressions will"]
Print[ "be automatically simplified." ]
Print[ " " ]

(*  E N D     I N I T I A L I Z A T I O N  *)

Null
