(*  :Title:	Correlation  *)

(*  :Authors:	Brian Evans, James McClellan  *)

(*
    :Summary:	Perform basic analysis on a one-dimensional discrete-time
		function, including plotting f[n] and graphing the poles
		and zeroes of F[z].
 *)

(*  :Context:	SignalProcessing`Digital`Correlation`  *)

(*  :PackageVersion:  2.4	*)

(*
    :Copyright:	Copyright 1989-1991 by Brian L. Evans
		Georgia Tech Research Corporation

	Permission to use, copy, modify, and distribute this software
	and its documentation for any purpose and without fee is
	hereby granted, provided that the above copyright notice
	appear in all copies and that both that copyright notice and
	this permission notice appear in supporting documentation,
	and that the name of the Georgia Tech Research Corporation,
	Georgia Tech, or Georgia Institute of Technology not be used
	in advertising or publicity pertaining to distribution of the
	software without specific, written prior permission.  Georgia
	Tech makes no representations about the suitability of this
	software for any purpose.  It is provided "as is" without
	express or implied warranty.
 *)

(*  :History:	*)

(*  :Keywords:	cross-correlation, autocorrelation	*)

(*  :Source:	*)

(*  :Warning:	*)

(*  :Mathematica Version:  1.2 or 2.0  *)

(*  :Limitation:  *)

(*  :Discussion:  *)

(*  :Functions:	CorrelationSequence  *)


If [ TrueQ[ $VersionNumber >= 2.0 ],
     Off[ General::spell ];
     Off[ General::spell1 ] ];


(*  B E G I N     P A C K A G E  *)

BeginPackage[ "SignalProcessing`Digital`Correlation`",
	      "SignalProcessing`Digital`InvZTransform`",
	      "SignalProcessing`Digital`ZTransform`",
	      "SignalProcessing`Digital`ZSupport`",
	      "SignalProcessing`Support`TransSupport`",
	      "SignalProcessing`Support`ROC`",
	      "SignalProcessing`Support`SigProc`",
	      "SignalProcessing`Support`SupCode`" ]


(*  U S A G E     I N F O R M A T I O N  *)

CorrelationSequence::usage =
	"CorrelationSequence[x,n,z] or CorrelationSequence[X,n,z] will \
	return the correlation sequence as discrete-time function of n. \
	Note that the first argument can be either a sequence x[n] or \
	a z-transform X(z).  Also note that the last two arguments are \
	optional."

(*  E N D     U S A G E     I N F O R M A T I O N  *)


Begin["`Private`"]


(*  A u t o c o r r e l a t i o n  *)

CorrelationSequence[x_, n_:Null, z_:Null] := 
	Block [	{nvars, xzinv, zvars},
		zvars = ZVariables[x];
		nvars = If [ SameQ[n, Null],
			     DummyVariables[Length[zvars], Global`n],
			     n ];
		xzinv = MakeZObject[ { TheFunction[x] /. zvars ~ReplaceWith~ (zvars^-1), 1 / GetRPlus[x], 1 / GetRMinus[x] }, zvars ];
		InvZTransform[x xzinv, zvars, nvars] ] /;
	ZTransformQ[x]

CorrelationSequence[x_, n_:Global`n, z_:Global`z] := 
	Block [	{Cxx, negx},
		negx = x /. n ~ReplaceWith~ (-n);
		Cxx = ZTransform[x, n, z] ZTransform[negx, n, z];
		InvZTransform[ Cxx ] ]


(*  E N D     P A C K A G E  *)

End[]
EndPackage[]

If [ TrueQ[ $VersionNumber >= 2.0 ],
     On[ General::spell ];
     On[ General::spell1 ] ];


(*  H E L P     I N F O R M A T I O N  *)

Combine[SPfunctions, { CorrelationSequence } ]
Protect[CorrelationSequence]


(*  E N D I N G     M E S S A G E  *)

Print["Correlation functions are now loaded."]
Null
