/*
C
C  _______________________________________________________________
C
C*   Licence
C    =======
C
C    You may use or modify this code for your own non commercial
C    purposes for an unlimited time. 
C    In any case you should not deliver this code without a special 
C    permission of ZIB.
C    In case you intend to use the code commercially, we oblige you
C    to sign an according licence agreement with ZIB.
C
C
C  _______________________________________________________________
C
*/

#include <math.h>
 
#include "kask.h"
#include "kasktri.h"
#include "kaskass.h"
#include "kasksol.h"

static void MatFull();
static void VecFull();
static int  AssFull();
static int  SetBCFull();

static REAL **assemb, *rightSide;
static int dim;


int Assemble()
  {
	REAL **stiff = actSolve->stiff, **decomp = actSolve->decomp;
	REAL *rhs = actSolve->rhs, *diagonal = actSolve->diagonal,
		   *solution = actSolve->solution;
	int oldDim = actSolve->dirDim;

	dim = actTriang->noOfPoints;
	InitNumAss(N_STD);
    if (oldDim<dim)
      {
        actSolve->stiff = ExpMatFull(stiff, oldDim, dim, actProblem->symP);
		if ((actSolve->stiff)==nil) return false;

        actSolve->rhs = ExpVecFull(rhs, oldDim, dim);
		if ((actSolve->rhs)==nil) return false;

        actSolve->decomp = ExpMatFull(decomp, oldDim, dim, actProblem->symP);
		if ((actSolve->decomp)==nil) return false;

        actSolve->diagonal = ExpVecFull(diagonal, oldDim, dim);
		if ((actSolve->diagonal)==nil) return false;

        actSolve->solution = ExpVecFull(solution, oldDim, dim);
		if ((actSolve->solution)==nil) return false;

		actSolve->dirDim = dim;
      }
    Set0MatFull(actSolve->stiff, dim, symP);
    Set0VecFull(actSolve->rhs, dim);

    partP = P_ALL;
	dim = actSolve->dirDim;
    assemb = actSolve->stiff;
	rightSide = actSolve->rhs;

	if (!ApplyT(AssFull, all)) return false;
    if (!ApplyP(SetBCFull, dirichlet)) return false;

	return true;
  }

static int AssFull(t)
  TR *t;
  {
    int i,k,index[3],i1,i2;
 
    index[0] = (t->p1)->indexP;
    index[1] = (t->p2)->indexP;
    index[2] = (t->p3)->indexP;
    if ((actProblem->NumAss)(t)==false) return false;
    for(i = 0; i<3; i++)
      {
        i1  =index[i];
        for(k = 0; k<=((symP==SYMMETRIC)?i:2); k++)
          {
            i2 = index[k];
            if (symP==SYMMETRIC)
              {
      	        if (i1<i2) assemb[i2][i1] += assA[i][k];
			    else       assemb[i1][i2] += assA[i][k];
			  }
			else assemb[i2][i1] += assA[k][i];
          }
        rightSide[i1] += assB[i];
      }
    return true;
  }
 
static int SetBCFull(p)
  PT *p;
  {
    int i = p->indexP,k;
    REAL bxy;
    REAL *dirVals = (actProblem->dirVals);

    (actProblem->DirichF)(p->x,p->y,p->class,dirVals);
    bxy = dirVals[0];
	for (k = 0; k<dim; k++)
      {
        if (symP==SYMMETRIC)
          {
	        if(i>k)
	          {
 	            rightSide[k] -= bxy*assemb[i][k];
 	            assemb[i][k] = ZERO;
 	          }
	        if(i<k)
 	          {
  	           rightSide[k] -= bxy*assemb[k][i];
 	           assemb[k][i] = ZERO;
 	          }
 	       }
 	     else
 	       {
	        if(i!=k)
	          {
 	            rightSide[k] -= bxy*assemb[k][i];
 	            assemb[i][k] = ZERO;
 	            assemb[k][i] = ZERO;
 	          }
 	       }
      }
    rightSide[i] = bxy;
    assemb[i][i] = ONE;
    return true;
  }
 
REAL **ExpMatFull(x,old,new,symP)
  REAL **x;
  int old,new,symP;
  {
    int k;
    REAL **y;
 
    if (symP==FULL)
	  {
	    for (k=0; k<old; k++) ZIBFree((PTR)x[k]);
		old = 0;
	  }
	y = (REAL**)ZIBAlloc((long)new*sizeof(REAL*));
    if (y==nil)
	  { ZIBStdOut("Assemble: not enough memory (ExpMatFull)\n");  return nil; }
    for(k = 0; k<old; k++) y[k] = x[k];
    if (x!=nil) ZIBFree((PTR)x);
    for(k = old; k<new; k++)
      {
        y[k] = (REAL*)ZIBAlloc((long)((symP==SYMMETRIC)?(k+1):new)*sizeof(REAL));
        if (y[k]==nil)
		  { ZIBStdOut("Assemble: not enough memory (ExpMatFull)\n"); return nil; }
      }
    return y;
  }
 
REAL *ExpVecFull(x,old,new)
  REAL *x;
  int old,new;
  {
    int k;
    REAL *y;
 
    y = (REAL*)ZIBAlloc((long)new*sizeof(REAL));
    if (y==nil)
	  { ZIBStdOut("Assemble: not enough memory (ExpVecFull)\n"); return nil; }
    for(k = 0; k<old; k++) y[k] = x[k];
    if (x!=nil) ZIBFree((PTR)x);
    return y;
  }

void Set0MatFull(x, n, symp)
  REAL **x;
  int n, symp;
  {
    int i,k;
 
    for(i = 0; i<n; i++)
      for(k = 0; k<((symp==SYMMETRIC)?i+1:n); k++) x[i][k] = ZERO;
    return;
  }
 
void Set0VecFull(x,n)
  REAL *x;
  int n;
  {
    int k;
 
    for(k = 0; k<n; k++) x[k] = ZERO;
    return;
  }
 
void PrintMatFull(s, a, n, triP)
  char *s;
  REAL **a;
  int n,triP;
  {
    int i,k;
 
 	sprintf(globBuf,"Full matrix '%s(%s)', dim=%d\n", s,
			(triP==SYMMETRIC)?"SYMMETRIC":"FULL", n);
    ZIBStdOut(globBuf);
    for(i = 0; i<n; i++)
      for(k = 0; k<=((triP==SYMMETRIC)?i:n-1); k++)
        if (a[i][k]!=ZERO)
		  {
		    sprintf(globBuf,"  (% 3d,% 3d):% 8.3e\n", i, k, a[i][k]);
			ZIBStdOut(globBuf);
		  }
    return;
  }
 
void PrintVecFull(s,b,n)
  char *s;
  REAL *b;
  int n;
  {
    int k;
 
    sprintf(globBuf,"Full vector '%s', dim=%d\n", s, n);
    ZIBStdOut(globBuf);
    for(k = 0; k<n; k++)
      if (b[k]!=ZERO)
		  {
		    sprintf(globBuf,"  % 3d:% 8.3ee\n", k, b[k]);
			ZIBStdOut(globBuf);
		  }
    return;
  }
