/*
    These are the definitions particular to the HOSTLESS picl implementation.
 */

#ifndef __commpicl
#define __commpicl

#ifndef __commh
#include "comm/comm.h"
#endif

extern int __PICLLEN, __PICLFROM, __PICLTYPE;

#define NO_ASYNC_SEND
#define NO_ASYNC_RECV
#define NO_FORCE
#define NO_NATIVE_GLOBAL

#define SENDSYNC(type,buffer,length,to,datatype) \
        {LOGSENDSTART(length,type,to);\
	     send0((char*)(buffer),length,type,to);\
         LOGSENDEND(type);}
#define RECVSYNC(type,buffer,length,datatype) {\
        LOGRECVSTART(type);recv0((char*)(buffer),length,type);\
        LOGRECVEND(type,0,0);}
#define SENDSYNCNOMEM(type,buffer,length,to,datatype) \
        SENDSYNC(type,buffer,length,to,datatype)
#define RECVSYNCNOMEM(type,buffer,length,datatype)  \
        RECVSYNC(type,buffer,length,datatype);
#define RECVSYNCUNSZ(type,bufp,size,datatype) {\
        while(probe0(type)!=1);\
	recvinfo(&__PICLLEN,&__PICLTYPE,&__PICLFROM);\
        bufp=(char*)MALLOC(__PICLLEN);\
	recv0((char*)(bufp),__PICLLEN,__PICLTYPE);LOGRECVEND(type,size,0);}

#define SYNCPROBE(type) while(probe0(type)!=1);\
                        recvinfo(&__PICLLEN,&__PICLTYPE,&__PICLFROM);
extern int PIpiclIprobe0();
#define ASYNCPROBE(type) PIpiclIprobe0(type)
#define ASYNCDONE(id)    1
#define RECVPROBED(type,buffer,length,datatype) \
        RECVSYNC(type,buffer,length,datatype)

#define RECVLEN()  __PICLLEN
#define RECVFROM() __PICLFROM
#define RECVTYPE() __PICLTYPE

/* Could use gsum0, gmax0, gmin0, sync0, bcast0; setarc0 in compiling  
   sets, but for now, we'll alledge no native global ops. 
   Note however that the PICL routines have to be followed by a bcast,
   since the routines deliver the results to a single node. */

#define MSGALLOCSEND(msg,maxmsg,type)  msg = (type *)MALLOC(maxmsg)
#define MSGFREESEND(msg)               FREE(msg)
#define MSGALLOCRECV(msg,maxmsg,type)  msg = (type *)MALLOC(maxmsg)
#define MSGFREERECV(msg)               FREE(msg)

#define NUMNODES __NUMNODES
#define MYPROCID __MYPROCID
/* The max value below is EXACT (for Intel).  See the documentation on PICL */
#define MSGTYPERANGE(low,high) {*(low)=0;*(high)=800000000;}
#define MSGDISTANCE(from,to)   gdistdf(from,to)
#define MSGSIZES(min,max)      {*min=0;*max=(16384*8096);}
#define MSGDIAMETER            (NUMNODES-1)

#endif


