#ifndef lint
static char SCCSid[] = "@(#) ./comm/global/gsync.c 07/23/93";
#endif

#include "comm/comm.h"
#include "comm/procset.h"
#include "comm/global/global.h"
#include <stdio.h>

void gsyncsetT( procset )
ProcSet *procset;
{
int size = 0, *work, dummy;
int l_child, r_child, parent;
int msgup, msgdn, lphase;

work = &dummy;
/* printf( "[%d] doing gsync\n", MYPROCID ); */
if (!procset) {
    if (_PIPARENT < -1)
	PISetupCollectiveTree( );
    l_child = _PILCHILD;
    r_child = _PIRCHILD;
    parent  = _PIPARENT;
    _PIPHASE= _PIPHASE ? 0 : 1;
    lphase  = _PIPHASE;
    }
else {
    l_child = procset->l_child;
    r_child = procset->r_child;
    parent  = procset->parent;
    GMSGPHASE(procset,lphase);
    }

msgup = GMSGTYPE(procset,MSG_UP|lphase);
msgdn = GMSGTYPE(procset,MSG_DN|lphase);

LOGPUSHATOMIC;
/* Receive values from my children */
if (l_child >= 0) {
    RECVSYNCNOMEM(msgup,work,sizeof(int),MSG_OTHER);
    }
if (r_child >= 0) {
    RECVSYNCNOMEM(msgup,work,sizeof(int),MSG_OTHER);
    }
/* Send to parent */
if (parent >= 0) {
    SENDSYNCNOMEM(msgup,work,size,parent,MSG_OTHER);
    RECVSYNCNOMEM(msgdn,work,sizeof(int),MSG_OTHER);
    }
/* Wait for response and forward down */
if (l_child >= 0)
    SENDSYNCNOMEM(msgdn,work,size,l_child,MSG_OTHER);
if (r_child >= 0)
    SENDSYNCNOMEM(msgdn,work,size,r_child,MSG_OTHER);

LOGPOPATOMIC;
}
