	SUBROUTINE SWAPS (N, ER, EI, RES, IORD)
	REAL*8 ER(*), EI(*), RES(*), XSAV
	INTEGER IORD(*), I, J, N
C---------------SWAPS DISORDERED EIGENVALUES SO THAT-------------
C---------------IN A COMPLEX PAIR THE FIRST ONE APPEARS ---------
C---------------WITH A POSITIVE REAL PART -----------------------
	I = 0
 4      I = I+1
	IF (EI(I) .EQ. 0.0D0) GOTO 6
	IF (EI(I) .GT. 0.0D0) GOTO 5
C               BAD ORDER  --->   SWAP
	XSAV = EI(I)
	EI(I) = EI(I+1)
	EI(I+1) = XSAV
	XSAV = RES(I)
	RES(I) = RES(I+1)
	RES(I+1) = XSAV
C
	J = IORD(I)
	IORD(I) = IORD(I+1)
	IORD(I+1) = J
C
 5      I=I+1
 6      IF (I .LT. N) GOTO 4
C*******   END OF SWAPS ******************************************
	END
	SUBROUTINE ORDRS  (N, ER, EI, IORD, RES)
C-------------------------------------------------------------------
C PERMUTES THE E.V. IN SMALLEST RESIDUAL NORMS .
C ON INPUT ER = REAL PARTS OF EIGENVALUES
C          EI = IMAG.  PARTS OF EIGENVALUES
C          RES= RESIDUAL NORMS ASSOCIATED WITH THE EIGENVALUES (WR,WI)
C ON OUTPUT: IORD IS THE PERMUTATION.  Y CONTAINS ORDERED MODULII
C         AND  ER, EI, RES ARE  ORDERED CORRECTLY.
C-------------------------------------------------------------------
	IMPLICIT REAL*8 (A-H,O-Z)
	integer n, iord
	DIMENSION ER(*),EI(*), IORD(*), RES(*)
	integer i, j, im, k
C GET PERMUTATION FIRST .
	IF (N .LE. 1) RETURN
	RMAX = DSQRT(DDOT(N, RES, 1, RES, 1))
	DO 3 I=1,N
	   XM = RMAX +1.0D0
	   DO 2 J =I, N
		X = RES(J)
		IF (X .GE. XM) GOTO 2
		   XM = X
		   IM =J
 2      CONTINUE
C  PERMUTE
	K = IORD(IM)
	IORD(IM) = IORD(I)
	IORD(I) = K
C
	T = ER(IM)
	ER(IM) = ER(I)
	ER(I) = T
C
	T = EI(IM)
	EI(IM) = EI(I)
	EI(I) = T
C
	T = RES(IM)
	RES(IM) = RES(I)
	RES(I) = T
C
 3      CONTINUE
C       SWAP DISORDERED EIGENVALUES. ..
	CALL SWAPS (N, ER, EI, RES, IORD)
	RETURN
C*******   END OF ORDRS  *******************************************
	END
	SUBROUTINE RESIDL (M, EVEC, IH, BETA, RES, WI)
	integer m, ih
	REAL*8 EVEC(IH,IH),RES(*),WI(*),T,BETA, DDOT, DSQRT, DABS
	integer j, j1
C--------------------------------------------------------------------
C COMPUTES THE RESIDUAL NORMS OBTAINED FOR RITZ VECTORS IN AN ARNOLDI
C PROCESS. USES EIGENVECTORS OF THE HESSENBERG MATRIX OF SIZE M.
C--------------------------------------------------------------------
	J = 1
	if (m .lt. 1) then
	    print *, 'Insufficient info in RESIDL: m < 1'
	    return
	endif
 420    T = DSQRT(DDOT(M,EVEC(1,J),1,EVEC(1,J),1) )
	IF (WI(J) .EQ. 0.0D0)  GOTO 419
C-------------0 COMPLEX CASE 0---------------------------------------
	J1 = J + 1
	T = T + DDOT(M, EVEC(1,J1),1,EVEC(1,J1),1)
	RES(J)  = BETA*DSQRT((EVEC(M,J)**2+EVEC(M,J1)**2)/T)
	RES(J1) = RES(J)
	J = J1
	GOTO 421
C--------------0 REAL CASE 0-----------------------------------------
 419    RES(J) = DABS(BETA*EVEC(M,J)/T)
 421    J = J + 1
	IF (J .LE. M) GOTO 420
	RETURN
C-------------0 END OF RESIDL 0--------------------------------------
	END
