#ifndef LINT
static char SCCSid[] = "@(#) ./lint/header.c 07/23/93";
#endif

#include "doc/doc.h"

/* This is designed to work with comments in C programs.  
   It uses the standardized documentation to issue dummy routine
   definitions to allow the creation of a lint library, since lint 
   won't incrementally build libraries, and we can't give lint all of the
   routines (since the shell chokes on that many arguments and characters).
   Most charitably, this design (lint and the shell) seems suboptimal
 */

/*D
blinth - program to extract short definitions for a lint library file

Input:
. filenames - Names the files from which lint definitions are to be extracted

Author: 
Bill Gropp
D*/
main( argc, argv )
int  argc;
char **argv;
{
char routine[MAX_ROUTINE_NAME];
char *infilename;
FILE *fd;
int  nread;
char kind;

/* process all of the files */
argc--; argv++;
while (argc--) {
    infilename = *argv++;
    /* Insert a routine to shorten file names here? */
    fd = fopen( infilename, "r" );
    if (!fd) {
    	fprintf( stderr, "Could not open file %s\n", infilename );
    	continue;
        }
    fprintf( stdout, "/* %s */\n", infilename );
    while (FoundLeader( fd, routine, &kind )) {
	if (kind == ROUTINE) {
	    OutputRoutine( fd, stdout, routine, infilename, kind );
	    }
	}
    fclose( fd );
    }
return 0;
}

/* 
   There are a number of things to watch for.  One is that leading blanks are
   considered significant; since the text is being formated, we usually dont
   agree with that. 

   We should really add a "return 0" for non-void routines.
 */
OutputRoutine( fin, fout, name, filename, kind )
FILE *fin, *fout;
char *name, *filename, kind;
{
int c;
char token[1024], *p;
int  i, nsp, bl, newline, leadingm;
int  is_void = 0, found_function=0;
int  nlen = strlen(name);

/* Skip to trailer */
SkipText( fin, name, filename, kind );

/* Now, hunt for the first open brace.  */
SkipWhite( fin );
newline = 0;
while (1) {
    c = FindNextToken( fin, token, &nsp );
    /*printf( "t=:%s:\n", token ); */
    if (!found_function) {
	if (strcmp( token, "void" ) == 0) is_void = 1;
	else {
	    if (token[0] == '*') {
		is_void = 0;  /* e.g., void *foo() */
		if (strncmp( token + 1, name, nlen ) == 0) found_function = 1;
		}
	    else {
		if (strncmp( token, name, nlen ) == 0) found_function = 1;
		}
	    }
	}
    if (c == EOF || token[0] == '{') break;
    /* Don't output register (some lints can't handle it) */
    if (strcmp( token, "register" ) != 0) {
	for (i=0; i<nsp; i++) putc( ' ', fout );
	fputs( token, fout );
	}
    }
if (is_void)
    fputs( "{}\n", fout );
else
    fputs( "{return 0;}\n", fout );
}

/*
    This routine skips the text part of a text page.
 */        
SkipText( fin, name, filename, kind )
FILE *fin;
char *name, *filename;
char kind;
{
int  c;
char lineBuffer[MAX_LINE], *lp;
	
lineBuffer[0] = '+';   /* Sentinal on lineBuffer */
while (1) {
    lp = lineBuffer + 1;
    c  = getc( fin );
    if (c == EOF) break;
    if (c == ARGUMENT || c == VERBATIM)
	SkipLine( fin );
    else if (c == '\n')
	;
    else {
	if (isspace(c) && c != '\n')
	    SkipWhite( fin );
	else 
	    *lp++ = c;
    	/* Copy to end of line; do NOT include the EOL */
    	while ((c = getc( fin )) != EOF && c != '\n') 
    	    *lp++ = c;
    	lp--;
    	while (isspace(*lp)) lp--;
    	lp[1] = '\0';    /* Add the trailing null */
    	if (lineBuffer[1] == kind && strcmp(lineBuffer+2,"*/") == 0)
    	    break;
        }
    }
}

