/*  @(#) ./solvers/dd/example.c 07/23/93 */
/*
      This program tests the interpolation/injection routines
 */
#include <stdio.h>

main(argc, argv)
int  argc;
char *argv[];
{
double pin[100], pout[100], *p;
double cg[20];
int err = 0;
int i, j;

/* Here is similar input data, except we've modified it to have
   two different strides and values:
   1  x  3  x  5 
   x  x  x  x  x
   x  x  x  x  x
   4  x  6  x  8
   x  x  x  x  x
   with the first FOUR rows being filled in
 */
cg[0] = 1; cg[1] = 3; cg[2] = 5;
cg[4] = 4; cg[5] = 6; cg[6] = 8;

Msh2dInterpolateBilinear( pout, 5, 5, 4, cg, 4, 2, 1, 3, 4, 0 );

p = pout;
for (j=0; j<4; j++) {
    for (i=0; i<5; i++) {
	if (*p++ != i + j + 1) {
	    fprintf( stderr, 
	"Error in Msh2dInterpolate at (%d,%d); value is %f, should be %f\n", 
		    i, j, p[-1], (double)(i+j+1) );
	    err++;
	    }
	}
    }

/* This version is for the "open" model.

   0  x  0  x  0  x  0
   x  x  x  x  x  x  x
   x  x  x  x  x  x  x
   0  x  1  x  2  x  0
   x  x  x  x  x  x  x
   x  x  x  x  x  x  x 
   0  x  3  x  4  x  0
   x  x  x  x  x  x  x
   x  x  x  x  x  x  x 
   0  x  0  x  0  x  0

   We specify only the 2 interior points
 */
cg[0] = 1; cg[1] = 2; cg[2] = 3.0; cg[3] = 4.0;

for (i=0; i<100; i++) pout[i] = -1.0;
Msh2dInterpolateBilinear( pout, 5, 5, 8, cg, 2, 3, 3, 3, 4, 1 );

p = pout;
for (j=0; j<8; j++) {
    for (i=0; i<5; i++) {
	printf( "%f ", *p++ );
	}
    printf( "\n" );
    }

/* Now, restrict */
/* for (j=0; j<100; j++) pout[j] = 1.0; */
Msh2dRestrictPCopen( pout, 5, 5, 8, cg, 2, 3, 3, 3, 4 );
p = cg;
printf( "Restricting...\n" );
for (j=0; j<2; j++) {
    for (i=0; i<2; i++) {
	printf( "%f ", *p++ );
	}
    printf( "\n" );
    }

/* Now, restrict */
printf( "\nNow doing 2 x 2 cells, cell size is 4 x 4\n" );
for (j=0; j<100; j++) pout[j] = 1.0;
Msh2dRestrictPCopen( pout, 5, 5, 5, cg, 1, 2, 2, 4, 4 );
p = cg;
printf( "Restricting...\n" );
for (j=0; j<1; j++) {
    for (i=0; i<1; i++) {
	printf( "%f ", *p++ );
	}
    printf( "\n" );
    }

cg[0] = 1;

for (i=0; i<100; i++) pout[i] = -1.0;
Msh2dInterpolateBilinear( pout, 5, 5, 5, cg, 1, 2, 2, 4, 4, 1 );

p = pout;
for (j=0; j<5; j++) {
    for (i=0; i<5; i++) {
	printf( "%f ", *p++ );
	}
    printf( "\n" );
    }

return err;
}
