#ifndef lint
static char SCCSid[] = "@(#) ./sparse/condense.c 07/23/93";
#endif

#include "tools.h"
#include "sparse/spmat.h"
#include "sparse/sppriv.h"
#include "inline/spops.h"

/*@
  SpRemoveRows - Eliminate given rows from a matrix and update the mappings.

  Input parameters:
.  mat   - matrix to eliminate rows from
.  rows  - rows to remove
.  N     - number of rows to remove
 @*/
void SpRemoveRows( mat, rows, N)
SpMat  *mat;
int    *rows,N;
{
SpVec        **rs;
int          M,*oldmap = 0;
int          i,j,size, *newmap, head;
SpRowMat     *R;

SPLITTOMAT(mat);
R = GETROWMAT(mat);

#ifdef FOO
/* sort rows to be removed */
#ifdef OLD_SORT
SpiIsort(N,rows);
#else
SYIsort( N, rows );
#endif
#endif

if (mat->map) oldmap = mat->map->rowmap;

/* Mark the rows to be eliminated */
rs = R->rs;
for ( i=0; i<N; i++ ) {
    rs[rows[i]]->nz = 0;
    }
/* count number of rows to be eliminated */
M = 0; 
size = mat->rows;
for ( i=0; i<size; i++ ) {
    if (!rs[i]->nz) M++;
    }

/* remove empty rows and keep record of where they came from */
M = size - M;
newmap = (int *) MALLOC(M*sizeof(int)); CHKPTR(newmap);
head = 0;
for ( j=0; j<size; j++ ) {
    if ( rs[j]->nz != 0 ) {
	rs[head]  = rs[j];
	if (oldmap) newmap[head++] = oldmap[j];
	else newmap[head++] = j;
	}
    }    
mat->rows = M;
if (oldmap && !mat->map->q_user_row) {
    FREE(oldmap);
    }
else {
    mat->map = SpCreateMap(); CHKERR(1);
    mat->map->colmap = SpiDupMapping( mat->cols, (int *)0 ); CHKERR(1);
    }

mat->map->rowmap = newmap;
}  

/*@
  SpCondenseWithVec - Eliminate given rows from a matrix, updating the rhs
                      vector accordingly using the known x values.  
		      
  Input parameters:
.  mat   - matrix to eliminate rows from
.  rows  - rows to remove
.  values- values of x corresponding to the values of rows
.  N     - number of rows to remove
.  rhs   - vector to update

  Notes:
    Given Ax = rhs and assume we know certain x[i] where the i are
given in an integer vector, rows and the x[i] are given in an double
vector, values. This routine eliminates the given rows and columns from
the matrix and updates the rhs. It returns a vector array whose 
components, for each row in the new matrix, point to the original row 
in the old matrix. It also removes all row and columns from the matrix 
which happen to have all zeros.
@*/
void SpCondenseWithVec( mat, rows, values, rhs, N)
SpMat  *mat;
double *values,*rhs;
int    *rows,N;
{
SpVec        *row,**rs;
int          nz, *ix, M, *smap;
double       *v, sum, *xv;
int          i,j, size, *map, head;
SpRowMat     *R;

SPLITTOMAT(mat);
R = GETROWMAT(mat);
if (mat->map) {
    SETERRC(ERR_NOT_VALID_WITH_MAP,"SpCondenseWithVec not valid with mapping");
    return;}

/* sort rows and keep the values in correct correspondence */
SpSort(rows,values,N);

/* Mark the rows to be eliminated */
  rs = R->rs;
for ( i=0; i<N; i++ ) {
    rs[rows[i]]->nz = 0;
    } 
size = mat->rows;

M = 0; /* M is count of eliminated rows */
/* count zero rows */
  for ( j=0; j<size; j++ ) {
      if ( rs[j]->nz == 0 )  M++;
      }

if ( N > 0 ) {
     /* expand sparse vector values to dense vector*/
    v = (double *) MALLOC(size*sizeof(double)); CHKPTR(v);
    memset((char*)v,0,size*sizeof(double));
    for ( i=0; i<N; i++ ) v[rows[i]] = values[i];
    /* Loop over rows adjusting rhs */
    for ( j=0; j<size; j++ ) {
	row = rs[j];
	if ( row->nz != 0 ) { /* row hasn't been eliminated */
	    nz = row->nz;
	    ix  = row->i;
	    xv  = row->v;
	    sum = 0.0;
	    SPARSEDENSEDOT(sum,v,xv,ix,nz);
	    rhs[j] -= sum;
	    }
	}    
    FREE(v);
    }
mat->rows = size - M; mat->cols = mat->cols - M;

/* remove empty rows and keep record of where they came from */
M = size - M;
map = (int *) MALLOC(M*sizeof(int)); CHKPTR(map);
head = 0;
for ( j=0; j<size; j++ ) {
    if ( rs[j]->nz != 0 ) {
       rs[head]  = rs[j];
       map[head++] = j;
       }
    }    
smap = (int *) MALLOC(size*sizeof(int)); CHKPTR(smap);
memset((char*)smap,0,size*sizeof(int));
for ( i=0; i<M; i++ ) smap[map[i]] = i+1;

  /* remove columns from rows which are left and unmap columns*/
for ( i=0; i<M; i++ ) {
    row = rs[i];
    nz = row->nz;
    ix  = row->i;
    xv  = row->v;
    head = 0;
    for ( j=0; j<nz; j++ ) {
	if ( smap[ix[j]] != 0 ) {
	    ix[head] = smap[ix[j]] - 1;
	    xv[head++] = xv[j];
	    }
	}    
    row->nz = head;
    }

/* set the row map and column map */
SpCopyMappings(mat,map,map,(int*)0);  CHKERR(1);

/* Free work space */
FREE(smap); FREE(map);
return;
}

/*@
  SpCondenseRowsCols - Given a matrix mat, eliminates additional rows/columns 
                       and any zero rows and updates any map. 

  Input Parameters:
. mat  - matrix to condense
. rows - rows to eliminate (and columns)
. N    - number of rows to eliminate
 @*/
void SpCondenseRowsCols( mat, rows, N )
SpMat  *mat;
int    *rows,N;
{
SpVec        *row,**rs;
int          nz, *ix, M, *smap;
double       *xv;
int          i,j, size, *map, head;
SpRowMat     *R;

SPLITTOMAT(mat);
R = GETROWMAT(mat);

if (mat->map) {
    SETERRC(ERR_NOT_VALID_WITH_MAP,"SpCondenseRowsCols not valid with map"); 
    return;}

/* Mark the rows to be eliminated */
rs = R->rs;
for ( i=0; i<N; i++ ) {
    rs[rows[i]]->nz = 0;
    } 
size = mat->rows;

M = 0; /* M is count of eliminated rows */
/* count zero rows */
  for ( j=0; j<size; j++ ) {
      if ( rs[j]->nz == 0 )  M++;
      }

mat->rows = size - M; mat->cols = mat->cols - M;
    
/* remove empty rows and keep record of where they came from */
M = size - M;
map = (int *) MALLOC(M*sizeof(int)); CHKPTR(map);
head = 0;
for ( j=0; j<size; j++ ) {
    if ( rs[j]->nz != 0 ) {
       rs[head]  = rs[j];
       map[head++] = j;
       }
    }    
smap = (int *) MALLOC(size*sizeof(int)); CHKPTR(smap);
memset((char*)smap,0,size*sizeof(int));
for ( i=0; i<M; i++ ) smap[map[i]] = i+1;

/* remove columns from rows which are left and unmap columns*/
for ( i=0; i<M; i++ ) {
    row = rs[i];
    nz = row->nz;
    ix  = row->i;
    xv  = row->v;
    head = 0;
    for ( j=0; j<nz; j++ ) {
	if ( smap[ix[j]] != 0 ) {
	    ix[head] = smap[ix[j]] - 1;
	    xv[head++] = xv[j];
	    }
	}    
    row->nz = head;
    }
    
/* set the row map and column map */
SpCopyMappings(mat,map,map,(int*)0); CHKERR(1);

/* free work space */
FREE(smap); FREE(map);
return;
}

/*@
  SpRemoveCols - Eliminate given columns from a matrix and update the mappings.

  Input parameters:
.  mat   - matrix to eliminate columns from
.  cols  - columns to remove
.  N     - number of columns to remove
 @*/
void SpRemoveCols( mat, cols, N)
SpMat  *mat;
int    *cols,N;
{
SpVec        **rs, *row;
double       *xv;
int          M,*oldmap = 0, nz, *ix;
int          i,j,rowsize, colsize, *newmap, head, *tmp;
SpRowMat     *R;

if (!N) return;
SPLITTOMAT(mat);
R = GETROWMAT(mat); rs = R->rs;

/* sort rows to be removed */
SYIsort( N, cols );

if (mat->map) oldmap = mat->map->colmap;
rowsize = mat->rows; colsize = mat->cols;

M = colsize - N;
newmap = (int *) MALLOC(M*sizeof(int)); CHKPTR(newmap);
tmp = (int *) MALLOC(colsize*sizeof(int)); CHKPTR(tmp);
MEMSET(tmp,0,colsize*sizeof(int));
for ( j=0; j<N; j++ ) { tmp[cols[j]] = j+1; }

/* make new column map */
head = 0;
for ( j=0; j<colsize; j++) {
  if (!tmp[j]) {
    if (oldmap) newmap[head++] = oldmap[j];
    else newmap[head++] = j;
  }
}
MEMSET(tmp,0,colsize*sizeof(int));
for ( j=0; j<M; j++ ) { tmp[newmap[j]] = j+1;  }

/* remove requested columns */
for ( i=0; i<rowsize; i++ ) {
    row = rs[i];
    nz = row->nz;
    ix  = row->i;
    xv  = row->v;
    head = 0;
    for ( j=0; j<nz; j++ ) {
    if ( tmp[ix[j]] != 0 ) {
        ix[head] = tmp[ix[j]] - 1;
        xv[head++] = xv[j];
        }
    }
    row->nz = head;
}
mat->cols = M;
FREE(tmp);
 
/* this is fishy but compare to SpRemoveRows below */
if (oldmap && !mat->map->q_user_row) {
    FREE(oldmap);
    }
else {
    mat->map = SpCreateMap(); CHKERR(1);
    mat->map->rowmap = SpiDupMapping( mat->rows, (int *)0 ); CHKERR(1);
    }
mat->map->colmap = newmap;
}

