#ifndef lint
static char SCCSid[] = "@(#) ./sparse/copy.c 07/23/93";
#endif

#include "tools.h"
#include "sparse/spmat.h"
#include "sparse/sppriv.h"
#include "inline/copy.h"

/*@
   SpCopy - Produce an "optimal" copy of a sparse matrix 
               (allocate exactly the required storage).

   Input parameter:
.  A - matrix to copy

   Returns:
   a copy of A.
 @*/
SpMat *SpCopy( A )
SpMat *A;
{
SpMat *B;
SpVec *in, *out;
int   i, n = A->rows;
register int nz, *iout, *iin;
register double *vout, *vin;
SpRowMat *RA = (SpRowMat *)A->data, *RB;

B = SpCreate( A->rows, A->cols, 0 ); CHKERRV(1,0);
RB = (SpRowMat *)B->data;
for (i=0; i<n; i++) {
    in  = RA->rs[i];
    out = RB->rs[i];
    /* Allocate the destination row */
    if (in->nz > 0) {
	SPMallocNV( B, in->nz, &out->v, &out->i ); CHKERRV(1,0);
	/* Copy the values */
	nz   = in->nz;
	vout = out->v;
	vin  = in->v;
	COPY(vout,vin,nz);
	nz   = in->nz;
	iout = out->i;
	iin  = in->i;
	COPY(iout,iin,nz);
	}
    else {
	out->v = 0;
	out->i = 0;
	}
    out->nz = out->maxn = in->nz;
    }
/* If there are mappings, copy them */
if (A->map) {
    B->map = SpCreateMap(); CHKERRV(1,0);
    *B->map = *A->map;
    if (!B->map->q_user_row && B->map->rowmap) 
      {B->map->rowmap  = SpiDupMapping( B->rows, B->map->rowmap ); CHKERRV(1,0);}
    if (!B->map->q_user_col && B->map->colmap)
      {B->map->colmap  = SpiDupMapping( B->cols, B->map->colmap ); CHKERRV(1,0);}
    if (!B->map->q_user_icol && B->map->icolmap) 
      {B->map->icolmap = SpiDupMapping( B->cols, B->map->icolmap ); CHKERRV(1,0);}
    }
return B;
}

/*@
  SpCopyStructure - Copy the structure of in to out.

  Input Parameters:
. in - input matrix
. out - output matrix (should already have been allocated.

  Notes:
  This routine was added to improve the performance of ilu with no fill, since
  determining the fill for the general case is somewhat complicated.  The
  output matrix has the number of element in the lower triangle set as well.
  Note that if the matrix "out" has a mapping, we need to apply it to get
  the proper "split" structure.
@*/
void SpCopyStructure( in, out )
SpMat      *in;
SpMatSplit *out;
{
SpMat   *BBf = out->factor;
SpVec   *inv, *outv;
SpRowMat *Rin = (SpRowMat *)in->data, *Rout = (SpRowMat *)BBf->data;
int     n = in->rows;
int     *r, *ic;
int     *outi;
register int i, j, *iin, *iout, nz;

/* Must look for mapping */
if (out->factor->map) {
    r  = out->factor->map->rowmap;
    ic = out->factor->map->icolmap;
    }
else {
    r  = 0;
    ic = 0;
    }

if (!r && !ic) {
    for (i=0; i<n; i++) {
	inv  = Rin->rs[i];
	outv = Rout->rs[i];
	/* Allocate the destination row */
	if (inv->nz > 0) {
	    nz   = inv->nz;
	    SPMallocNV( BBf, nz, &outv->v, &outi ); CHKERR(1);
	    /* Copy the indices */
	    iout = outv->i = outi;
	    iin  = inv->i;
	    for (j=0; j<nz; j++) 
		iout[j] = iin[j];
	    for (j=0; j<nz; j++) 
		if (iout[j] >= i) break;
	    out->nzl[i] = j;
	    }
	else {
	    outv->v     = 0;
	    outv->i     = 0;
	    out->nzl[i] = 0;
	    }
	outv->nz = outv->maxn = inv->nz;
	}
    }
else {
    for (i=0; i<n; i++) {
	inv  = Rin->rs[r ? r[i] : i];
	outv = Rout->rs[i];
	/* Allocate the destination row */
	if (inv->nz > 0) {
	    nz   = inv->nz;
	    SPMallocNV( BBf, nz, &outv->v, &outi ); CHKERR(1);
	    /* Copy the indices */
	    iout = outv->i = outi;
	    iin  = inv->i;
	    if (ic) {
		for (j=0; j<nz; j++) 
		    iout[j] = ic[iin[j]];
#ifdef OLD_SORT
		SpiIsort( nz, iout );
#else
		SYIsort( nz, iout );
#endif
		}
	    else {
		for (j=0; j<nz; j++) 
		    iout[j] = iin[j];
		}
	    for (j=0; j<nz; j++) 
		if (iout[j] >= i) break;
	    out->nzl[i] = j;
	    }
	else {
	    outv->v     = 0;
	    outv->i     = 0;
	    out->nzl[i] = 0;
	    }
	outv->nz = outv->maxn = inv->nz;
	}
    }
}

/*@
   SpCopyOver - Copy one matrix into another existing one.

   Input parameter:
.  A - matrix to copy

   Output Parameter:
.  B - matrix with new values

   Notes:
   This routine may be used to convert a matrix from one format to another.
   For example, to create a row format matrix B from a user-defined format
   matrix A, do
$
$  B = SpCreate( A->rows, A->cols, 0 );
$  SpCopyOver( A, B );
$
 @*/
void SpCopyOver( A, B )
SpMat *A, *B;
{
int    row, nr, nz, *i;
double *a;

nr = A->rows;
for (row=0; row<nr; row++) {
    SpScatterFromRow( A, row, &nz, &i, &a );
    SpGatherToRow( B, row, nz, i, a );
    }
}
