#ifndef lint
static char SCCSid[] = "@(#) ./system/resrc.c 07/23/93";
#endif

/*
    This file contains routines to get resource limit values
 */
     
#include "tools.h"
#include "system/system.h"

#include <stdio.h>
#ifndef __MSDOS__
#include <sys/time.h>               /*I <sys/time.h> I*/
#else
struct timeval { unsigned long tv_usec, tv_sec; };
#endif

#if !defined(__MSDOS__)
#include <sys/param.h>
#endif
#ifdef ipsc2
#include <sys/types.h>
#endif
/* 
  From sys/param.h:
 x #define	MAXPATHLEN	1024
 x #define	MAXHOSTNAMELEN  64
 */
#ifndef MAXPATHLEN
#define MAXPATHLEN 1024
#endif
#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 64
#endif

/* Default values for resource limits */
static int DefCpu = 120,                /* seconds */
           DefMem = 8,                  /* megabytes */
           DefPf  = 1000,               /* single page faults */
           DefNice= 0,                  /* RELATIVE nice value */
           DefFutureSec = 300;          /* maximum elapsed time */

/* Forward references */
long SYhhmmtoSec( );

/*@
   SYGetResourceDefaults - get the default resource limits 

   Output parameters:
.  cpu  - cputime in seconds
.  mem  - memory in megabytes
.  pf   - page faults
.  nice - nice value
.  fsec - maximum elapsed running time
@*/
void SYGetResourceDefaults( cpu, mem, pf, nice, fsec )
int *cpu, *mem, *pf, *nice, *fsec;
{
if (cpu) *cpu = DefCpu;
if (mem) *mem = DefMem;
if (pf)  *pf  = DefPf;
if (nice)*nice= DefNice;
if (fsec)*fsec= DefFutureSec;
}

#if defined(rs6000) || defined(__MSDOS__) || defined(intelnx)
#include <time.h>
#endif

/*@
   SYGetResourceLimits - This gets the values of the resource limits.

   Input Parameters:
.  Argc  - pointer to number of arguments
.  argv  - argument vector
.  rflag - if set, remove the args

   Output Parameters:
.  cpu    - limit on cpu in seconds
.  mem    - limit on memory in megabytes
.  pf     - limit on pagefaults
.  maxtimein - limit on elapsed time

   Arguments Recognized:
.     -cpu  min   minutes of cpu time
.     -mem  mb    megabytes of memory
.     -pf   n     number of pagefaults
.     -dtime hh:mm time (delta) from current time
.     -atime hh:mm time (absolute)

    Notes:
    Values not set are not changed.
@*/
void SYGetResourceLimits( Argc, argv, cpu, mem, pf, maxtimein, rflag )
int  *Argc;
char **argv;
int  *cpu, *mem, *pf, rflag;
struct timeval *maxtimein;
{
#define TVALLEN 1024
char      timestr[TVALLEN];
struct tm *tmm;
int       offset;
time_t    clock1;

/* Search through the arguments */
if (SYArgGetInt( Argc, argv, rflag, "-cpu", cpu )) 
    *cpu *= 60; /* change to seconds */
SYArgGetInt( Argc, argv, rflag, "-mem", mem );
SYArgGetInt( Argc, argv, rflag, "-pf",  pf  );
if (SYArgGetString( Argc, argv, rflag, "-atime", timestr, TVALLEN )) {
    /* START-OF-TODAY + value */
    /* Get the current time in tm format */
    clock1 = time( (time_t *) 0 );
    tmm = localtime( &clock1 );
    offset = tmm->tm_sec + 60 * (tmm->tm_min + 60 * tmm->tm_hour);
    SYGetDayTime( maxtimein );
    /* Set to the start of today */
    maxtimein->tv_sec -= offset;
    /* Form maxtime value */
    maxtimein->tv_sec += SYhhmmtoSec( timestr );
    }
if (SYArgGetString( Argc, argv, rflag, "-dtime", timestr, TVALLEN )) {
    /* NOW + value */
    SYGetDayTime( maxtimein );
    maxtimein->tv_sec += SYhhmmtoSec( timestr );
    }
}

/*
     Convert a string of the form hh:mm to the equivalent number of seconds
 */

long SYhhmmtoSec( s )
char *s;
{
struct tm TM;

/* There is a routine called strptime that does what we want, but many
   systems don't have it.  The call would look like 
   strptime( s, "%H:%M", &TM ); */
sscanf( s, "%d:%d", &TM.tm_hour, &TM.tm_min );
return 60 * (TM.tm_min + 60 * TM.tm_hour);
}

/*@
   SYChangeResourceDefaults - Change the default values for resource 
   limits.

   Input Parameters:
   cpu,mem,pf futuretime - if positive, change that value
@*/
void SYChangeResourceDefaults( cpu, mem, pf, futuretime )
int cpu, mem, pf, futuretime;
{
if (cpu >= 0) DefCpu = cpu;
if (mem >= 0) DefMem = mem;
if (pf >= 0)  DefPf  = pf;
if (futuretime >= 0) DefFutureSec = futuretime;
}

/*@
     SYArgsToResources - Given command-line style arguments, generate 
     resource values.

     Description:
     Requested number of processors and an architecture.  Later, we'll
     allow cpu and memory limits to be specified.

.     -np n       Number of processors
.     -arch name  Architecture name
.     -exes name  Name of program (fully qualified)
.     -dbg        write out the decision process (debugging)

      Note:
      Defaults should be set before entering this routine.
@*/
void SYArgsToResources( Argc, argv, np, dbg, arch, exes )
int  *Argc;
char **argv;
int  *np, *dbg;
char *exes;
char *arch;
{
char path[MAXPATHLEN];

SYArgGetInt( Argc, argv, 1, "-np", np );
SYArgGetString( Argc, argv, 1, "-arch", arch, 20 );
if (SYArgGetString( Argc, argv, 1, "-exes", path, MAXPATHLEN ))
    SYGetFullPath( path, exes, MAXPATHLEN );
if (SYArgHasName( Argc, argv, 1, "-dbg" )) *dbg = 1;
}
