/*
   This file defines the vector operations in the simplest way possible
   (that still allows for general user contexts):  The first field in the
   user context contains size of the vector, and the actual vector type
   is no more than a pointer to the data 

   These are for double precision serial vectors.
 */

#if !defined(__DVEC)
#define __DVEC

void DVdot();
void DVnorm();
void DVmax();
void DVscal();
void DVcopy();
void DVswap();
void DVset();
void DVaxpy();
void DVaypx();
void DVwaxpy();
void DVpmult();
void DVpdiv();
void DVgather();
void DVscatter();
void **DVobtain_vectors();
void DVrelease_vectors();
void *DVCreateVector();
void DVDestroyVector();
void DVSetDefaultFunctions();
#endif
