#include <stdio.h>
#include "tools.h"
#include "xtools/basex11.h"
#define NO_GENERIC_SPARSE
#include "psolvers/psvctx.h"
#include "fd/fd.h"

#include <math.h>

#define X_SIZE 11
#define Y_SIZE 13

/* 
   This example should generate the same image regardless of the
   number of processors.
 */
main( argc, argv )
int argc;
char **argv;
{
int worker();
PICall( worker, argc, argv );
}

int worker( argc, argv )
int argc;
char **argv;
{
PSpMat *pmat;
SpMat  *mat;
int    mx, my, si, ei, sj, ej;
int    *lidx;
int    Nx, Ny;   /* Number of processors in each direction */
int    ri, rj;   /* Indices of the subdomain relative */
int    i, j, cnt, errs;
int    nx, ny;
int    ln;       /* size of the local vector in elements */
int    NL;
double *b, *x;
int    its, ncolor;

if (SYArgHasName( &argc, argv, 1, "-help" )) {
    fprintf( stderr, "%s Matrix example\n", argv[0] );
    exit(0);
    }
SYArgGetInt( &argc, argv, 1, "-nc", &ncolor );
XBPQGetArgs( &argc, argv, 1 );

/* Figure out my part of the matrix and generate it */
mx = 4;
my = 4;
SYArgGetInt( &argc, argv, 1, "-mx", &mx );
SYArgGetInt( &argc, argv, 1, "-my", &my );

/* By default, use a strip-wise decomposition that maps the distributed vector
   into contiguous pieces.  Note that "findowner" only works with this
   kind of decomposition */
Nx  = 1;
Ny  = NUMNODES;
ri  = MYPROCID % Nx;
rj  = MYPROCID / Nx;

/* Find the local limits of the matrix */
nx = mx / Nx;
ny = my / Ny;
si = ri * nx;
ei = si + nx - 1;

sj = rj * ny;
ej = sj + ny - 1;
if (ei >= mx) ei = mx - 1;
if (ej >= my) ej = my - 1;
mat = FDBuildLaplacian2dBndySub( mx, my, 0.0, 0.0, 0.0, si, ei, sj, ej );

ln   = (ei - si + 1) * (ej - sj + 1);
lidx = (int *)MALLOC( ln * sizeof(int) );
cnt  = 0;
NL   = ln;
for (j=sj; j<=ej; j++) 
    for (i=si; i<=ei; i++) 
	lidx[cnt++] = i + j * mx;

pmat = PSpCreate( mat, lidx );

XBPQMatrix( pmat, ncolor, 1 );

/* Use PSpPrint to print the matrix */
/* PSpPrint( 0, pmat ); */

/* Make sure to GSYNC; otherwise, the first process may delete the window
   before the others have written to it */
GSYNC(ALLPROCS);
sleep(5);
}

