#ifndef LINT
static char SCCSid[]    = "@(#) ./xtools/pointer/rbbox.c 07/23/93";
#endif

/*
    This file contains routines to handle a rubber-band box.
    For now, pressing DOWN the indicated button sets the
    start location; releasing that button completes the
    region definition
 */

/* #define DBUG  */
#ifdef DBUG
#include <stdio.h>
#endif

#include "tools.h"
#include "xtools/basex11.h"

/*
   For these routines to work, the input masks on the window must include
    ButtonPressMask | ButtonReleaseMask;
 */

static GC gc_xor = 0;

/*-----------------------------------------------------------------------------
 *      XBxor_box( display, drawable, gcXOR, x1, y1, x2, y2 )
 *              Draws a rectangle from (x1,y1) to (x2,y2) in the
 *              specified drawable using the exclusive-or operator.
 *      input:
 *              display         display
 *              drawable        mywindow->curbuf, usually
 *              gcXOR           graphics context to use (XOR)
 *              (x1,y1)         one corner of the box...
 *              (x2,y2)         the other corner of the box
 *      revisions:
 *              10/05/89 wdg    created
 *      notes:
 *              converted to a macro for better response time
 *---------------------------------------------------------------------------*/
/* Note that XDrawRectangle DOES NOT WORK; it leaves some debris in 1-3
   quadrants */
#if defined(rs6000)
/* Fails to compile with optimization on rs6000's */
void XBxor_box( display, drawable, gcXOR, x1, y1, x2, y2 ) 
Display  *display;
Drawable drawable;
GC       gcXOR;
int      x1, y1, x2, y2;
{
XDrawLine( display, drawable, gcXOR, x1, y1, x2, y1 );
XDrawLine( display, drawable, gcXOR, x2, y1, x2, y2 );
XDrawLine( display, drawable, gcXOR, x2, y2, x1, y2 );
XDrawLine( display, drawable, gcXOR, x1, y2, x1, y1 ); 
}
#else
#define XBxor_box( display, drawable, gcXOR, x1, y1, x2, y2 ) \
        { \
        XDrawLine( display, drawable, gcXOR, x1, y1, x2, y1 );\
        XDrawLine( display, drawable, gcXOR, x2, y1, x2, y2 );\
        XDrawLine( display, drawable, gcXOR, x2, y2, x1, y2 );\
        XDrawLine( display, drawable, gcXOR, x1, y2, x1, y1 ); }
/*         XDrawRectangle( display, drawable, gcXOR, x1, y1, x2-(x1), y2-(y1) ); */
#endif
/*-----------------------------------------------------------------------------
 *      XBrbbox( )
 *              Returns the location of the opposing corner
 *              of a rubber-band box in the specified window.
 *---------------------------------------------------------------------------*/
XBrbbox( XBWin, key, x, y, routine, context )
XBWindow        *XBWin;
int             x, y;
unsigned int    key;
void            (*routine)(), *context;
{
int     x1, y1, oldx, oldy, newx, newy, has_drawn, xl, yl, xh, yh;

if (key != Button1) {
    /* wait for release of the button */
    XBWaitButton( XBWin, key );
    return;
    }

XBSaveWindowMask( XBWin );
XBdrag_cursor( XBWin );

/* set location of first corner of box */
x1  = x;
y1  = y;
xl  = XBWin->x;
yl  = XBWin->y;
xh  = xl + XBWin->w;
yh  = yl + XBWin->h;
/* while left button is dragged, redraw box using ROP_XOR */
has_drawn   = 0;
/* 
  Make sure that the xor is likely to change something on the display
  */
if (!gc_xor) {
    XGCValues       gcvalues;       /* window graphics context values */

    gcvalues.function   = GXxor;
    gc_xor = XCreateGC( XBWin->disp, RootWindow(XBWin->disp,XBWin->screen),
                              GCFunction, &gcvalues );
    }
XSetForeground( XBWin->disp, gc_xor, 0xff );

XBstart_drag( XBWin );
while (!XBdo_drag( XBWin, Button1, &newx, &newy )) {
    if (has_drawn) {
        XBxor_box( XBWin->disp, XBWin->win, gc_xor,
                        x1, y1, oldx, oldy );
        }
    else has_drawn  = 1;
    /* clip motion within the specified region */
    if (newx < xl)      newx  = xl;
    else if (newx > xh) newx  = xh;
    if (newy < yl)      newy  = yl;
    else if (newy > yh) newy  = yh;
    XBxor_box( XBWin->disp, XBWin->win, gc_xor,
                    x1, y1, newx, newy );
    oldx = newx;
    oldy = newy;
    }
if (has_drawn) {
    XBxor_box( XBWin->disp, XBWin->win, gc_xor,
                    x1, y1, oldx, oldy );
    }
XBrestore_cursor( XBWin );

/* return the corner point (relative to a lower-left origin) */
(*routine)( XBWin, x, y, newx, newy, context );

/* restore the saved mask */
XBRestoreWindowMask( XBWin );
}
