#ifndef lint
static char SCCSid[] = "@(#) ./xtools/surface/srfsup.c 07/23/93";
#endif

#include "tools.h"
#include "xtools/basex11.h"

void XBFindScale(), XBdoscale(), XBApplyScale();

/*
    Scale the user-provided data to lie in [0,1]^3
 */
void XBSurfaceScale( mesh, x, y, nx, ny, qaspect )
double   *mesh, *x, *y;
int      nx, ny, qaspect;
{
if (qaspect) {
    /* find the min scaling for all directions */
    double sx, sy, sz, mx, my, mz;
    XBFindScale( x, nx, &sx, &mx );
    XBFindScale( y, ny, &sy, &my );
    XBFindScale( mesh, nx * ny, &sz, &mz );
    if (sy < sx) sx = sy;
    if (sz < sx) sx = sz;
    XBApplyScale( x, nx, sx, mx );
    XBApplyScale( y, ny, sx, my );
    XBApplyScale( mesh, nx * ny, sx, mz );
    }
else {
    XBdoscale( mesh, nx * ny );
    XBdoscale( x, nx );
    XBdoscale( y, ny );
    }
}

/* Find a scaling that "doscale" can use to map p[0:n-1] into [0,1] */
void XBFindScale( p, n, Sc, Mn )
double *p, *Sc, *Mn;
int    n;
{
register double *pp, mx, mn, sc;
int      nn;

pp  = p;
nn  = n;
mx  = *pp; mn = *pp++; nn--;
while (nn--) {
    if (*pp < mn) mn = *pp;
    else if (*pp > mx) mx = *pp;
    pp++;
    }
sc  = mx - mn;
if (sc <= 0) sc = 1.0;
else         sc = 1.0 / sc;
*Sc = sc;
*Mn = mn;
}

/* Apply a scaling to p[0:n-1] */
void XBApplyScale( p, n, sc, mn )
register double *p, sc, mn;
register int    n;
{
while (n--) {
    *p = (*p - mn) * sc;
    p++;
    }
}

/* This routine scales the data p[0:n-1] to lie in [0,1] */
void XBdoscale( p, n )
double *p;
int    n;
{
double mn, sc;

XBFindScale( p, n, &sc, &mn );
XBApplyScale( p, n, sc, mn );
}
