/*
 * File: sock_rtns.h
 *   By: Dave Hiebeler
 *       May 1988
 *
 * Header-file for the socket-routines
 *
 */

/*
 *
 * Cellsim copyright 1989, 1990 by Chris Langton and Dave Hiebeler
 * (cgl@lanl.gov, hiebeler@heretic.lanl.gov)
 *
 * This package may be freely distributed, as long as you don't:
 * - remove this notice
 * - try to make money by doing so
 * - prevent others from copying it freely
 * - distribute modified versions without clearly documenting your changes
 *   and notifying us
 *
 * Please contact either of the authors listed above if you have questions
 * or feel an exception to any of the above restrictions is in order.
 *
 * If you make changes to the code, or have suggestions for changes,
 * let us know!  If we use your suggestion, you will receive full credit
 * of course.
 */

/*****
 * Cellsim history:
 *
 * Cellsim was originally written on Apollo workstations by Chris Langton.
 *
 * Sun versions:
 *
 * - version 1.0
 *   by C. Ferenbaugh and C. Langton
 *   released 09/02/88
 *
 * - version 1.5
 *   by Dave Hiebeler and C. Langton  May - June 1989
 *   released 07/03/89
 *
 * - version 2.0
 *   by Dave Hiebeler and C. Langton  July - August 1989
 *   never officially released (unofficially released 09/08/89)
 *
 * - version 2.5
 *   by Dave Hiebeler and C. Langton  September '89 - February 1990
 *   released 02/26/90
 *****/



/* We probably don't need to include *all* of these.. but I haven't
 * carefully checked to see just what we do and don't need.
 */

#include <stdio.h>      /* for fprintf, NULL, etc, etc */
#include <errno.h>      /* for errno, and error names */
#include <strings.h>    /* for strcpy, strcmp */
#include <signal.h>     /* for signal */
#include <sys/file.h>   /* for open, close */
#include <sys/ioctl.h>  /* for ioctl */
#include <sys/time.h>   /* for the timeout structure */
#include <sys/types.h>  /* for accept, socket, listen */
#include <sys/socket.h> /* for accept, socket, listen */
#include <netinet/in.h> /* for sockaddr_in structure */
#include <netdb.h>      /* for hostent structure */
#include <arpa/inet.h>	/* for inet_ntoa & other stuff */


#define ON	1
#define OFF	0


extern int
	write_to_sock(),
	read_from_sock(),
	open_host_socket(),
	get_my_host_number(),
	wait_to_accept_socket(),
	connect_to_waiting_socket(),
	write_to_file(),
	see_who_client_is(),
	read_from_file(),
	set_mode();
