#!/bin/sh
# Output RCS compile-time configuration.
Id='$Id: conf.sh,v 5.14 1991/11/20 18:21:10 eggert Exp $'
#	Copyright 1990, 1991 by Paul Eggert
#	Distributed under license by the Free Software Foundation, Inc.

# This file is part of RCS.
#
# RCS is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# RCS is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with RCS; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Report problems and direct all questions to:
#
#     rcs-bugs@cs.purdue.edu


# Standard output should already be directed to "a.h";
# later parts of this procedure need it.
# Standard error can be ignored if a.h is OK,
# and can be inspected for clues otherwise.

# The Makefile overrides the following defaults.
: ${CC=cc}
: ${CFLAGS=-O}
: ${COMPAT2=0}
: ${DIFF3=${RCSPREFIX}diff3}
: ${DIFF3_BIN=1}
: ${DIFF=${RCSPREFIX}diff}
: ${DIFF_FLAGS=-an}
: ${DIFF_L=1}
: ${DIFF_SUCCESS=0} ${DIFF_FAILURE=1} ${DIFF_TROUBLE=2}
: ${ED=/bin/ed}
: ${RCSPREFIX=/usr/local/bin/}
: ${SENDMAIL='"/usr/lib/sendmail"'}
# : ${LDFLAGS=} ${LDLIBS=} tickles old shell bug

C="$CC $CFLAGS"
CL="$CC $CFLAGS $LDFLAGS"
L=$LDLIBS
RM='rm -f a.out'

cat <<EOF
/* RCS compile-time configuration */

	/* $Id */

/*
 * This file is generated automatically.
 * If you edit it by hand your changes may be lost.
 * Instead, please try to fix conf.sh,
 * and send your fixes to rcs-bugs@cs.purdue.edu.
 */

EOF

: exitmain
cat >a.c <<EOF
#include "a.h"
int main(argc,argv) int argc; char **argv; { return argc-1; }
EOF
$RM && $CL a.c $L >&2 || exit
e='exit(n), 3 /* lint fodder */'
if ./a.out -
then :
elif ./a.out
then e=n
fi
echo "#define exitmain(n) return $e /* how to exit from main() */"

: _POSIX_SOURCE
cat >a.c <<'EOF'
#include "a.h"
#include <stdio.h>
int main() { exitmain(fileno(stdout) < 0); }
EOF
a='/* ' z='*/ '
$RM || exit
if ($CL a.c $L && ./a.out) >&2
then :
elif $RM || exit; ($CL -D_POSIX_SOURCE a.c $L && ./a.out) >&2
then a= z=
fi
cat <<EOF
$a#define _POSIX_SOURCE $z/* Define this if Posix + strict Standard C.  */

#include <errno.h>
#include <stdio.h>
#include <time.h>
EOF

cat <<'EOF'

/* Comment out #include lines below that do not work.  */
EOF

# Run `$CS a.c $LS' instead of `$CL a.c $L' for compile-time checking only.
# This speeds up the configuration process.
if $C -S a.c >&2
then CS="$C -S" LS=	# Generate assembly language output.
elif $C -c a.c >&2
then CS="$C -c" LS=	# Generate object code.
else CS=$CL LS=$L	# Generate an executable.
fi

cat >a.ha <<EOF

#if has_ftruncate
	int ftruncate P((int,off_t));
#endif

/* <sys/mman.h> */
#if has_madvise
	int madvise P((caddr_t,size_t,int));
#endif
#if has_mmap
	caddr_t mmap P((caddr_t,size_t,int,int,int,off_t));
	int munmap P((caddr_t,size_t));
#endif


/* Posix (ISO/IEC 9945-1: 1990 / IEEE Std 1003.1-1990) */
/* These definitions are for the benefit of non-Posix hosts, and */
/* Posix hosts that have Standard C compilers but traditional include files.  */
/* Unfortunately, mixed-up hosts are all too common.  */

/* <fcntl.h> */
#ifdef F_DUPFD
	int fcntl P((int,int,...));
#else
	int dup2 P((int,int));
#endif
#ifndef O_BINARY /* some non-Posix hosts need O_BINARY */
#	define O_BINARY 0 /* no effect on Posix */
#endif
#ifdef O_CREAT
#	define open_can_creat 1
#else
#	define open_can_creat 0
#	define O_RDONLY 0
#	define O_WRONLY 1
#	define O_RDWR 2
#	define O_CREAT 01000
#	define O_TRUNC 02000
	int creat P((char const*,mode_t));
#endif
#ifndef O_EXCL
#	define O_EXCL 0
#endif

/* <pwd.h> */
#if has_getpwuid
	struct passwd *getpwuid P((uid_t));
#endif

/* <signal.h> */
#if has_sigaction
	int sigaction P((int,struct sigaction const*,struct sigaction*));
	int sigaddset P((sigset_t*,int));
	int sigemptyset P((sigset_t*));
#else
#if has_sigblock
	/* BSD */
	int sigblock P((int));
	int sigmask P((int));
	int sigsetmask P((int));
#endif
#endif

/* <stdio.h> */
FILE *fdopen P((int,char const*));
int fileno P((FILE*));

/* <sys/stat.h> */
int chmod P((char const*,mode_t));
int fstat P((int,struct stat*));
int stat P((char const*,struct stat*));
mode_t umask P((mode_t));
#if has_fchmod
	int fchmod P((int,mode_t));
#endif
#ifndef S_IRUSR
#	ifdef S_IREAD
#		define S_IRUSR S_IREAD
#	else
#		define S_IRUSR 0400
#	endif
#	ifdef S_IWRITE
#		define S_IWUSR S_IWRITE
#	else
#		define S_IWUSR (S_IRUSR/2)
#	endif
#endif
#ifndef S_IRGRP
#	if has_getuid
#		define S_IRGRP (S_IRUSR / 0010)
#		define S_IWGRP (S_IWUSR / 0010)
#		define S_IROTH (S_IRUSR / 0100)
#		define S_IWOTH (S_IWUSR / 0100)
#	else
		/* single user OS -- not Posix or Unix */
#		define S_IRGRP 0
#		define S_IWGRP 0
#		define S_IROTH 0
#		define S_IWOTH 0
#	endif
#endif
#ifndef S_ISREG
#	define S_ISREG(n) (((n) & S_IFMT) == S_IFREG)
#endif

/* <sys/wait.h> */
#if has_wait
	pid_t wait P((int*));
#endif
#ifndef WEXITSTATUS
#	define WEXITSTATUS(stat_val) ((unsigned)(stat_val) >> 8)
#	undef WIFEXITED /* Avoid 4.3BSD incompatibility with Posix.  */
#endif
#ifndef WIFEXITED
#	define WIFEXITED(stat_val) (!((stat_val) & 255))
#endif

/* <unistd.h> */
char *getlogin P((void));
int close P((int));
int isatty P((int));
int link P((char const*,char const*));
int open P((char const*,int,...));
int unlink P((char const*));
int _filbuf P((FILE*)); /* keeps lint quiet in traditional C */
int _flsbuf P((int,FILE*)); /* keeps lint quiet in traditional C */
long pathconf P((char const*,int));
ssize_t write P((int,void const*,size_t));
#ifndef STDIN_FILENO
#	define STDIN_FILENO 0
#	define STDOUT_FILENO 1
#	define STDERR_FILENO 2
#endif
#if has_fork
#	if !has_vfork
#		undef vfork
#		define vfork fork
#	endif
	pid_t vfork P((void)); /* vfork is nonstandard but faster */
#endif
#if has_getcwd || !has_getwd
	char *getcwd P((char*,size_t));
#else
	char *getwd P((char*));
#endif
#if has_getuid
	uid_t getuid P((void));
#endif
#if has_readlink
	ssize_t readlink P((char const*,char*,size_t)); /* BSD; not standard yet */
#endif
#if has_setuid
#	if !has_seteuid
#		undef seteuid
#		define seteuid setuid
#	endif
	int seteuid P((uid_t));
	uid_t geteuid P((void));
#endif
#if has_spawn
	int spawnv P((int,char const*,char*const*));
#	if ALL_ABSOLUTE
#		define spawn_RCS spawnv
#	else
#		define spawn_RCS spawnvp
		int spawnvp P((int,char const*,char*const*));
#	endif
#else
	int execv P((char const*,char*const*));
#	if ALL_ABSOLUTE
#		define exec_RCS execv
#	else
#		define exec_RCS execvp
		int execvp P((char const*,char*const*));
#	endif
#endif

/* utime.h */
int utime P((char const*,struct utimbuf const*));


/* Standard C library */
/* These definitions are for the benefit of hosts that have */
/* traditional C include files, possibly with Standard C compilers.  */
/* Unfortunately, mixed-up hosts are all too common.  */

/* <errno.h> */
extern int errno;

/* <limits.h> */
#ifndef ULONG_MAX
	/* This does not work in #ifs, but it's good enough for us.  */
#	define ULONG_MAX ((unsigned long)-1)
#endif

/* <signal.h> */
#if has_signal
	signal_type (*signal P((int,signal_type(*)signal_args)))signal_args;
#endif

/* <stdio.h> */
FILE *fopen P((char const*,char const*));
fread_type fread P((void*,freadarg_type,freadarg_type,FILE*));
fread_type fwrite P((void const*,freadarg_type,freadarg_type,FILE*));
int fclose P((FILE*));
int feof P((FILE*));
int ferror P((FILE*));
int fflush P((FILE*));
int fprintf P((FILE*,char const*,...));
int fputs P((char const*,FILE*));
int fseek P((FILE*,long,int));
int printf P((char const*,...));
int rename P((char const*,char const*));
int sprintf P((char*,char const*,...));
long ftell P((FILE*));
void clearerr P((FILE*));
void perror P((char const*));
#ifndef L_tmpnam
#	define L_tmpnam 32 /* power of 2 > sizeof("/usr/tmp/xxxxxxxxxxxxxxx") */
#endif
#ifndef SEEK_SET
#	define SEEK_SET 0
#endif
#if has_mktemp
	char *mktemp P((char*)); /* traditional */
#else
	char *tmpnam P((char*));
#endif
#if has_vfprintf
	int vfprintf P((FILE*,char const*,va_list));
#else
#if has__doprintf
	void _doprintf P((FILE*,char const*,va_list)); /* Minix */
#else
	void _doprnt P((char const*,va_list,FILE*)); /* BSD */
#endif
#endif

/* <stdlib.h> */
char *getenv P((char const*));
exiting void _exit P((int));
exiting void exit P((int));
malloc_type malloc P((size_t));
malloc_type realloc P((malloc_type,size_t));
void free P((malloc_type));
#ifndef EXIT_FAILURE
#	define EXIT_FAILURE 1
#endif
#ifndef EXIT_SUCCESS
#	define EXIT_SUCCESS 0
#endif
#if !has_fork && !has_spawn
	int system P((char const*));
#endif

/* <string.h> */
char *strcpy P((char*,char const*));
char *strchr P((char const*,int));
char *strrchr P((char const*,int));
int memcmp P((void const*,void const*,size_t));
int strcmp P((char const*,char const*));
size_t strlen P((char const*));
void *memcpy P((void*,void const*,size_t));
#if has_memmove
	void *memmove P((void*,void const*,size_t));
#endif

/* <time.h> */
time_t time P((time_t*));
EOF

cat >a.c <<'EOF'
#include "a.h"
#define a 0
#define b 1
#if h==a
#	include "a.ha"
#else
#	include "a.hb"
#endif
int main() { exitmain(0); }
EOF

# Comment out lines in a.ha that the compiler rejects.
# a.ha may not contain comments that cross line boundaries.
# Leave the result in a.h$h.
h=a l=1
U=`wc -l <a.ha | sed 's| ||g'`
commentOut='s|^[^#/][^/]*|/* & */|'

until  test $U -lt $l  ||  $CS -Dh=$h a.c $LS >&2
do
	case $h in
	a) i=b;;
	*) i=a
	esac

	# The compiler rejects some line in l..U.
	# Use binary search to set l to be the index of the first bad line in l..U.
	u=$U
	while test $l -lt $u
	do
		M=`expr '(' $l + $u ')' / 2`
		M1=`expr $M + 1`
		sed "$M1,\$$commentOut" a.h$h >a.h$i || exit
		if $CS -Dh=$i a.c $LS >&2
		then l=$M1
		else u=$M
		fi
	done

	# Comment out the bad line.
	sed "$l$commentOut" a.h$h >a.h$i || exit

	h=$i
	l=`expr $l + 1`
done

cat a.h$h
