/*
 * Decompiled with CFR 0.152.
 */
package com.claritysys.jvm.disassembler;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class IndentingWriter
extends FilterWriter {
    private Exception error;
    private boolean newLine = true;
    private int indent;
    private static final String[] INDENT = new String[]{"", "\t", "\t\t", "\t\t\t", "\t\t\t\t", "\t\t\t\t\t", "\t\t\t\t\t\t", "\t\t\t\t\t\t\t", "\t\t\t\t\t\t\t\t", "\t\t\t\t\t\t\t\t\t\t"};

    public IndentingWriter(Writer writer) {
        super(writer);
    }

    public void println(String s) {
        if (this.hasError()) {
            return;
        }
        try {
            if (this.newLine) {
                this.write(INDENT[this.indent]);
            }
            this.write(s);
            this.write(10);
            this.newLine = true;
        }
        catch (IOException ioe) {
            this.error = ioe;
        }
    }

    public void print(String s) {
        if (this.hasError()) {
            return;
        }
        try {
            if (this.newLine) {
                this.write(INDENT[this.indent]);
            }
            this.write(s);
            this.newLine = false;
        }
        catch (IOException ioe) {
            this.error = ioe;
        }
    }

    public void println() {
        if (this.hasError()) {
            return;
        }
        try {
            this.write(10);
            this.newLine = true;
        }
        catch (IOException ioe) {
            this.error = ioe;
        }
    }

    public Exception getError() {
        return this.error;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public void indent(int i) {
        this.indent += i;
        if (this.indent < 0 || this.indent >= INDENT.length) {
            throw new IllegalArgumentException("Illegal indent value: " + this.indent);
        }
    }
}

