# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import TYPE_CHECKING

from azure.mgmt.core import ARMPipelineClient
from msrest import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Optional

    from azure.core.credentials import TokenCredential

from ._configuration import OperationsManagementClientConfiguration
from .operations import SolutionsOperations
from .operations import ManagementAssociationsOperations
from .operations import ManagementConfigurationsOperations
from .operations import Operations
from . import models


class OperationsManagementClient(object):
    """Operations Management Client.

    :ivar solutions: SolutionsOperations operations
    :vartype solutions: operations_management_client.operations.SolutionsOperations
    :ivar management_associations: ManagementAssociationsOperations operations
    :vartype management_associations: operations_management_client.operations.ManagementAssociationsOperations
    :ivar management_configurations: ManagementConfigurationsOperations operations
    :vartype management_configurations: operations_management_client.operations.ManagementConfigurationsOperations
    :ivar operations: Operations operations
    :vartype operations: operations_management_client.operations.Operations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: Gets subscription credentials which uniquely identify Microsoft Azure subscription. The subscription ID forms part of the URI for every service call.
    :type subscription_id: str
    :param provider_name: Provider name for the parent resource.
    :type provider_name: str
    :param resource_type: Resource type for the parent resource.
    :type resource_type: str
    :param resource_name: Parent resource name.
    :type resource_name: str
    :param str base_url: Service URL
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
    """

    def __init__(
        self,
        credential,  # type: "TokenCredential"
        subscription_id,  # type: str
        provider_name,  # type: str
        resource_type,  # type: str
        resource_name,  # type: str
        base_url=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        if not base_url:
            base_url = 'https://management.azure.com'
        self._config = OperationsManagementClientConfiguration(credential, subscription_id, provider_name, resource_type, resource_name, **kwargs)
        self._client = ARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._serialize.client_side_validation = False
        self._deserialize = Deserializer(client_models)

        self.solutions = SolutionsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.management_associations = ManagementAssociationsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.management_configurations = ManagementConfigurationsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.operations = Operations(
            self._client, self._config, self._serialize, self._deserialize)

    def close(self):
        # type: () -> None
        self._client.close()

    def __enter__(self):
        # type: () -> OperationsManagementClient
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details):
        # type: (Any) -> None
        self._client.__exit__(*exc_details)
