# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class AuthType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Specifies the authentication type.
    """

    INVALID = "Invalid"
    ACS = "ACS"
    AAD = "AAD"
    ACCESS_CONTROL_SERVICE = "AccessControlService"
    AZURE_ACTIVE_DIRECTORY = "AzureActiveDirectory"

class PrivateEndpointConnectionStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Gets or sets the status.
    """

    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"
    DISCONNECTED = "Disconnected"

class ProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Gets or sets provisioning state of the private endpoint connection.
    """

    SUCCEEDED = "Succeeded"
    DELETING = "Deleting"
    FAILED = "Failed"
    PENDING = "Pending"

class ResourceIdentityType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The identity type.
    """

    SYSTEM_ASSIGNED = "SystemAssigned"
    NONE = "None"

class SkuName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The Sku name.
    """

    STANDARD = "Standard"
    RS0 = "RS0"

class TriggerType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The way the vault upgrade was triggered.
    """

    USER_TRIGGERED = "UserTriggered"
    FORCED_UPGRADE = "ForcedUpgrade"

class UsagesUnit(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Unit of the usage.
    """

    COUNT = "Count"
    BYTES = "Bytes"
    SECONDS = "Seconds"
    PERCENT = "Percent"
    COUNT_PER_SECOND = "CountPerSecond"
    BYTES_PER_SECOND = "BytesPerSecond"

class VaultPrivateEndpointState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Private endpoint state for backup.
    """

    NONE = "None"
    ENABLED = "Enabled"

class VaultUpgradeState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Status of the vault upgrade operation.
    """

    UNKNOWN = "Unknown"
    IN_PROGRESS = "InProgress"
    UPGRADED = "Upgraded"
    FAILED = "Failed"
