# Generated by Django 5.2.4 on 2025-07-04 21:51

from django.db import migrations, models


def forward_data(apps, schema_editor):
    DataMigrationModel = apps.get_model('datamigration', 'DataMigrationModel')
    for obj in DataMigrationModel.objects.all():
        obj.data = obj.old_data
        obj.save()



def backward_data(apps, schema_editor):
    DataMigrationModel = apps.get_model('datamigration', 'DataMigrationModel')
    for obj in DataMigrationModel.objects.all():
        obj.old_data = obj.data
        obj.save()


class Migration(migrations.Migration):

    dependencies = [
        ('datamigration', '0001_initial'),
    ]

    operations = [
        migrations.RenameField(
            model_name='DataMigrationModel',
            old_name='data',
            new_name='old_data',
        ),
        migrations.AddField(
            model_name='DataMigrationModel',
            name='data',
            field=models.JSONField(null=True),
        ),
        migrations.RunPython(forward_data, backward_data),
        migrations.RemoveField(
            model_name='DataMigrationModel',
            name='old_data',
        ),
        migrations.AlterField(
            model_name='DataMigrationModel',
            name='data',
            field=models.JSONField(),
        ),
    ]
