/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.presentation.rmi;

import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.presentation.rmi.ExceptionHandler;
import com.sun.corba.se.impl.presentation.rmi.IDLNameTranslatorImpl;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.rmi.UnexpectedException;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public class ExceptionHandlerImpl
implements ExceptionHandler {
    private ExceptionRW[] rws;
    private final ORBUtilSystemException wrapper = ORBUtilSystemException.get("rpc.presentation");

    public ExceptionHandlerImpl(Class[] classArray) {
        int n;
        int n2 = 0;
        for (n = 0; n < classArray.length; ++n) {
            Class clazz = classArray[n];
            if (RemoteException.class.isAssignableFrom(clazz)) continue;
            ++n2;
        }
        this.rws = new ExceptionRW[n2];
        n = 0;
        for (int i = 0; i < classArray.length; ++i) {
            Class clazz = classArray[i];
            if (RemoteException.class.isAssignableFrom(clazz)) continue;
            ExceptionRWBase exceptionRWBase = null;
            exceptionRWBase = UserException.class.isAssignableFrom(clazz) ? new ExceptionRWIDLImpl(clazz) : new ExceptionRWRMIImpl(clazz);
            this.rws[n++] = exceptionRWBase;
        }
    }

    private int findDeclaredException(Class clazz) {
        for (int i = 0; i < this.rws.length; ++i) {
            Class clazz2 = this.rws[i].getExceptionClass();
            if (!clazz2.isAssignableFrom(clazz)) continue;
            return i;
        }
        return -1;
    }

    private int findDeclaredException(String string) {
        for (int i = 0; i < this.rws.length; ++i) {
            if (this.rws[i] == null) {
                return -1;
            }
            String string2 = this.rws[i].getId();
            if (!string.equals(string2)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isDeclaredException(Class clazz) {
        return this.findDeclaredException(clazz) >= 0;
    }

    @Override
    public void writeException(OutputStream outputStream, Exception exception) {
        int n = this.findDeclaredException(exception.getClass());
        if (n < 0) {
            throw this.wrapper.writeUndeclaredException(exception, (Object)exception.getClass().getName());
        }
        this.rws[n].write(outputStream, exception);
    }

    @Override
    public Exception readException(ApplicationException applicationException) {
        InputStream inputStream = (InputStream)applicationException.getInputStream();
        String string = applicationException.getId();
        int n = this.findDeclaredException(string);
        if (n < 0) {
            string = inputStream.read_string();
            UnexpectedException unexpectedException = new UnexpectedException(string);
            unexpectedException.initCause(applicationException);
            return unexpectedException;
        }
        return this.rws[n].read(inputStream);
    }

    public ExceptionRW getRMIExceptionRW(Class clazz) {
        return new ExceptionRWRMIImpl(clazz);
    }

    public class ExceptionRWRMIImpl
    extends ExceptionRWBase {
        public ExceptionRWRMIImpl(Class clazz) {
            super(clazz);
            this.setId(IDLNameTranslatorImpl.getExceptionId(clazz));
        }

        @Override
        public void write(OutputStream outputStream, Exception exception) {
            outputStream.write_string(this.getId());
            outputStream.write_value((Serializable)exception, this.getExceptionClass());
        }

        @Override
        public Exception read(InputStream inputStream) {
            inputStream.read_string();
            return (Exception)inputStream.read_value(this.getExceptionClass());
        }
    }

    public class ExceptionRWIDLImpl
    extends ExceptionRWBase {
        private Method readMethod;
        private Method writeMethod;

        public ExceptionRWIDLImpl(Class clazz) {
            Class[] classArray;
            Class<?> clazz2;
            super(clazz);
            String string = clazz.getName() + "Helper";
            ClassLoader classLoader = clazz.getClassLoader();
            try {
                clazz2 = Class.forName(string, true, classLoader);
                classArray = clazz2.getDeclaredMethod("id", null);
                this.setId((String)classArray.invoke(null, null));
            }
            catch (Exception exception) {
                throw ExceptionHandlerImpl.this.wrapper.badHelperIdMethod(exception, (Object)string);
            }
            try {
                classArray = new Class[]{org.omg.CORBA.portable.OutputStream.class, clazz};
                this.writeMethod = clazz2.getDeclaredMethod("write", classArray);
            }
            catch (Exception exception) {
                throw ExceptionHandlerImpl.this.wrapper.badHelperWriteMethod(exception, (Object)string);
            }
            try {
                classArray = new Class[]{org.omg.CORBA.portable.InputStream.class};
                this.readMethod = clazz2.getDeclaredMethod("read", classArray);
            }
            catch (Exception exception) {
                throw ExceptionHandlerImpl.this.wrapper.badHelperReadMethod(exception, (Object)string);
            }
        }

        @Override
        public void write(OutputStream outputStream, Exception exception) {
            try {
                Object[] objectArray = new Object[]{outputStream, exception};
                this.writeMethod.invoke(null, objectArray);
            }
            catch (Exception exception2) {
                throw ExceptionHandlerImpl.this.wrapper.badHelperWriteMethod(exception2, (Object)this.writeMethod.getDeclaringClass().getName());
            }
        }

        @Override
        public Exception read(InputStream inputStream) {
            try {
                Object[] objectArray = new Object[]{inputStream};
                return (Exception)this.readMethod.invoke(null, objectArray);
            }
            catch (Exception exception) {
                throw ExceptionHandlerImpl.this.wrapper.badHelperReadMethod(exception, (Object)this.readMethod.getDeclaringClass().getName());
            }
        }
    }

    public abstract class ExceptionRWBase
    implements ExceptionRW {
        private Class cls;
        private String id;

        public ExceptionRWBase(Class clazz) {
            this.cls = clazz;
        }

        @Override
        public Class getExceptionClass() {
            return this.cls;
        }

        @Override
        public String getId() {
            return this.id;
        }

        void setId(String string) {
            this.id = string;
        }
    }

    public static interface ExceptionRW {
        public Class getExceptionClass();

        public String getId();

        public void write(OutputStream var1, Exception var2);

        public Exception read(InputStream var1);
    }
}

