
/*
*  NCSA Telnet source code
*  National Center for Supercomputing Applications
*  November 1, 1987
*  (C) Copyright 1987 The Board of Trustees of the University of Illinois
*
*  Permission is granted to any individual or institution to use, copy,
*  modify, or redistribute this software and its documentation provided
*  this notice and the copyright notices are retained.  This software
*  may not be distributed for profit, either in original form or in
*  derivative works.  The University of Illinois makes no representations
*  about the suitability of this software for any purpose.  
*  THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY,
*  EITHER EXPRESS OR IMPLIED, FOR THE PROGRAM AND/OR DOCUMENTATION PROVIDED,
*  INCLUDING, WITHOUT LIMITATION, WARRANTY OF MERCHANTABILITY AND WARRANTY
*  OF FITNESS FOR A PARTICULAR PURPOSE.
*/
#ifndef lint
static char *SCCSid = "@(#)tekio.c	1.2	(NCSA)	8/12/87";
#endif lint

#include <stdio.h>

/*
** routines to support the tektronix device
*/

static FILE *tekout;
static int	oflag = -1;

/*
** open the tektronix save file
*/

open_tek()
{
	extern char tekfname[];
	char		*tekfile = tekfname;
	int			write_tek();

	if (*tekfile == '|') {
		tekout = popen(++tekfile, "w");
		oflag = 1;
	}
	else {
		tekout = fopen(tekfile,"w");
		oflag = 0;
	}

	if (tekout == NULL)
		return -1;

}

/*
** close the tektronix device
*/

close_tek()
{

	if (oflag)
		pclose(tekout);
	else
		fclose(tekout);
	
	oflag = -1;
}

/*
** write on the tektronix device
*/

tek_outfunc(s)
int s;
{
	if (s < 0)
		return;
	fputc(s, tekout);
}
