/* (C) Copyright 1990, 1991, 1992 the University of Virginia */


#include "privsuit.h"

#ifdef _Windows
#include <windows.h>
#include <ctype.h>
#define MAX_HELP_STRING_LEN 2000
#endif

typedef struct {
  char *className;
  char *propName;
  char *helpText;
} SUIT_help;



PRIVATE DynArray HelpMessages = NULL;

PRIVATE int CompareHelps (void *first, void *second)
{
  SUIT_help *help1 = (SUIT_help *) first;
  SUIT_help *help2 = (SUIT_help *) second;
  int diff;

  if ((diff = strcmp (help1->className, help2->className)) == 0)
    return strcmp (help1->propName, help2->propName);
  else return diff;
}
 

char *SUIT_getHelp (char *className, char *propName)
{
  SUIT_help newHelp, h; 
  int slot =0;
  newHelp.className = className;
  newHelp.propName = propName;
  newHelp.helpText = "no message yet";
  slot = DynFindIndex (HelpMessages, &newHelp, CompareHelps);
  if (slot == DYN_NOT_FOUND)
    return NULL;
  else { h = *(SUIT_help *) DynGet(HelpMessages, slot);
       return h.helpText; }
}



void SUIT_registerHelp (char *className, char *propName, char *helpText)
{
    SUIT_help newHelp; 
    if (HelpMessages == NULL)
      HelpMessages = DynCreate (sizeof(SUIT_help), 1);
    newHelp.className = className;
    newHelp.propName = propName;
    newHelp.helpText = helpText;
    DynAdd (HelpMessages, (void *) &newHelp);
}

#ifdef _Windows
void TranslatePropName(char *propName)
{
	int i;

	for (i=0; i<strlen(propName); i++) {
		propName[i] = tolower(propName[i]);
		if (propName[i] == '_')
			propName[i] = ' ';
	}
} 

/* The character sequence "#\" designates the end of the help
   test file.
   Any other characters on a line beginning with the character
   "#" are ignored.
*/
void ReadHelpText(void)
{
	char *stringRead = SUIT_malloc(MAX_HELP_STRING_LEN+1);
	char *className, *propName, *helpText;
	char *helpResource;
	HANDLE hResource;
	boolean done = FALSE;
	int whichString = 0;  /* 0=className, 1=propName, 2=helpText */
    int i;

	hResource = LoadResource(SRGP_inquireWinInstance(),
							 FindResource(SRGP_inquireWinInstance(),
										  "helptext", "TEXT"));
	helpResource = LockResource(hResource);

	while ((*helpResource != '\0') && !done) {
		if (*helpResource == '#') {
			helpResource = AnsiNext(helpResource);
			if (*helpResource == '\\')
				done = TRUE;
			else while (*helpResource != '\n')
				helpResource = AnsiNext(helpResource);
		} else if (*helpResource != '\n') {
			for (i = 0; *helpResource != '\n';) {
			    if (*helpResource != '\r')
				stringRead[i++] = *helpResource;
			    helpResource = AnsiNext(helpResource);
			}
            stringRead[i] = '\0';
			switch (whichString) {
			 case 0: className = SUIT_malloc(strlen(stringRead)+1);
					 strcpy(className, stringRead);
					 break;
			 case 1: propName = SUIT_malloc(strlen(stringRead)+1);
					 TranslatePropName(stringRead);
					 strcpy(propName, stringRead);
					 break;
			 case 2: helpText = SUIT_malloc(strlen(stringRead)+1);
					 strcpy(helpText, stringRead);
					 break;
			}
			whichString++;
			if (whichString == 3) {
               	SUIT_registerHelp (className, propName, helpText);
				whichString = 0;
			}
        }
		helpResource = AnsiNext(helpResource);
	}
	GlobalUnlock (hResource); 
}

#endif

void si_setUpHelp (void)
{
/* **********************************
 * help.c -----
 *
 * (C) Copyright 1990, 1991, 1992 the University of Virginia *
 *
 * DO NOT EDIT THIS FILE. THE TEXT OF
 * THIS FILE COMES FROM THE FRAMEMAKER
 * DOCUMENTATION
 ********************************** */

#ifdef _Windows
	ReadHelpText();
#else

SUIT_registerHelp ("all", ANIMATED, 
#ifdef MACINTOSH
"True when an object continually performs some animated function. For example, when ANIMATED is TRUE for the bouncing bal"
"l widget, the ball constantly moves around in its box. "
#else
"True when an object continually performs some animated function. For example, when ANIMATED is TRUE for the bouncing bal\
l widget, the ball constantly moves around in its box. "
#endif
);

SUIT_registerHelp ("all", BACKGROUND_COLOR, 
#ifdef MACINTOSH
"Default background color. For beveled display styles and GP shapes, this should be set to the same color as the border c"
"olor. Also see: FOREGROUND_COLOR and BORDER_COLOR. "
#else
"Default background color. For beveled display styles and GP shapes, this should be set to the same color as the border c\
olor. Also see: FOREGROUND_COLOR and BORDER_COLOR. "
#endif
);

SUIT_registerHelp ("all", BORDER_COLOR, 
#ifdef MACINTOSH
"Default border color. For beveled display styles and GP shapes, this should be set to the same color as the background c"
"olor. Also see: FOREGROUND_COLOR and BORDER_COLOR. "
#else
"Default border color. For beveled display styles and GP shapes, this should be set to the same color as the background c\
olor. Also see: FOREGROUND_COLOR and BORDER_COLOR. "
#endif
);

SUIT_registerHelp ("all", BORDER_RAISED, 
#ifdef MACINTOSH
"Used in the motif border style. Setting this to FALSE makes a widget appear to be depressed into the screen, away from t"
"he viewer. Setting this to TRUE makes a widget appear to be raised out of the screen, toward the viewer. Also see: BORDE"
"R_TYPE, BORDER_WIDTH, DRAW_BORDER_ON_INSIDE, and HAS_BORDER. "
#else
"Used in the motif border style. Setting this to FALSE makes a widget appear to be depressed into the screen, away from t\
he viewer. Setting this to TRUE makes a widget appear to be raised out of the screen, toward the viewer. Also see: BORDE\
R_TYPE, BORDER_WIDTH, DRAW_BORDER_ON_INSIDE, and HAS_BORDER. "
#endif
);

SUIT_registerHelp ("all", BORDER_TYPE, 
#ifdef MACINTOSH
"Three options are available: simple, motif and fancy motif. A simple border is just a rectangle drawn in the border colo"
"r. Motif borders have a 3-D look about them. Fancy motif borders have the 3-D look with much more decoration added. They"
" are usually used for SUIT Dialog Boxes which grab the input focus and thus the user's attention (hence the fanciness). "
"Also see: BORDER_RAISED, BORDER_WIDTH, DRAW_BORDER_ON_INSIDE, and HAS_BORDER. "
#else
"Three options are available: simple, motif and fancy motif. A simple border is just a rectangle drawn in the border colo\
r. Motif borders have a 3-D look about them. Fancy motif borders have the 3-D look with much more decoration added. They\
 are usually used for SUIT Dialog Boxes which grab the input focus and thus the user's attention (hence the fanciness). \
Also see: BORDER_RAISED, BORDER_WIDTH, DRAW_BORDER_ON_INSIDE, and HAS_BORDER. "
#endif
);

SUIT_registerHelp ("all", BORDER_WIDTH, 
#ifdef MACINTOSH
"The width of the border given in pixels. Also see: BORDER_RAISED, BORDER_TYPE, DRAW_BORDER_ON_INSIDE, and HAS_BORDER. "
#else
"The width of the border given in pixels. Also see: BORDER_RAISED, BORDER_TYPE, DRAW_BORDER_ON_INSIDE, and HAS_BORDER. "
#endif
);

SUIT_registerHelp ("all", CAN_BE_OPENED, 
#ifdef MACINTOSH
"Set to TRUE when the widget being examined is a pulldown menu or a bulletin board. "

#else
"Set to TRUE when the widget being examined is a pulldown menu or a bulletin board. \
"
#endif
);

SUIT_registerHelp ("all", CLIP_TO_VIEWPORT, 
#ifdef MACINTOSH
"When TRUE, a widget cannot draw graphics outside its own viewport. When FALSE, a widget can draw anywhere on the screen."
" This property is almost always TRUE. Also see: VIEWPORT. "
#else
"When TRUE, a widget cannot draw graphics outside its own viewport. When FALSE, a widget can draw anywhere on the screen.\
 This property is almost always TRUE. Also see: VIEWPORT. "
#endif
);

SUIT_registerHelp ("all", DEFAULT_OBJECT_HEIGHT, 
#ifdef MACINTOSH
"Sets the height of widgets created interactively and widgets that have no VIEWPORT property specified(pixels). "
#else
"Sets the height of widgets created interactively and widgets that have no VIEWPORT property specified(pixels). "
#endif
);

SUIT_registerHelp ("all", DEFAULT_OBJECT_WIDTH, 
#ifdef MACINTOSH
"Sets the width of widgets created interactively and widgets that have no VIEWPORT property specified(pixels) "
#else
"Sets the width of widgets created interactively and widgets that have no VIEWPORT property specified(pixels) "
#endif
);

SUIT_registerHelp ("all", DRAW_BORDER_ON_INSIDE, 
#ifdef MACINTOSH
"When FALSE, a widget's border is drawn to the outside of the widget's stated viewport. Also see: BORDER_RAISED, BORDER_W"
"IDTH, BORDER_TYPE, and HAS_BORDER. "
#else
"When FALSE, a widget's border is drawn to the outside of the widget's stated viewport. Also see: BORDER_RAISED, BORDER_W\
IDTH, BORDER_TYPE, and HAS_BORDER. "
#endif
);

SUIT_registerHelp ("all", FONT, 
#ifdef MACINTOSH
"Default font that widgets will use if they do not specify a font at their class or object levels. The format of the stri"
"ng you see is: typeface, style, point size. For example 10 point bold italic Times would be written: times, bold italic,"
" 10. "
#else
"Default font that widgets will use if they do not specify a font at their class or object levels. The format of the stri\
ng you see is: typeface, style, point size. For example 10 point bold italic Times would be written: times, bold italic,\
 10. "
#endif
);

SUIT_registerHelp ("all", FOREGROUND_COLOR, 
#ifdef MACINTOSH
"The default foreground color. Widgets paint their graphics in the foreground color. For example, the color of the text o"
"n a button is drawn in FOREGROUND_COLOR, but the button itself is considered the BACKGROUND_COLOR. Also see: BACKGROUND_"
"COLOR and BORDER_COLOR. "
#else
"The default foreground color. Widgets paint their graphics in the foreground color. For example, the color of the text o\
n a button is drawn in FOREGROUND_COLOR, but the button itself is considered the BACKGROUND_COLOR. Also see: BACKGROUND_\
COLOR and BORDER_COLOR. "
#endif
);

SUIT_registerHelp ("all", HAS_BACKGROUND, 
#ifdef MACINTOSH
"When TRUE, SUIT will fill a widget's viewport by drawing a rectangle in the background color before calling that widget'"
"s paint procedure. When FALSE, SUIT will not do this. Most widgets leave this TRUE, except for those which are animated,"
" or are performing optimized painting. Also see: BACKGROUND_COLOR and ANIMATED. "
#else
"When TRUE, SUIT will fill a widget's viewport by drawing a rectangle in the background color before calling that widget'\
s paint procedure. When FALSE, SUIT will not do this. Most widgets leave this TRUE, except for those which are animated,\
 or are performing optimized painting. Also see: BACKGROUND_COLOR and ANIMATED. "
#endif
);

SUIT_registerHelp ("all", HAS_BORDER, 
#ifdef MACINTOSH
"When TRUE, the object is drawn with a border. Also see: BORDER_RAISED, BORDER_WIDTH, BORDER_TYPE, and DRAW_BORDER_ON_INS"
"IDE. "
#else
"When TRUE, the object is drawn with a border. Also see: BORDER_RAISED, BORDER_WIDTH, BORDER_TYPE, and DRAW_BORDER_ON_INS\
IDE. "
#endif
);

SUIT_registerHelp ("all", MARGIN, 
#ifdef MACINTOSH
"Denotes the number of pixels between the text and the widget border for those widgets that have text in them. This prope"
"rty applies to the top, bottom, left and right margins. "
#else
"Denotes the number of pixels between the text and the widget border for those widgets that have text in them. This prope\
rty applies to the top, bottom, left and right margins. "
#endif
);

SUIT_registerHelp ("all", SCREEN_HEIGHT, 
#ifdef MACINTOSH
"Vertical resolution of the screen in pixels. When SUIT is running on a computer screen using a window manager, this refe"
"rs to the height of the window. "
#else
"Vertical resolution of the screen in pixels. When SUIT is running on a computer screen using a window manager, this refe\
rs to the height of the window. "
#endif
);

SUIT_registerHelp ("all", SCREEN_WIDTH, 
#ifdef MACINTOSH
"Horizontal resolution of the monitor in pixels. When SUIT is running on a computer screen using a window manager, this r"
"efers to the width of the window. "
#else
"Horizontal resolution of the monitor in pixels. When SUIT is running on a computer screen using a window manager, this r\
efers to the width of the window. "
#endif
);

SUIT_registerHelp ("all", SHOW_TEMPORARY_PROPERTIES, 
#ifdef MACINTOSH
"Each SUIT property is either temporary or permanent. Temporary properties are not saved to the .sui file when the progra"
"m exits, therefore any changes made to a temporary property will not be in effect the next time the program is invoked. "
"The SUIT property editor normally displays only permanent properties, because most temporary properties are used for int"
"ernal bookkeeping purposes and aren't very interesting. When SHOW_TEMPORARY_PROPERTIES is TRUE, the SUIT property editor"
" shows all properties, and indicates which are temporary by using a different color to display them, or by showing (temp"
"orary) after their name on a monochrome display. "
#else
"Each SUIT property is either temporary or permanent. Temporary properties are not saved to the .sui file when the progra\
m exits, therefore any changes made to a temporary property will not be in effect the next time the program is invoked. \
The SUIT property editor normally displays only permanent properties, because most temporary properties are used for int\
ernal bookkeeping purposes and aren't very interesting. When SHOW_TEMPORARY_PROPERTIES is TRUE, the SUIT property editor\
 shows all properties, and indicates which are temporary by using a different color to display them, or by showing (temp\
orary) after their name on a monochrome display. "
#endif
);

SUIT_registerHelp ("all", SHRINK_TO_FIT, 
#ifdef MACINTOSH
"When TRUE, labels and buttons will resize themselves to be the size of the LABEL plus whatever MARGIN is set. Attempting"
" to resize a widget that has SHRINK_TO_FIT set to TRUE will have no effect. "
#else
"When TRUE, labels and buttons will resize themselves to be the size of the LABEL plus whatever MARGIN is set. Attempting\
 to resize a widget that has SHRINK_TO_FIT set to TRUE will have no effect. "
#endif
);

SUIT_registerHelp ("all", SPRINGINESS, 
#ifdef MACINTOSH
"If a SUIT application is running inside a window in a window managed environment, and the user resizes the entire window"
", should each button get proportionally larger? The SPRINGINESS property allows widgets to specify what they do if their"
" parent (for most widgets, this just means the window or screen) changes in size. Conceptually, imagine that each widget"
" is connected to the four walls of its parent by either springs or stiff rods - as the parent's walls move, the widget w"
"ill stay the same distance from a wall if it is connected by a stiff rod. In the same fashion, widgets describe whether "
"they get bigger by having either a stiff rod or a spring in each of the two possible directions, horizontal and vertical"
". When you click on a springiness property, you interact with pictures of the springs and rods. Of course, in each of th"
"e directions (horizontal, vertical), there must be some springiness - if a widget was connected to its parents by a stif"
"f rod on both its left and right sides, and had a stiff horizontal rod inside, it would be overconstrained if its parent"
" got wider or narrower - that's why you must always have at least one spring in each direction (vertical and horizontal)"
". For more information, see the discussions of springiness in the heirarchy section of the reference manual. "
#else
"If a SUIT application is running inside a window in a window managed environment, and the user resizes the entire window\
, should each button get proportionally larger? The SPRINGINESS property allows widgets to specify what they do if their\
 parent (for most widgets, this just means the window or screen) changes in size. Conceptually, imagine that each widget\
 is connected to the four walls of its parent by either springs or stiff rods - as the parent's walls move, the widget w\
ill stay the same distance from a wall if it is connected by a stiff rod. In the same fashion, widgets describe whether \
they get bigger by having either a stiff rod or a spring in each of the two possible directions, horizontal and vertical\
. When you click on a springiness property, you interact with pictures of the springs and rods. Of course, in each of th\
e directions (horizontal, vertical), there must be some springiness - if a widget was connected to its parents by a stif\
f rod on both its left and right sides, and had a stiff horizontal rod inside, it would be overconstrained if its parent\
 got wider or narrower - that's why you must always have at least one spring in each direction (vertical and horizontal)\
. For more information, see the discussions of springiness in the heirarchy section of the reference manual. "
#endif
);

SUIT_registerHelp ("all", SUIT_SYSTEM_FONT, 
#ifdef MACINTOSH
"This is the font used by SUIT for the property editor and the SUIT menu. "

#else
"This is the font used by SUIT for the property editor and the SUIT menu. \
"
#endif
);

SUIT_registerHelp ("all", VISIBLE, 
#ifdef MACINTOSH
"Denotes whether the widget is visible in the application. Widgets that have their VISIBLE property set to FALSE are not "
"painted on the screen, and do not respond to mouse events. If you set VISIBLE to FALSE accidently and then exit the prop"
"erty editor, the only way to set the property back to TRUE is through program control or by hand editing the .sui file. "
"Also see: VISIBLE_WITHIN_PROPERTY_EDITOR. "
#else
"Denotes whether the widget is visible in the application. Widgets that have their VISIBLE property set to FALSE are not \
painted on the screen, and do not respond to mouse events. If you set VISIBLE to FALSE accidently and then exit the prop\
erty editor, the only way to set the property back to TRUE is through program control or by hand editing the .sui file. \
Also see: VISIBLE_WITHIN_PROPERTY_EDITOR. "
#endif
);

SUIT_registerHelp ("all", VISIBLE_WITHIN_PROPERTY_EDITOR, 
#ifdef MACINTOSH
"Denotes whether the widget is visible while being edited in the property editor. All the widgets except for the one bein"
"g edited have their VISIBLE_WITHIN_PROPERTY_EDITOR set to FALSE. You should not need to worry about this property - it i"
"s used internally by SUIT. "
#else
"Denotes whether the widget is visible while being edited in the property editor. All the widgets except for the one bein\
g edited have their VISIBLE_WITHIN_PROPERTY_EDITOR set to FALSE. You should not need to worry about this property - it i\
s used internally by SUIT. "
#endif
);

SUIT_registerHelp ("all", WINDOW, 
#ifdef MACINTOSH
"It is often inconvenient for widgets to draw in screen (pixel) coordinates, so most widgets use another coordinate syste"
"m and they let the GP graphics package perform the calculations to figure out which pixels the graphics should end up on"
". The WINDOW property denotes the floating point coordinate system that a widget uses to display its graphics. It's an a"
"rbitrary rectangle used as a convenience in the painting routine. For example, a widget that implemented football fields"
" could draw in a coordinate system which was 100 yards by 40 yards. Most widgets just use from 0.0 to 1.0 in each direct"
"ion. For more information, see the section on Windows and Viewports in the SUIT Reference Manual. Also see: VIEWPORT. "
#else
"It is often inconvenient for widgets to draw in screen (pixel) coordinates, so most widgets use another coordinate syste\
m and they let the GP graphics package perform the calculations to figure out which pixels the graphics should end up on\
. The WINDOW property denotes the floating point coordinate system that a widget uses to display its graphics. It's an a\
rbitrary rectangle used as a convenience in the painting routine. For example, a widget that implemented football fields\
 could draw in a coordinate system which was 100 yards by 40 yards. Most widgets just use from 0.0 to 1.0 in each direct\
ion. For more information, see the section on Windows and Viewports in the SUIT Reference Manual. Also see: VIEWPORT. "
#endif
);

SUIT_registerHelp ("all", ACTIVE_DISPLAY, 
#ifdef MACINTOSH
"Each screen object implements an abstract idea, such as a clock. However, most abstract ideas can be displayed on the sc"
"reen in many different ways. These are called display styles, or just displays. A clock, for example, has two different "
"displays: digital and analog. The ACTIVE_DISPLAY property tells SUIT which display style to use. By convention, if a wid"
"get only has one display style, that style is called standard. You can change the display style for a widget without usi"
"ng the property editor: just type SUIT-C with the mouse over that widget to cycle to the next display. "
#else
"Each screen object implements an abstract idea, such as a clock. However, most abstract ideas can be displayed on the sc\
reen in many different ways. These are called display styles, or just displays. A clock, for example, has two different \
displays: digital and analog. The ACTIVE_DISPLAY property tells SUIT which display style to use. By convention, if a wid\
get only has one display style, that style is called standard. You can change the display style for a widget without usi\
ng the property editor: just type SUIT-C with the mouse over that widget to cycle to the next display. "
#endif
);

SUIT_registerHelp ("all", CALLBACK_FUNCTION, 
#ifdef MACINTOSH
"The function to be called when the SUIT object is hit. This is a property that gets bound at runtime, but has no ASCII t"
"ext representation. You should not attempt to change this temporary property interactively. "
#else
"The function to be called when the SUIT object is hit. This is a property that gets bound at runtime, but has no ASCII t\
ext representation. You should not attempt to change this temporary property interactively. "
#endif
);

SUIT_registerHelp ("all", NUMBER_OF_CHILDREN, 
#ifdef MACINTOSH
"This property applies to bulletin board and pulldown menu widgets, and indicates how many different widgets are containe"
"d in the bulletin board or menu. All children of a widget must stay inside that widget on the screen. Widgets with child"
"ren are sometimes called hierarchical widgets; they and all their children can be manipulated as a unit. hierarchical wi"
"dgets can even have other hierarchical widgets as their children. This property should never be directly set by the user"
". "
#else
"This property applies to bulletin board and pulldown menu widgets, and indicates how many different widgets are containe\
d in the bulletin board or menu. All children of a widget must stay inside that widget on the screen. Widgets with child\
ren are sometimes called hierarchical widgets; they and all their children can be manipulated as a unit. hierarchical wi\
dgets can even have other hierarchical widgets as their children. This property should never be directly set by the user\
. "
#endif
);

SUIT_registerHelp ("all", VIEWPORT, 
#ifdef MACINTOSH
"The physical location of the SUIT object on the screen. Changing this property is usually done interactively with SUIT-d"
"rag, but it is also possible to change a viewport by typing the four integers into the property editor directly. The fou"
"r numbers correspond to lower-left x coordinate, lower-left y coordinate, upper-right x coordinate, upper-right y coordi"
"nate, also known as x1, y1, x2, y2. For more information, see the section on Windows and Viewports in the SUIT Reference"
" Manual. Also see: WINDOW. "
#else
"The physical location of the SUIT object on the screen. Changing this property is usually done interactively with SUIT-d\
rag, but it is also possible to change a viewport by typing the four integers into the property editor directly. The fou\
r numbers correspond to lower-left x coordinate, lower-left y coordinate, upper-right x coordinate, upper-right y coordi\
nate, also known as x1, y1, x2, y2. For more information, see the section on Windows and Viewports in the SUIT Reference\
 Manual. Also see: WINDOW. "
#endif
);

SUIT_registerHelp ( "arrow button", DIRECTION, 
#ifdef MACINTOSH
"Sets direction of the arrow: up, down, left, or right. "

#else
"Sets direction of the arrow: up, down, left, or right. \
"
#endif
);

SUIT_registerHelp ( "arrow button", INTERMEDIATE_FEEDBACK, 
#ifdef MACINTOSH
"Determines whether the widget is currently displaying intermediate feedback -- a visual cue to let you know that the but"
"ton is depressed but has not been released yet. Most users need not pay attention to this property. "
#else
"Determines whether the widget is currently displaying intermediate feedback -- a visual cue to let you know that the but\
ton is depressed but has not been released yet. Most users need not pay attention to this property. "
#endif
);

SUIT_registerHelp ( "arrow button", SHADOW_THICKNESS, 
#ifdef MACINTOSH
"Sets the depth, in pixels, of the shadow for the motif arrow. Most users need not pay attention to this property. "
#else
"Sets the depth, in pixels, of the shadow for the motif arrow. Most users need not pay attention to this property. "
#endif
);

SUIT_registerHelp ( "bouncing ball", BALL_SIZE, 
#ifdef MACINTOSH
"The diameter of the ball expressed in world coordinates. "

#else
"The diameter of the ball expressed in world coordinates. \
"
#endif
);

SUIT_registerHelp ( "bouncing ball", BALL_X, 
#ifdef MACINTOSH
"The X position of the ball, in world coordinates. "

#else
"The X position of the ball, in world coordinates. \
"
#endif
);

SUIT_registerHelp ( "bouncing ball", BALL_Y, 
#ifdef MACINTOSH
"The X position of the ball, in world coordinates. "

#else
"The X position of the ball, in world coordinates. \
"
#endif
);

SUIT_registerHelp ( "bouncing ball", FILLED, 
#ifdef MACINTOSH
"When TRUE, the ball is filled in with the FOREGROUND_COLOR. "

#else
"When TRUE, the ball is filled in with the FOREGROUND_COLOR. \
"
#endif
);

SUIT_registerHelp ( "bouncing ball", PIXELS_PER_SECOND, 
#ifdef MACINTOSH
"The number of pixels per second (the speed) that the ball moves "

#else
"The number of pixels per second (the speed) that the ball moves \
"
#endif
);

SUIT_registerHelp ( "bounded value", ARROWHEAD_ANGLE, 
#ifdef MACINTOSH
"The angle in degrees that the arrow head makes with the needle in the speedometer display style. A typical arrow would r"
"ange from 10 to 50 degrees. 0 degrees would give no arrow at all. "
#else
"The angle in degrees that the arrow head makes with the needle in the speedometer display style. A typical arrow would r\
ange from 10 to 50 degrees. 0 degrees would give no arrow at all. "
#endif
);

SUIT_registerHelp ( "bounded value", ARROWHEAD_LENGTH, 
#ifdef MACINTOSH
"Length of the arrowhead, expressed in world coordinates. Applies only to the speedometer display style. A typical arrowh"
"ead would range from 0.1 to 0.5 in length. "
#else
"Length of the arrowhead, expressed in world coordinates. Applies only to the speedometer display style. A typical arrowh\
ead would range from 0.1 to 0.5 in length. "
#endif
);

SUIT_registerHelp ( "bounded value", BUTTON_BACKGROUND_COLOR, 
#ifdef MACINTOSH
"Color of the bar on the bottom of the speedometer where the left/right arrows are shown.This only applies to the speedom"
"eter display style. "
#else
"Color of the bar on the bottom of the speedometer where the left/right arrows are shown.This only applies to the speedom\
eter display style. "
#endif
);

SUIT_registerHelp ( "bounded value", BUTTON_FOREGROUND_COLOR, 
#ifdef MACINTOSH
"Color of the left/right arrows shown below the speedometer. This only applies to the speedometer display style. "
#else
"Color of the left/right arrows shown below the speedometer. This only applies to the speedometer display style. "
#endif
);

SUIT_registerHelp ( "bounded value", CURRENT_VALUE, 
#ifdef MACINTOSH
"As shown by the widget, this is a floating point number between the minimum and maximum values. "

#else
"As shown by the widget, this is a floating point number between the minimum and maximum values. \
"
#endif
);

SUIT_registerHelp ( "bounded value", GRANULARITY, 
#ifdef MACINTOSH
"In the speedometer and scroll bar displays, this is the amount that the buttons will increment or decrement the current "
"value of the bounded value. In all displays, the current value must be a multiple of the granularity - for example, sett"
"ing a GRANULARITY of 1.0 effectively makes the bounded value an integer-only widget. "
#else
"In the speedometer and scroll bar displays, this is the amount that the buttons will increment or decrement the current \
value of the bounded value. In all displays, the current value must be a multiple of the granularity - for example, sett\
ing a GRANULARITY of 1.0 effectively makes the bounded value an integer-only widget. "
#endif
);

SUIT_registerHelp ( "bounded value", HAS_ARROW, 
#ifdef MACINTOSH
"If TRUE, the speedometer needle ends in an arrow. Ignored in all other display styles. "

#else
"If TRUE, the speedometer needle ends in an arrow. Ignored in all other display styles. \
"
#endif
);

SUIT_registerHelp ( "bounded value", HAS_TICK_MARKS, 
#ifdef MACINTOSH
"If TRUE and if GRANULARITY is not zero, tick marks will be drawn on the sides of the thermometer display styles for the "
"bounded value: one mark for each GRANULARITY step. "
#else
"If TRUE and if GRANULARITY is not zero, tick marks will be drawn on the sides of the thermometer display styles for the \
bounded value: one mark for each GRANULARITY step. "
#endif
);

SUIT_registerHelp ( "bounded value", INCREASE_CLOCKWISE, 
#ifdef MACINTOSH
"If TRUE, the pie slice display style increases in a clockwise fashion. "

#else
"If TRUE, the pie slice display style increases in a clockwise fashion. \
"
#endif
);

SUIT_registerHelp ( "bounded value", MAXIMUM_VALUE, 
#ifdef MACINTOSH
"The highest possible value. "

#else
"The highest possible value. \
"
#endif
);

SUIT_registerHelp ( "bounded value", MINIMUM_VALUE, 
#ifdef MACINTOSH
"The lowest possible value. "

#else
"The lowest possible value. \
"
#endif
);

SUIT_registerHelp ( "bounded value", NEEDLE_COLOR, 
#ifdef MACINTOSH
"Color of speedometer needle and its arrowhead. "

#else
"Color of speedometer needle and its arrowhead. \
"
#endif
);

SUIT_registerHelp ( "button", DISABLED, 
#ifdef MACINTOSH
"If TRUE, the text for the button is drawn in the DISABLED COLOR (rather than FOREGROUND COLOR) and the callback is not c"
"alled when the button is pressed. This is useful for times in an application when certain functions are not valid - for "
"example, a drawing editor might disable the delete current object button whenever there was no currently selected object"
". "
#else
"If TRUE, the text for the button is drawn in the DISABLED COLOR (rather than FOREGROUND COLOR) and the callback is not c\
alled when the button is pressed. This is useful for times in an application when certain functions are not valid - for \
example, a drawing editor might disable the delete current object button whenever there was no currently selected object\
. "
#endif
);

SUIT_registerHelp ( "button", DISABLED_COLOR, 
#ifdef MACINTOSH
"Sets the color of the button if the button is deemed to be an inactive choice in the application. See the DISABLED prope"
"rty at the object level. "
#else
"Sets the color of the button if the button is deemed to be an inactive choice in the application. See the DISABLED prope\
rty at the object level. "
#endif
);

SUIT_registerHelp ( "button", HOTKEY, 
#ifdef MACINTOSH
"The keyboard combination that can also be used to activate the button. Note that this is only a piece of text that appea"
"rs alongside the LABEL. In order to actually attach the hotkey to the button requires registering an input trapper funct"
"ion. "
#else
"The keyboard combination that can also be used to activate the button. Note that this is only a piece of text that appea\
rs alongside the LABEL. In order to actually attach the hotkey to the button requires registering an input trapper funct\
ion. "
#endif
);

SUIT_registerHelp ( "button", LABEL, 
#ifdef MACINTOSH
"The name that appears on the front of the button. "

#else
"The name that appears on the front of the button. \
"
#endif
);

SUIT_registerHelp ( "clock", HAS_RIM, 
#ifdef MACINTOSH
"Denotes whether or not the analog clock has a circular rim around it. Has no effect on the digital display style of the "
"clock. "
#else
"Denotes whether or not the analog clock has a circular rim around it. Has no effect on the digital display style of the \
clock. "
#endif
);

SUIT_registerHelp ( "clock", HAS_SECOND_HAND, 
#ifdef MACINTOSH
"Denotes whether or not the analog display of the clock displays a second hand. This property can be toggled with the mou"
"se. In the digital display style, if HAS_SECOND_HAND is TRUE, then the seconds are updated every second, otherwise they "
"remain at zero. "
#else
"Denotes whether or not the analog display of the clock displays a second hand. This property can be toggled with the mou\
se. In the digital display style, if HAS_SECOND_HAND is TRUE, then the seconds are updated every second, otherwise they \
remain at zero. "
#endif
);

SUIT_registerHelp ( "clock", MILITARY_TIME, 
#ifdef MACINTOSH
"When TRUE, the digital display shows the time using a 24 hour clock. Unused in the analog display. "

#else
"When TRUE, the digital display shows the time using a 24 hour clock. Unused in the analog display. \
"
#endif
);

SUIT_registerHelp ( "color chips", CHIP_BORDER, 
#ifdef MACINTOSH
"The current color is shown by drawing a highlighted border around its chip. The CHIP BORDER property controls the width "
"of that border, expressed as a fraction of the width of the entire set of color chips. Typical range for this property i"
"s (0.05-0.1). "
#else
"The current color is shown by drawing a highlighted border around its chip. The CHIP BORDER property controls the width \
of that border, expressed as a fraction of the width of the entire set of color chips. Typical range for this property i\
s (0.05-0.1). "
#endif
);

SUIT_registerHelp ( "color chips", CURRENT_VALUE, 
#ifdef MACINTOSH
"The color currently selected. "

#else
"The color currently selected. \
"
#endif
);

SUIT_registerHelp ( "color chips", HIGHLIGHT_COLOR, 
#ifdef MACINTOSH
"The color of the border used to highlight of the CURRENT_VALUE color. "

#else
"The color of the border used to highlight of the CURRENT_VALUE color. \
"
#endif
);

SUIT_registerHelp ( "color chips", PREVIOUS_VALUE, 
#ifdef MACINTOSH
"The color previously selected. "

#else
"The color previously selected. \
"
#endif
);

SUIT_registerHelp ( "file browser", CURRENT_DIRECTORY, 
#ifdef MACINTOSH
"The name of the directory (without the final filename appended) that the browser is looking at "

#else
"The name of the directory (without the final filename appended) that the browser is looking at \
"
#endif
);

SUIT_registerHelp ( "file browser", CURRENT_FILE, 
#ifdef MACINTOSH
"The name of the file (without the pathname prepended) that the browser is looking at. "

#else
"The name of the file (without the pathname prepended) that the browser is looking at. \
"
#endif
);

SUIT_registerHelp ( "file browser", CURRENT_VALUE, 
#ifdef MACINTOSH
"The name of the file or directory that appears in the type-in box. This is the combination of CURRENT_DIRECTORY and CURR"
"ENT_FILE property values. "
#else
"The name of the file or directory that appears in the type-in box. This is the combination of CURRENT_DIRECTORY and CURR\
ENT_FILE property values. "
#endif
);

SUIT_registerHelp ( "file browser", FILE_FILTER, 
#ifdef MACINTOSH
"A wildcard specification (e.g. *.c or *.sui) that limits the kins of files that the browser will list. Example: if FILE_"
"FILTER is set to *.c, the browser will only list files that end in .c. "
#else
"A wildcard specification (e.g. *.c or *.sui) that limits the kins of files that the browser will list. Example: if FILE_\
FILTER is set to *.c, the browser will only list files that end in .c. "
#endif
);

SUIT_registerHelp ( "font panel", CURRENT_VALUE, 
#ifdef MACINTOSH
"This is the font that is currently selected on the font panel. "

#else
"This is the font that is currently selected on the font panel. \
"
#endif
);

SUIT_registerHelp ( "label", HAS_BORDER, 
#ifdef MACINTOSH
"By default set to FALSE, meaning that it would have no border. "

#else
"By default set to FALSE, meaning that it would have no border. \
"
#endif
);

SUIT_registerHelp ( "label", LABEL, 
#ifdef MACINTOSH
"The string that appears on the face of the label. "

#else
"The string that appears on the face of the label. \
"
#endif
);

SUIT_registerHelp ( "label", CURRENT_VALUE, 
#ifdef MACINTOSH
"Set to yes if switch is on, no if the switch is off. "

#else
"Set to yes if switch is on, no if the switch is off. \
"
#endif
);

SUIT_registerHelp ( "label", DISABLED, 
#ifdef MACINTOSH
"If TRUE, the text for the button is drawn in the DISABLED COLOR (rather than FOREGROUND COLOR) and the callback is not c"
"alled when the button is pressed. This is useful for times in an application when certain functions are not valid - for "
"example, a drawing editor might disable the delete current object button whenever there was no currently selected object"
". "
#else
"If TRUE, the text for the button is drawn in the DISABLED COLOR (rather than FOREGROUND COLOR) and the callback is not c\
alled when the button is pressed. This is useful for times in an application when certain functions are not valid - for \
example, a drawing editor might disable the delete current object button whenever there was no currently selected object\
. "
#endif
);

SUIT_registerHelp ( "label", DISABLED_COLOR, 
#ifdef MACINTOSH
"The color of the text when the button is disabled (see object level property DISABLED). "

#else
"The color of the text when the button is disabled (see object level property DISABLED). \
"
#endif
);

SUIT_registerHelp ( "label", LABEL, 
#ifdef MACINTOSH
"The text to display on the face of the button. "

#else
"The text to display on the face of the button. \
"
#endif
);

SUIT_registerHelp ( "pattern chips", CHIP_BORDER, 
#ifdef MACINTOSH
"The width of the border around each chip. "

#else
"The width of the border around each chip. \
"
#endif
);

SUIT_registerHelp ( "pattern chips", CURRENT_VALUE, 
#ifdef MACINTOSH
"Pattern currently selected. "

#else
"Pattern currently selected. \
"
#endif
);

SUIT_registerHelp ( "pattern chips", HIGHLIGHT_COLOR, 
#ifdef MACINTOSH
"The color of the highlight around the selected pattern chip. "

#else
"The color of the highlight around the selected pattern chip. \
"
#endif
);

SUIT_registerHelp ( "pattern chips", PREVIOUS_VALUE, 
#ifdef MACINTOSH
"Pattern previously selected. "

#else
"Pattern previously selected. \
"
#endif
);

SUIT_registerHelp ( "polygon", FILLED, 
#ifdef MACINTOSH
"When TRUE, the polygon will be filled solid in the FOREGROUND_COLOR. When FALSE, only the outline is drawn. "
#else
"When TRUE, the polygon will be filled solid in the FOREGROUND_COLOR. When FALSE, only the outline is drawn. "
#endif
);

SUIT_registerHelp ( "polygon", NUMBER_OF_SIDES, 
#ifdef MACINTOSH
"The number of sides for the polygon. Setting this property to be a number less than 3 will draw a triangle. "
#else
"The number of sides for the polygon. Setting this property to be a number less than 3 will draw a triangle. "
#endif
);

SUIT_registerHelp ( "pulldown menu", LABEL, 
#ifdef MACINTOSH
"This is the label that appers on the front of the pulldown menu button. "

#else
"This is the label that appers on the front of the pulldown menu button. \
"
#endif
);

SUIT_registerHelp ( "radio buttons", CURRENT_VALUE, 
#ifdef MACINTOSH
"This is the item that is currently selected. The string representation of the current SUIT enumeration is taken to be th"
"e label for each of the radio buttons. "
#else
"This is the item that is currently selected. The string representation of the current SUIT enumeration is taken to be th\
e label for each of the radio buttons. "
#endif
);

SUIT_registerHelp ( "scrollable list", CURRENT_VALUE, 
#ifdef MACINTOSH
"The currently selected string. Initially, this is the empty string. "

#else
"The currently selected string. Initially, this is the empty string. \
"
#endif
);

SUIT_registerHelp ( "scrollable list", CURRENT_ROW, 
#ifdef MACINTOSH
"The integer number of the currently selected string. The first string is string 0. If nothing is highlighted, the CURREN"
"T_ROW is -1. "
#else
"The integer number of the currently selected string. The first string is string 0. If nothing is highlighted, the CURREN\
T_ROW is -1. "
#endif
);

SUIT_registerHelp ( "scrollable list", HAS_BACKGROUND, 
#ifdef MACINTOSH
"When FALSE, the background can be seen between the text list and the scrollbar. "

#else
"When FALSE, the background can be seen between the text list and the scrollbar. \
"
#endif
);

SUIT_registerHelp ( "scrollable list", HAS_BORDER, 
#ifdef MACINTOSH
"When FALSE, the scrollbar appears to be separate from the text list. "

#else
"When FALSE, the scrollbar appears to be separate from the text list. \
"
#endif
);

SUIT_registerHelp ( "scrollable list", LABEL, 
#ifdef MACINTOSH
"If not the empty string , the scrollable list will display this LABEL string at the top of the list. For example, you co"
"uld set this property to be the string colors for the list of items: red, green, and blue. "
#else
"If not the empty string , the scrollable list will display this LABEL string at the top of the list. For example, you co\
uld set this property to be the string colors for the list of items: red, green, and blue. "
#endif
);

SUIT_registerHelp ( "scrollable list", LIST, 
#ifdef MACINTOSH
"This is the entire list of items in the scrollable list. "

#else
"This is the entire list of items in the scrollable list. \
"
#endif
);

SUIT_registerHelp ( "text box", LABEL, 
#ifdef MACINTOSH
"The text that appears on the face of the Text Box. This string is allowed to contain imbedded newlines. "
#else
"The text that appears on the face of the Text Box. This string is allowed to contain imbedded newlines. "
#endif
);

SUIT_registerHelp ( "text box", LINE_SPACING, 
#ifdef MACINTOSH
"This number determines the space between lines of text, measured in text heights. 2.0 is double spaced. "
#else
"This number determines the space between lines of text, measured in text heights. 2.0 is double spaced. "
#endif
);

SUIT_registerHelp ( "text box", NUMBER_OF_LINES, 
#ifdef MACINTOSH
"This number represents the number of lines of text currently being displayed. This number changes if text is added, or i"
"f the widget resizes and lines wrap differently. "
#else
"This number represents the number of lines of text currently being displayed. This number changes if text is added, or i\
f the widget resizes and lines wrap differently. "
#endif
);

SUIT_registerHelp ( "text box", STARTING_LINE, 
#ifdef MACINTOSH
"Usually, this number is zero, meaning that the text being displayed starts at the first line of the total amount of text"
" held by this text box (the LABEL property). By setting STARTING_LINE to some number greater than zero, the text can be "
"made to scroll off the top of the text box. "
#else
"Usually, this number is zero, meaning that the text being displayed starts at the first line of the total amount of text\
 held by this text box (the LABEL property). By setting STARTING_LINE to some number greater than zero, the text can be \
made to scroll off the top of the text box. "
#endif
);

SUIT_registerHelp ( "text editor", ALTERED, 
#ifdef MACINTOSH
"FALSE until the text is edited. "

#else
"FALSE until the text is edited. \
"
#endif
);

SUIT_registerHelp ( "text editor", ANY_KEYSTROKE_TRIGGERS, 
#ifdef MACINTOSH
"When TRUE, the callback is called at every keystroke. When FALSE, the callback is only invoked at the DONE_EDITING_KEY k"
"ey sequence "
#else
"When TRUE, the callback is called at every keystroke. When FALSE, the callback is only invoked at the DONE_EDITING_KEY k\
ey sequence "
#endif
);

SUIT_registerHelp ( "text editor", CURRENT_VALUE, 
#ifdef MACINTOSH
"The text currently being edited. This string is allowed to contain newlines, tabs, but cannot use the GP_text special ch"
"aracters; all characters in the text editor will be the same font. "
#else
"The text currently being edited. This string is allowed to contain newlines, tabs, but cannot use the GP_text special ch\
aracters; all characters in the text editor will be the same font. "
#endif
);

SUIT_registerHelp ( "text editor", CURSOR_COLOR, 
#ifdef MACINTOSH
"The color of the cursor, which defaults to black. "

#else
"The color of the cursor, which defaults to black. \
"
#endif
);

SUIT_registerHelp ( "text editor", CURSOR_INDEX, 
#ifdef MACINTOSH
"This temporary property denotes which character the cursor is in front of. For example, when CURSOR_INDEX is 0, this mea"
"ns that the cursor is in front of the first character. "
#else
"This temporary property denotes which character the cursor is in front of. For example, when CURSOR_INDEX is 0, this mea\
ns that the cursor is in front of the first character. "
#endif
);

SUIT_registerHelp ( "text editor", CURSOR_STYLE, 
#ifdef MACINTOSH
"This denotes the style of the cursor, either vertical bar or i-beam. "

#else
"This denotes the style of the cursor, either vertical bar or i-beam. \
"
#endif
);

SUIT_registerHelp ( "text editor", CUT_BUFFER, 
#ifdef MACINTOSH
"Contains the last text cut from the CURRENT_VALUE string. This buffer is set whenever the WIPE_BLOCK_KEY or KILL_LINE_KE"
"Y key sequence is used (CUT_BUFFER is set to be the killed text) or when the user highlights the text by dragging over t"
"he text editor with the mouse (CUT_BUFFER is set to be the text in the highlighted region). "
#else
"Contains the last text cut from the CURRENT_VALUE string. This buffer is set whenever the WIPE_BLOCK_KEY or KILL_LINE_KE\
Y key sequence is used (CUT_BUFFER is set to be the killed text) or when the user highlights the text by dragging over t\
he text editor with the mouse (CUT_BUFFER is set to be the text in the highlighted region). "
#endif
);

SUIT_registerHelp ( "text editor", HIGHLIGHT_BLOCK, 
#ifdef MACINTOSH
"When true, the text that appears between the MARK_INDEX and the MARK_END_INDEX appears in reverse video (light on dark)."
" "
#else
"When true, the text that appears between the MARK_INDEX and the MARK_END_INDEX appears in reverse video (light on dark).\
 "
#endif
);

SUIT_registerHelp ( "text editor", INPUT_SEQUENCE, 
#ifdef MACINTOSH
"This buffer stores the editor commands before the editor processes them. After the editor recognizes a command, this pro"
"perty is reinitialized to the null string. If you register an interest in this property, you can examine the keyboard co"
"mmand before the editor responds to it. See also the SUIT function called SUIT_sendToEditor(). "
#else
"This buffer stores the editor commands before the editor processes them. After the editor recognizes a command, this pro\
perty is reinitialized to the null string. If you register an interest in this property, you can examine the keyboard co\
mmand before the editor responds to it. See also the SUIT function called SUIT_sendToEditor(). "
#endif
);

SUIT_registerHelp ( "text editor", MARK_INDEX, 
#ifdef MACINTOSH
"This number denotes the beginning position of the highlighted region in the text. To change the position of the highligh"
"ted region, use the SUIT_highlightBlockInTextEditor() call. "
#else
"This number denotes the beginning position of the highlighted region in the text. To change the position of the highligh\
ted region, use the SUIT_highlightBlockInTextEditor() call. "
#endif
);

SUIT_registerHelp ( "text editor", MARK_END_INDEX, 
#ifdef MACINTOSH
"This number denotes the ending position of the highlighted region in the text. To change the position of the highlighted"
" region, use the SUIT_highlightBlockInTextEditor() call. "
#else
"This number denotes the ending position of the highlighted region in the text. To change the position of the highlighted\
 region, use the SUIT_highlightBlockInTextEditor() call. "
#endif
);

SUIT_registerHelp ( "text editor", NUMBER_OF_LINES, 
#ifdef MACINTOSH
"This represents the total number of text lines being edited. "

#else
"This represents the total number of text lines being edited. \
"
#endif
);

SUIT_registerHelp ( "text editor", READ_ONLY, 
#ifdef MACINTOSH
"When TRUE, commands that change the buffer are disabled and the widget becomes a text browser rather than an editor. "
#else
"When TRUE, commands that change the buffer are disabled and the widget becomes a text browser rather than an editor. "
#endif
);

SUIT_registerHelp ( "text editor", SPACING_GAP, 
#ifdef MACINTOSH
"Number of pixels between lines of text measured from the lowest descender to the highest ascenders of the next line. "
#else
"Number of pixels between lines of text measured from the lowest descender to the highest ascenders of the next line. "
#endif
);

SUIT_registerHelp ( "text editor", TAB_LENGTH, 
#ifdef MACINTOSH
"The length of a tab, measured in characters. For example, setting tab length to 5 will provide tabs every five spaces ac"
"ross the width of the editor. Note that tabs will only line up with a fixed width font such as courier.Tabs are preserve"
"d in the text as tabs, not converted to spaces. "
#else
"The length of a tab, measured in characters. For example, setting tab length to 5 will provide tabs every five spaces ac\
ross the width of the editor. Note that tabs will only line up with a fixed width font such as courier.Tabs are preserve\
d in the text as tabs, not converted to spaces. "
#endif
);

SUIT_registerHelp ( "text editor", BACKWARD_CHAR_KEY, 
#ifdef MACINTOSH
"Default value is C-b "

#else
"Default value is C-b \
"
#endif
);

SUIT_registerHelp ( "text editor", BEGINNING_OF_LINE_KEY, 
#ifdef MACINTOSH
"Default value is C-a "

#else
"Default value is C-a \
"
#endif
);

SUIT_registerHelp ( "text editor", BEGINNING_OF_TEXT_KEY, 
#ifdef MACINTOSH
"Default value is M-< "

#else
"Default value is M-< \
"
#endif
);

SUIT_registerHelp ( "text editor", DELETE_CHAR_KEY, 
#ifdef MACINTOSH
"Default value is C-d "

#else
"Default value is C-d \
"
#endif
);

SUIT_registerHelp ( "text editor", DELETE_ENTIRE_LINE_KEY, 
#ifdef MACINTOSH
"Default value is C-u "

#else
"Default value is C-u \
"
#endif
);

SUIT_registerHelp ( "text editor", DONE_EDITING_KEY, 
#ifdef MACINTOSH
"Default value is C-x. This command invokes the callback. "

#else
"Default value is C-x. This command invokes the callback. \
"
#endif
);

SUIT_registerHelp ( "text editor", END_OF_LINE_KEY, 
#ifdef MACINTOSH
"Default value is C-e "

#else
"Default value is C-e \
"
#endif
);

SUIT_registerHelp ( "text editor", END_OF_TEXT_KEY, 
#ifdef MACINTOSH
"Default value is M-> "

#else
"Default value is M-> \
"
#endif
);

SUIT_registerHelp ( "text editor", FORWARD_CHAR_KEY, 
#ifdef MACINTOSH
"Default value is C-f "

#else
"Default value is C-f \
"
#endif
);

SUIT_registerHelp ( "text editor", KILL_LINE_KEY, 
#ifdef MACINTOSH
"Default value is C-k "

#else
"Default value is C-k \
"
#endif
);

SUIT_registerHelp ( "text editor", NEXT_LINE_KEY, 
#ifdef MACINTOSH
"Default value is C-n "

#else
"Default value is C-n \
"
#endif
);

SUIT_registerHelp ( "text editor", OPEN_LINE_KEY, 
#ifdef MACINTOSH
"Default value is C-o. This opens a line at the current cursor position. "

#else
"Default value is C-o. This opens a line at the current cursor position. \
"
#endif
);

SUIT_registerHelp ( "text editor", PREVIOUS_LINE_KEY, 
#ifdef MACINTOSH
"Default value is C-p "

#else
"Default value is C-p \
"
#endif
);

SUIT_registerHelp ( "text editor", REPAINT_KEY, 
#ifdef MACINTOSH
"Default value is C-l (that's a lower case letter, not the number 1) "

#else
"Default value is C-l (that's a lower case letter, not the number 1) \
"
#endif
);

SUIT_registerHelp ( "text editor", SCROLL_DOWN_KEY, 
#ifdef MACINTOSH
"Default value is M-v "

#else
"Default value is M-v \
"
#endif
);

SUIT_registerHelp ( "text editor", SCROLL_UP_KEY, 
#ifdef MACINTOSH
"Default value is C-v "

#else
"Default value is C-v \
"
#endif
);

SUIT_registerHelp ( "text editor", SET_MARK_KEY, 
#ifdef MACINTOSH
"Default value is C-` which is equivalent to a C-<space> key sequence. "

#else
"Default value is C-` which is equivalent to a C-<space> key sequence. \
"
#endif
);

SUIT_registerHelp ( "text editor", WIPE_BLOCK_KEY, 
#ifdef MACINTOSH
"Default value is C-w "

#else
"Default value is C-w \
"
#endif
);

SUIT_registerHelp ( "text editor", YANK_KEY, 
#ifdef MACINTOSH
"Default value is C-y "

#else
"Default value is C-y \
"
#endif
);

SUIT_registerHelp ( "trash can", HELP_MESSAGE, 
#ifdef MACINTOSH
"This is the message that appears in a SUIT_inform() style dialog box when the user clicks on the trash can. "
#else
"This is the message that appears in a SUIT_inform() style dialog box when the user clicks on the trash can. "
#endif
);

SUIT_registerHelp ("type in box", ALTERED, 
#ifdef MACINTOSH
"FALSE until the text is edited. "

#else
"FALSE until the text is edited. \
"
#endif
);

SUIT_registerHelp ("type in box", ANY_KEYSTROKE_TRIGGERS, 
#ifdef MACINTOSH
"When TRUE, the callback is called at every keystroke. When FALSE, the callback is only invoked when the user presses RET"
"URN. "
#else
"When TRUE, the callback is called at every keystroke. When FALSE, the callback is only invoked when the user presses RET\
URN. "
#endif
);

SUIT_registerHelp ("type in box", CURRENT_VALUE, 
#ifdef MACINTOSH
"The text currently being edited. This string is allowed to contain newlines, tabs, but cannot use the GP_text special ch"
"aracters; all characters in the text editor will be the same font. "
#else
"The text currently being edited. This string is allowed to contain newlines, tabs, but cannot use the GP_text special ch\
aracters; all characters in the text editor will be the same font. "
#endif
);

SUIT_registerHelp ("type in box", CURSOR_COLOR, 
#ifdef MACINTOSH
"The color of the cursor, which defaults to black. "

#else
"The color of the cursor, which defaults to black. \
"
#endif
);

SUIT_registerHelp ("type in box", CURSOR_INDEX, 
#ifdef MACINTOSH
"This temporary property denotes which character the cursor is in front of. For example, when CURSOR_INDEX is 0, this mea"
"ns that the cursor is in front of the first character. "
#else
"This temporary property denotes which character the cursor is in front of. For example, when CURSOR_INDEX is 0, this mea\
ns that the cursor is in front of the first character. "
#endif
);

SUIT_registerHelp ("type in box", CURSOR_STYLE, 
#ifdef MACINTOSH
"This denotes the style of the cursor, either vertical bar or i-beam. "

#else
"This denotes the style of the cursor, either vertical bar or i-beam. \
"
#endif
);

SUIT_registerHelp ("type in box", CUT_BUFFER, 
#ifdef MACINTOSH
"Contains the last text cut from the CURRENT_VALUE string. This buffer is set whenever the WIPE_BLOCK_KEY or KILL_LINE_KE"
"Y key sequence is used (CUT_BUFFER is set to be the killed text) or when the user highlights the text by dragging over t"
"he text editor with the mouse (CUT_BUFFER is set to be the text in the highlighted region). "
#else
"Contains the last text cut from the CURRENT_VALUE string. This buffer is set whenever the WIPE_BLOCK_KEY or KILL_LINE_KE\
Y key sequence is used (CUT_BUFFER is set to be the killed text) or when the user highlights the text by dragging over t\
he text editor with the mouse (CUT_BUFFER is set to be the text in the highlighted region). "
#endif
);

SUIT_registerHelp ("type in box", HIGHLIGHT_BLOCK, 
#ifdef MACINTOSH
"When true, the text that appears between the MARK_INDEX and the MARK_END_INDEX appears in reverse video. "
#else
"When true, the text that appears between the MARK_INDEX and the MARK_END_INDEX appears in reverse video. "
#endif
);

SUIT_registerHelp ("type in box", INPUT_SEQUENCE, 
#ifdef MACINTOSH
"This buffer stores the editor commands before the editor processes them. After the editor recognizes a command, this pro"
"perty is reinitialized to he null string. If you register an interest in this property, you can examine the keyboard com"
"mand before the editor responds to it. See also the SUIT function called SUIT_sendToEditor(). "
#else
"This buffer stores the editor commands before the editor processes them. After the editor recognizes a command, this pro\
perty is reinitialized to he null string. If you register an interest in this property, you can examine the keyboard com\
mand before the editor responds to it. See also the SUIT function called SUIT_sendToEditor(). "
#endif
);

SUIT_registerHelp ("type in box", MARK_INDEX, 
#ifdef MACINTOSH
"This number denotes the beginning position of the highlighted region in the text. To change the position of the highligh"
"ted region, use the SUIT_highlightBlockInTextEditor() call. "
#else
"This number denotes the beginning position of the highlighted region in the text. To change the position of the highligh\
ted region, use the SUIT_highlightBlockInTextEditor() call. "
#endif
);

SUIT_registerHelp ("type in box", MARK_END_INDEX, 
#ifdef MACINTOSH
"This number denotes the ending position of the highlighted region in the text. To change the position of the highlighted"
" region, use the SUIT_highlightBlockInTextEditor() call. "
#else
"This number denotes the ending position of the highlighted region in the text. To change the position of the highlighted\
 region, use the SUIT_highlightBlockInTextEditor() call. "
#endif
);

SUIT_registerHelp ("type in box", NUMBER_OF_LINES, 
#ifdef MACINTOSH
"This represents the total number of text lines being edited. This number will always be at least 1. "
#else
"This represents the total number of text lines being edited. This number will always be at least 1. "
#endif
);

SUIT_registerHelp ("type in box", READ_ONLY, 
#ifdef MACINTOSH
"When TRUE, commands that change the buffer are disabled and the widget becomes a text browser rather than an editor. "
#else
"When TRUE, commands that change the buffer are disabled and the widget becomes a text browser rather than an editor. "
#endif
);

SUIT_registerHelp ("type in box", SPACING_GAP, 
#ifdef MACINTOSH
"Number of pixels between lines of text measured from the lowest descender to the highest ascenders of the next line. "
#else
"Number of pixels between lines of text measured from the lowest descender to the highest ascenders of the next line. "
#endif
);

SUIT_registerHelp ("type in box", TAB_LENGTH, 
#ifdef MACINTOSH
"The length of a tab, measured in characters. For example, setting tab length to 5 will provide tabs every five spaces ac"
"ross the width of the editor. Note that tabs will only line up with a fixed width font such as courier.Tabs are preserve"
"d in the text as tabs, not converted to spaces. "
#else
"The length of a tab, measured in characters. For example, setting tab length to 5 will provide tabs every five spaces ac\
ross the width of the editor. Note that tabs will only line up with a fixed width font such as courier.Tabs are preserve\
d in the text as tabs, not converted to spaces. "
#endif
);

SUIT_registerHelp ( "uva logo", LINE_WIDTH, 
#ifdef MACINTOSH
"Sets the line thickness for the rotunda display style. "

#else
"Sets the line thickness for the rotunda display style. \
"
#endif
);

    
#endif
}
