#include <stdio.h>
#include <math.h>
#include <suntool/sunview.h>
#include <suntool/canvas.h>
#include "vort.h"

extern	char	*rindex();


/*
 * program to read in a 24 bit VORT file and display it on a 24 bit
 * RasterOps card.
 */
main(ac, av)
	int	ac;
	char	**av;
{
	Frame			frame;
	Canvas			canvas;
	char			*myname, name[BUFSIZ];
	register int		x;
	unsigned short		h, w, wreal, w2;
	int			line_bytes;
	u_char			*red, *green, *blue;
	u_char			*p, *pp;
	register Pixwin		*pw;
	register Pixrect	*pr;
	image			*im;
	int			upsidedown;

        if ((myname = rindex(av[0],'/')) == NULL)
                myname = av[0];
        else
                *myname++;
        /*
         * Check that we are in sunview....
         */
        if (getenv("WINDOW_ME") == NULL) {
                fprintf(stderr, "%s can only be run under sunview (suntools)\n", myname);
                fprintf(stderr, "on the same machine that is running sunview.\n");
                exit(1);
        }

	if (ac < 2 || ac > 4) {
		fprintf(stderr, "%s: usage %s [-u] file.\n", myname, myname);
		exit(1);
	}

	upsidedown = 0;
	for (x = 1; x < ac && *av[x] == '-'; x++) {
		if (strncmp(av[x], "-u", 2) == 0) { /* show image upside down */
			upsidedown = 1;
		}
	} 

	if ((im = openimage(av[x], "r")) == (image *)NULL) {
		fprintf(stderr, "%s: can't open file %s.\n", myname, av[x]);
		exit(1);
	}

	strcpy(name, myname);
	strcat(name, ": ");

        if ((myname = rindex(av[x],'/')) == NULL)
                myname = av[x];
        else
                *myname++;

	if (titlelength(im) == 0)
		strcat(name, myname);
	else
		strcat(name, imagetitle(im));

	w = imagewidth(im);
	h = imageheight(im);

	if (imagedepth(im) < 24)
		imagedepth(im) = 24;

        w2 = w;
	if ((x = w % 4) != 0)
                w2 = (w / 4 + x) * 4;

	/*
	 * Need a 32 bit deep pixrect for this stuff...
	 */
	if ((pr = mem_create(w2, h, (8 + imagedepth(im)))) == (Pixrect *)NULL) {
		fprintf(stderr, "Couldn't allocate Pixrect\n");
		exit(1);
	}

	line_bytes = mpr_linebytes(w2, 8 + imagedepth(im));
	p = (unsigned char *)mpr_d(pr)->md_image; /* Start of Pixrect */

	if (upsidedown)
		p += line_bytes * (h - 1);	/* Last line in Pixrect */

	frame = window_create(0, FRAME,
			WIN_HEIGHT, h,
			WIN_WIDTH, w,
			FRAME_LABEL, name,
		0);

	canvas = window_create(frame, CANVAS,
			WIN_HEIGHT, h,
			WIN_WIDTH, w,
			CANVAS_COLOR24, TRUE,
		0);

	window_fit(frame);

	pw = (Pixwin *)canvas_pixwin(canvas);

	if ((red = (u_char *)malloc(w2)) == NULL) {
		fprintf(stderr, "No mem!\n");
		exit(1);
	}
	if ((green = (u_char *)malloc(w2)) == NULL) {
		fprintf(stderr, "No mem!\n");
		exit(1);
	}
	if ((blue = (u_char *)malloc(w2)) == NULL) {
		fprintf(stderr, "No mem!\n");
		exit(1);
	}

	while (readrgbline(im, red, green, blue)) {
		pp = p;
		for (x = 0; x < w; x++) {
			*pp++ = 0;
			*pp++ = blue[x];
			*pp++ = green[x];
			*pp++ = red[x];
		}

		if (upsidedown)
			p -= line_bytes;
		else
			p += line_bytes;

	}

	pw_batch_on(pw);
	pw_rop(pw, 0, 0, w, h, PIX_SRC, pr, 0, 0);
	pw_batch_off(pw);

	window_main_loop(frame);

	exit(0);
}
