/* conf.h
   Configuration file for local system.

   Copyright (C) 1991 Ian Lance Taylor

   This file is part of the Taylor UUCP package.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   The author of the program may be contacted at ian@airs.com or
   c/o AIRS, P.O. Box 520, Waltham, MA 02254.

   $Log: conf.h,v $
   Revision 1.16  1992/01/19  21:30:21  ian
   Matthew Lyle: some systems don't declare errno in <errno.h>

   Revision 1.15  1992/01/19  18:29:05  ian
   Added HAVE_BSEARCH configuration parameter

   Revision 1.14  1992/01/15  20:40:04  ian
   Mike Park: some systems don't have <limits.h>

   Revision 1.13  1992/01/15  19:53:27  ian
   Mike Park: If HAVE_ALLOCA is 0 when using gcc, don't define alloca

   Revision 1.12  1992/01/15  07:06:29  ian
   Set configuration directory in Makefile rather than sysdep.h

   Revision 1.11  1991/12/28  06:10:50  ian
   Added HAVE_STRCHR and HAVE_INDEX to conf.h

   Revision 1.10  1991/12/28  03:49:23  ian
   Added HAVE_MEMFNS and HAVE_BFNS; changed uses of memset to bzero

   Revision 1.9  1991/12/22  22:14:19  ian
   Monty Solomon: added HAVE_UNISTD_H configuration parameter

   Revision 1.8  1991/12/11  19:35:48  ian
   Mark Powell: put in my own version of strtol

   Revision 1.7  1991/12/11  04:21:37  ian
   Arne Ludwig: merge in Arne Ludwig's patches for V2 and BNU style logging

   Revision 1.6  1991/11/21  21:49:38  ian
   Brian Campbell: define all macros to avoid compiler warnings

   Revision 1.5  1991/11/21  21:20:41  ian
   Brian Campbell: offer str{n}icmp as an alternative to str{n}casecmp

   Revision 1.4  1991/11/13  20:38:00  ian
   Added TCP port type for connections over TCP

   Revision 1.3  1991/11/07  20:32:04  ian
   Chip Salzenberg: allow ANSI_C to be defined in conf.h

   Revision 1.2  1991/11/07  18:21:47  ian
   Chip Salzenberg: move CMAXRETRIES to conf.h for easy configuration

   Revision 1.1  1991/09/10  19:47:55  ian
   Initial revision

   */

/* This code tries to use several ANSI C features, including
   prototypes, stdarg.h, the const qualifier and the types void
   (including void * pointers) and unsigned char.  By default it will
   use these features if the compiler defines __STDC__.  If your
   compiler supports these features but does not define __STDC__, you
   should define ANSI_C to 1.  If your compiler does not support these
   features but defines __STDC__ (no compiler should do this, in my
   opinion), you should define ANSI_C to 0.  In most cases (or if
   you're not sure) just leave the line below commented out.  */
/* #define ANSI_C 1 */

/* Set USE_RCS_ID to 1 if you want the RCS ID strings compiled into
   the executable.  */
#define USE_RCS_ID 1

/* Set DEBUG if you want to compile debugging information into the
   executable.  Defining it as 0 will remove all debugging information
   and checks.  Increasing numbers add more checks, up to 9.  */
#define DEBUG 9

/* Set USE_STDIO to 1 if data files should be read using the stdio
   routines (fopen, fread, etc.) rather than the UNIX unbuffered I/O
   calls (open, read, etc.).  Unless you know your stdio is really
   rotten, you should set this.  */
#define USE_STDIO 1

/* If USE_STDIO is set to 1, you must define BINREAD to be the string
   used to open and read a binary file and BINWRITE to be the string
   used to open and write a binary file.  The following definitions
   are correct if your libraries are ANSI C conformant.  On Unix the
   commented out definitions are fine.  */
#define BINREAD "rb"
#define BINWRITE "wb"
/* #define BINREAD "r" */
/* #define BINWRITE "w" */

/* Set HAVE_TCP to 1 to compile in support for TCP.  Your system must
   provide a Berkeley style socket interface for this to work.  On
   some systems you may have to add an entry to LIBS in Makefile.  */
#define HAVE_TCP 1

/* Set HAVE_UNISTD_H to 1 if you have the header file <unistd.h>.  */
#define HAVE_UNISTD_H 1

/* Set HAVE_STDLIB_H to 1 if you have the header file <stdlib.h>.  */
#define HAVE_STDLIB_H 1

/* Set HAVE_LIMITS_H to 1 if you have the header file <limits.h>.  */
#define HAVE_LIMITS_H 1

/* Set HAVE_ERRNO_DECLARATION to 1 if the extern variable errno is
   declared in <errno.h>.  It is not in some old BSD systems.  */
#define HAVE_ERRNO_DECLARATION 0

/* Set HAVE_VOID to 1 if the compiler supports the `void' type.  */
#define HAVE_VOID 1

/* Set HAVE_INT_SIGNALS to 1 if the return type of signal handlers is
   `int' rather than `void'.  */
#define HAVE_INT_SIGNALS 0

/* Set HAVE_TIME_H to 1 if you have the header file <time.h>.  */
#define HAVE_TIME_H 1

/* Set HAVE_TIME_T to 1 if the type time_t is defined in <time.h>, as
   is required by the ANSI C standard.  */
#define HAVE_TIME_T 1

/* Set HAVE_SYS_TIME_T to 1 if the type time_t is defined in
   <sys/types.h> rather than in <time.h>.  */
#define HAVE_SYS_TIME_T 0

/* Set HAVE_VPRINTF to 1 if the vprintf function is in the system
   library.  */
#define HAVE_VPRINTF 1

/* Set HAVE_RAISE to 1 if the ANSI C function raise function is in the
   system library.  */
#define HAVE_RAISE 1

/* Set HAVE_REMOVE to 1 if the remove function is in the system
   library.  */
#define HAVE_REMOVE 1

/* Set HAVE_STRDUP to 1 if the strdup function is in the system
   library.  */
#define HAVE_STRDUP 0

/* Set HAVE_STRSTR to 1 if the strstr function is in the system
   library.  */
#define HAVE_STRSTR 1

/* Set HAVE_STRCASECMP to 1 if the strcasecmp and strncasecmp
   functions are in the system library.  Alternatively, set
   HAVE_STRICMP to 1 if the stricmp and strnicmp functions are in the
   system library.  */
#define HAVE_STRCASECMP 1
#define HAVE_STRICMP 0

/* Set HAVE_STRERROR to 1 if the strerror function is in the system
   library.  */
#define HAVE_STRERROR 1

/* Set HAVE_MEMFNS to 1 if the memset, memcmp, memchr, and memcpy
   functions are in the system library.  Set HAVE_BFNS to 1 if the
   bcopy, bcmp and bzero functions are in the system library.  You may
   set either, both or neither to 1.  */
#define HAVE_MEMFNS 1
#define HAVE_BFNS 1

/* Set HAVE_MEMORY_H to 1 if the memory functions (memset, etc.) are
   in the system library but are defined in the header file <memory.h>
   rather than <string.h>.  */
#define HAVE_MEMORY_H 0

/* Set HAVE_MEMMOVE to 1 if the memmove function is in the system
   library.  (The memmove function on SCO Unix is said to be buggy; if
   you do not know that it has been patched, set this to 0).  */
#define HAVE_MEMMOVE 1

/* Set HAVE_STRCHR to 1 if the strchr and strrchr functions are in the
   system library.  Otherwise, set HAVE_INDEX to 1 if the index and
   rindex functions are in the system library.  */
#define HAVE_STRCHR 1
#define HAVE_INDEX 0

/* Set HAVE_STRTOL to 1 if the strtol function is in the system
   library.  */
#define HAVE_STRTOL 1

/* Set HAVE_BSEARCH to 1 if the bsearch function is in the system
   library.  */
#define HAVE_BSEARCH 1

/* Set HAVE_ALLOCA to 1 if the alloca function is in the system
   library, or if when compiling with gcc alloca can be safely
   redefined as __builtin_alloca.  If you are compiling with gcc and
   you set this to 0, alloca will not be redefined but the replacement
   alloca function will also not be included.  This means that alloca
   should be defined as __builtin_alloca in some header file, which is
   apparently the case on the NeXT.  */
#define HAVE_ALLOCA 1

/* Set NEED_ALLOCA_H to 1 if the header file <alloca.h> must be
   included to use the alloca function.  */
#define NEED_ALLOCA_H 0

/* Set the default grade to use for a uucp command if the -g option is
   not used.  */
#define BDEFAULT_UUCP_GRADE ('n')

/* Set the default grade to use for a uux command if the -g option is
   not used.  */
#define BDEFAULT_UUX_GRADE ('A')

/* The maximum number of times to retry calling a system which is not
   answering.  If this many calls to the system have failed, the
   system will not be called again until the status file has been
   removed (on a Unix system the status file is in the .Status
   subdirectory of the main spool directory, and has the same name as
   the system name).  If this is set to 0 the system may be called
   regardless of how many previous calls have failed.  */
#define CMAXRETRIES (26)

/* To compile in support for reading the new style of configuration
   files described in the file CONFIG, set HAVE_TAYLOR_CONFIG to 1.
   The default configuration file names are defined in the system
   dependent header file, sysdep.h.  */
#define HAVE_TAYLOR_CONFIG 1

/* To compile in support for reading V2 style configuration files
   (L.sys, L-devices and so on), set HAVE_V2_CONFIG to 1.  To compile
   in support for reading BNU style configuration files (Systems,
   Devices and so on) set HAVE_BNU_CONFIG to 1.  The files will be
   looked up in the oldconfigdir directory, which is defined in the
   Makefile.  */
#define HAVE_V2_CONFIG 0
#define HAVE_BNU_CONFIG 0

/* You must select which type of logging you want by setting exactly
   one of the following to 1.  These control output to the log file
   and to the statistics file.

   If you define HAVE_TAYLOR_LOGGING, each line in the log file will
   look something like this:

   uucico uunet uucp (Dec 10 09:04 16390) Receiving uunet/D./D.uunetSwJ72

   and each line in the statistics file will look something like this:

   uucp uunet (Dec 10 09:04) received 2371 bytes in 5 seconds (474 bytes/sec)

   If you define HAVE_V2_LOGGING, each line in the log file will look
   something like this:

   uucico uunet uucp (12/10-09:04 16390) Receiving uunet/D./D.uunetSwJ72

   and each line in the statistics file will look something like this:

   uucp uunet (12/10-09:04 16390) (692373862) received data 2371 bytes 5 seconds

   If you define HAVE_BNU_LOGGING, each program will by default use a
   separate log file.  For uucico talking to uunet, for example, it
   will be /usr/spool/uucp/.Log/uucico/uunet.  Each line will look
   something like this:

   uucp uunet (12/10-09:04:22,16390,1) Receiving uunet/D./D.uunetSwJ72

   and each line in the statistics file will look something like this:

   uunet!uucp M (12/10-09:04:22) (C,16390,1) [ttyXX] <- 2371 / 5.000 secs, 474 bytes/sec

   The main reason to prefer one format over another is that you may
   have shell scripts which expect the files to have a particular
   format.  If you have none, choose whichever format you find more
   appealing.  */
#define HAVE_TAYLOR_LOGGING 1
#define HAVE_V2_LOGGING 0
#define HAVE_BNU_LOGGING 0
