/* lintoulaw.c - convert linear to ulaw
**
** Copyright (C) 1989 by Jef Poskanzer.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
*/

#include <stdio.h>
#include "libst.h"

#define MYBUFSIZ 256

main( argc, argv )
int argc;
char *argv[];
    {
    FILE *f;
    char mybuf[MYBUFSIZ];
    double atof();
    int c;
    float lc;

    if ( argc == 1 )
	f = stdin;
    else if ( argc == 2 )
	{
	f = fopen( argv[1], "r" );
	if ( f == NULL )
	    {
	    perror( argv[1] );
	    exit( 1 );
	    }
	}
    else
	{
	fprintf( stderr, "usage:  %s [<file>]\n", argv[0] );
	exit( 1 );
	}
    setbuffer( stdout, mybuf, MYBUFSIZ );

    while ( fscanf( f, "%g", &lc ) == 1 )
	{
	c = st_linear_to_ulaw( (int) lc );
	putchar( c );
	}

    exit( 0 );
    }
