USE GsEventLogGathererDB
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[AlertInstance_ins]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
drop trigger [dbo].[AlertInstance_ins]
GO

/*
trigger:	AlertInstance_ins
versions:	1.5
author: 	chriss
date:		12/5/2002
description:	1) get the cursor holding all rows in the inserted table
		2) for every row execute xp_sendmail
Side effects:	sends emails using SQL mail
*/
CREATE TRIGGER [AlertInstance_ins] ON [dbo].[AlertInstance] 
FOR INSERT
AS

	DECLARE @EmailTo VARCHAR(100)
	DECLARE @EmailSubject VARCHAR(255)
	DECLARE @EmailBody VARCHAR(4000)
	
	DECLARE cur2 CURSOR
	FOR
	SELECT
		EmailTo
		,EmailSubject
		,EmailBody
	FROM	inserted
	FOR READ ONLY

	OPEN cur2

	FETCH NEXT FROM cur2 INTO @EmailTo, @EmailSubject, @EmailBody
	WHILE @@FETCH_STATUS = 0 BEGIN
		EXEC master..xp_sendmail 
			@recipients = @EmailTo 
		   	,@message = @EmailBody
		   	,@subject = @EmailSubject

		FETCH NEXT FROM cur2 INTO @EmailTo, @EmailSubject, @EmailBody
	END
	
	close cur2
	deallocate cur2

GO

