/****************************************************************************
 *
 * Class:  StringBrowser
 * Author: Mark Roseman
 * 
 * This class is a file browser customized a bit to provide more of the
 * interface from the 2.6 StringBrowser.
 *
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 08/14/92 MR        initial version
 *
 ****************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */

#ifndef __strbrowser_h
#define __strbrowser_h

#include <IV-look/fbrowser.h>


class StringBrowser : public FileBrowser {
public:
  StringBrowser(WidgetKit*, Action*, Action*);
  void Append(const char*);
  void Append(Glyph*);
  void Remove(int index);
  int Count();
  void Clear();
  virtual void select(GlyphIndex);
protected:
  Action* selAction_;
  WidgetKit* kit_;
};


#endif

