/**************************************************************************
 * 
 * Class:  CursorOverlay
 * Author: Mark Roseman
 * 
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 05/28/92 MR        initial version
 * 10/22/92 MR        added stuff for colors, etc.
 *
 **************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */

#ifndef __cursor_h
#define __cursor_h

#include <gk/overlay.h>
#include <gk/confmonitor.h>

class CursorOverlay : public Overlay, public ConferenceMonitor {
public:
	CursorOverlay(ActiveHandler*, class Style*, class Conference*);
	virtual void move(const Event& e);
	virtual void drag(const Event& e);
	virtual void enter();
	virtual void leave();
	virtual void moveCursor(int id, int x, int y);
	virtual void remoteMove(char *);
	virtual void newUser(class AttributeList*);
	virtual void userLeaving(int id);
protected:
	class Patch* patch_;
	class Page* pg_;
	class IndexTbl* tbl_;
	boolean localBitmapCursor;
	boolean localRealCursor;
	class Cursor* window_cursor_;
};

#endif
