/**************************************************************************
 * 
 * Class:  Overlay
 * Author: Mark Roseman
 * 
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 05/28/92 MR        initial version
 *
 **************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */

#ifndef __overlay_h
#define __overlay_h

#include <InterViews/input.h>
#include <InterViews/handler.h>
#include <InterViews/event.h>


class Overlay : public ActiveHandler, public Handler {
public:
  Overlay(ActiveHandler* g, class Style*, class Conference*);
  virtual void move(const Event&);
  virtual void press(const Event&);
  virtual void drag(const Event&);
  virtual void release(const Event&);
  virtual void keystroke(const Event&);
  virtual void double_click(const Event&);
  virtual void enter();
  virtual void leave();
  class Conference* conference();

protected:
  virtual void pick(Canvas* c, const Allocation& a, int depth, Hit& h);
  virtual void draw(Canvas* c, const Allocation& a) const;
  virtual void allocate(Canvas* c, const Allocation& a, Extension& ext);
  virtual const Allocation& allocation() const; 
  virtual void request(Requisition&) const;
  virtual boolean event(Event&);
  Allocation alloc_;
  void down(Event&);
  void up(Event&);
  void motion(Event&);
  class Conference* conf_;
  Glyph* inner_;
  boolean am_inside_ : 1;
  boolean pressed_ : 1;
  boolean recorded_time_ : 1; 
  boolean have_entered_ : 1; 
  boolean processing_event_ : 1;
  Handler* next_in_line_;
  EventButton button_;
  unsigned long click_time_;
};

#endif
