/**************************************************************************
 *
 * Class:  Reader
 * Author: Mark Roseman
 * 
 * This is a modification of the InterViews/Dispatch RpcReader class,
 * allowing for more general function headers.  RpcReader requires
 * function headers to begin at 0 and extend to the number of functions,
 * whereas this class allows discontinuous numbering.
 * 
 * It also doesn't need to know the number of functions ahead of time
 * (i.e. at class instantiation time), so its easier to subclass these.
 * 
 * The function number to callback function mapping is stored in a
 * hash table provided by the InterViews OS/table class.
 * 
 * 
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 02/17/92 MR        initial version
 * 05/28/92 MR        changed to do callbacks from a table, eliminates
 *                    inheritance stuff..
 * 08/14/92 MR        clean up
 * 09/17/92 MR        added hook to do callback on connection closed
 *  
 ***************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */

#ifndef _reader__h
#define _reader__h

#include <gk/straction.h>
#include <gk/rpcaction.h>
#include <OS/table.h>

declareTable(ReaderCallbackTable, int, StrAction*);

#include <Dispatch/rpcreader.h>

class CallbackRpcReader : public RpcReader {
public:

  /* 
  ** constructor / destructor
  */
  CallbackRpcReader(rpcstream*, ReaderCallbackTable* = nil, int id=-1, 
		    RpcAction* = nil);
  CallbackRpcReader(int fd, boolean binary, ReaderCallbackTable* = nil, 
		    int id=-1, RpcAction* = nil);
  virtual ~CallbackRpcReader();

  /*
  ** add a callback to the table
  */
  virtual void registerCallback( StrAction*, int cb_id_num );

  /*
  ** access method
  */
  int id();

  /*
  ** alternate way to set the connection closed callback
  */
  void closeCallback( RpcAction* );

protected:
  virtual int inputReady(int);
  virtual void connectionClosed(int);
  ReaderCallbackTable* callbacks_;
  int id_;
  boolean myexecute(CallbackRpcReader*, RpcHdr&);
  RpcAction* closeCallback_;
};

#endif

