/***************************************************************************
 *
 * Class:  StrAction
 * Author: Mark Roseman
 *
 * An action whose execute function takes a string parameter.  This is used
 * in various places in GroupKit.
 * 
 * This code is based on ...iv/src/include/InterViews/action.h in the 
 * InterViews distribution.
 *
 *
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 05/29/92 MR        initial version
 * 08/14/92 MR        clean up
 * 
 ***************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */

#ifndef __straction_h
#define __straction_h

#include <InterViews/resource.h>


class StrAction : public Resource {
protected:
    StrAction() {}
    virtual ~StrAction() {}
public:
    virtual void execute(char *) = 0;
};


/*
 * StrAction denoted by an object and member function to call on the object.
 */

#if defined(__STDC__) || defined(__ANSI_CPP__)
#define __StrActionCallback(T) T##_StrActionCallback
#define StrActionCallback(T) __StrActionCallback(T)
#define __StrActionMemberFunction(T) T##_StrActionMemberFunction
#define StrActionMemberFunction(T) __StrActionMemberFunction(T)
#else
#define __StrActionCallback(T) T/**/_StrActionCallback
#define StrActionCallback(T) __StrActionCallback(T)
#define __StrActionMemberFunction(T) T/**/_StrActionMemberFunction
#define StrActionMemberFunction(T) __StrActionMemberFunction(T)
#endif

#define declareStrActionCallback(T) \
typedef void T::StrActionMemberFunction(T)(char *); \
class StrActionCallback(T) : public StrAction { \
public: \
    StrActionCallback(T)(T*, StrActionMemberFunction(T)*); \
\
    virtual void execute(char *); \
private: \
    T* obj_; \
    StrActionMemberFunction(T)* func_; \
};

#define implementStrActionCallback(T) \
StrActionCallback(T)::StrActionCallback(T)(T* obj, StrActionMemberFunction(T)* func) { \
    obj_ = obj; \
    func_ = func; \
} \
\
void StrActionCallback(T)::execute(char *s) { (obj_->*func_)(s); }

#endif
